/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.geo;

import com.mongodb.client.model.geojson.PolygonCoordinates;
import dev.morphia.geo.CoordinateReferenceSystem;
import dev.morphia.geo.Geometry;
import dev.morphia.geo.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiPolygon
implements Geometry {
    private final List<Polygon> coordinates;

    private MultiPolygon() {
        this.coordinates = new ArrayList<Polygon>();
    }

    MultiPolygon(Polygon ... polygons) {
        this.coordinates = Arrays.asList(polygons);
    }

    MultiPolygon(List<Polygon> polygons) {
        this.coordinates = polygons;
    }

    public List<Polygon> getCoordinates() {
        return this.coordinates;
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiPolygon that = (MultiPolygon)o;
        return this.coordinates.equals(that.coordinates);
    }

    public String toString() {
        return "MultiPolygon{coordinates=" + this.coordinates + '}';
    }

    @Override
    public com.mongodb.client.model.geojson.MultiPolygon convert() {
        return this.convert(null);
    }

    @Override
    public com.mongodb.client.model.geojson.MultiPolygon convert(CoordinateReferenceSystem crs) {
        ArrayList<PolygonCoordinates> coords = new ArrayList<PolygonCoordinates>();
        for (Polygon list : this.coordinates) {
            coords.add(list.convert(crs).getCoordinates());
        }
        return new com.mongodb.client.model.geojson.MultiPolygon(crs != null ? crs.convert() : null, coords);
    }
}

