/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.annotations.Serialized;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.MappingException;
import dev.morphia.mapping.Serializer;
import java.io.IOException;
import org.bson.types.Binary;

public class SerializedObjectConverter
extends TypeConverter {
    public Object decode(Class targetClass, Object fromDBObject, MappedField f) {
        if (fromDBObject == null) {
            return null;
        }
        if (!(fromDBObject instanceof Binary) && !(fromDBObject instanceof byte[])) {
            throw new MappingException(String.format("The stored data is not a DBBinary or byte[] instance for %s ; it is a %s", f.getFullName(), fromDBObject.getClass().getName()));
        }
        try {
            boolean useCompression = !f.getAnnotation(Serialized.class).disableCompression();
            return Serializer.deserialize(fromDBObject, useCompression);
        }
        catch (IOException e) {
            throw new MappingException("While deserializing to " + f.getFullName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("While deserializing to " + f.getFullName(), e);
        }
    }

    @Override
    public Object encode(Object value, MappedField f) {
        if (value == null) {
            return null;
        }
        try {
            boolean useCompression = !f.getAnnotation(Serialized.class).disableCompression();
            return Serializer.serialize(value, useCompression);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean isSupported(Class c, MappedField optionalExtraInfo) {
        return optionalExtraInfo != null && optionalExtraInfo.hasAnnotation(Serialized.class);
    }
}

