/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.utils.IterHelper;
import dev.morphia.utils.ReflectionUtils;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapOfValuesConverter
extends TypeConverter {
    public Object decode(Class targetClass, Object fromDBObject, final MappedField mf) {
        if (fromDBObject == null) {
            return null;
        }
        final Map values = this.getMapper().getOptions().getObjectFactory().createMap(mf);
        new IterHelper<Object, Object>().loopMap(fromDBObject, new IterHelper.MapIterCallback<Object, Object>(){

            @Override
            public void eval(Object k, Object val2) {
                Object objKey = MapOfValuesConverter.this.getMapper().getConverters().decode(mf.getMapKeyClass(), k, mf);
                values.put(objKey, val2 != null ? MapOfValuesConverter.this.getMapper().getConverters().decode(mf.getSubClass(), val2, mf) : null);
            }
        });
        return values;
    }

    @Override
    public Object encode(Object value, MappedField mf) {
        if (value == null) {
            return null;
        }
        Map map = (Map)value;
        if (!map.isEmpty() || this.getMapper().getOptions().isStoreEmpties()) {
            LinkedHashMap<String, Object> mapForDb = new LinkedHashMap<String, Object>();
            for (Map.Entry entry : map.entrySet()) {
                String strKey = this.getMapper().getConverters().encode(entry.getKey()).toString();
                mapForDb.put(strKey, this.getMapper().getConverters().encode(entry.getValue()));
            }
            return mapForDb;
        }
        return null;
    }

    @Override
    protected boolean isSupported(Class<?> c, MappedField optionalExtraInfo) {
        if (optionalExtraInfo != null) {
            return optionalExtraInfo.isMap();
        }
        return ReflectionUtils.implementsInterface(c, Map.class);
    }
}

