/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.utils.ReflectionUtils;
import java.util.List;

public class LongConverter
extends TypeConverter
implements SimpleValueConverter {
    public LongConverter() {
        super(Long.TYPE, Long.class, long[].class, Long[].class);
    }

    public Object decode(Class targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Long) {
            return val2;
        }
        if (val2 instanceof Number) {
            return ((Number)val2).longValue();
        }
        if (val2 instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return ReflectionUtils.convertToArray(type, (List)val2);
        }
        return Long.parseLong(val2.toString());
    }
}

