/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.time.LocalTime;

public class LocalTimeConverter
extends TypeConverter
implements SimpleValueConverter {
    private static final int MILLI_MODULO = 1000000;

    public LocalTimeConverter() {
        super(LocalTime.class);
    }

    @Override
    public Object decode(Class<?> targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof LocalTime) {
            return val2;
        }
        if (val2 instanceof Number) {
            return LocalTime.ofNanoOfDay(((Number)val2).longValue() * 1000000L);
        }
        throw new IllegalArgumentException("Can't convert to LocalTime from " + val2);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        LocalTime time = (LocalTime)value;
        return time.toNanoOfDay() / 1000000L;
    }
}

