/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;
import java.time.LocalDateTime;
import java.util.Date;

public class LocalDateTimeConverter
extends TypeConverter
implements SimpleValueConverter {
    private Mapper mapper;

    public LocalDateTimeConverter(Mapper mapper) {
        super(LocalDateTime.class);
        this.mapper = mapper;
    }

    @Override
    public Object decode(Class<?> targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof LocalDateTime) {
            return val2;
        }
        if (val2 instanceof Date) {
            return LocalDateTime.ofInstant(((Date)val2).toInstant(), this.mapper.getOptions().getDateStorage().getZone());
        }
        throw new IllegalArgumentException("Can't convert to LocalDateTime from " + val2);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return Date.from(((LocalDateTime)value).atZone(this.mapper.getOptions().getDateStorage().getZone()).toInstant());
    }
}

