/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.utils.ReflectionUtils;
import java.util.List;

public class IntegerConverter
extends TypeConverter
implements SimpleValueConverter {
    public IntegerConverter() {
        super(Integer.TYPE, Integer.class, int[].class, Integer[].class);
    }

    public Object decode(Class targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Integer) {
            return val2;
        }
        if (val2 instanceof Number) {
            return ((Number)val2).intValue();
        }
        if (val2 instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return ReflectionUtils.convertToArray(type, (List)val2);
        }
        return Integer.parseInt(val2.toString());
    }
}

