/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.time.Instant;
import java.util.Date;

public class InstantConverter
extends TypeConverter
implements SimpleValueConverter {
    public InstantConverter() {
        super(Instant.class);
    }

    @Override
    public Object decode(Class<?> targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Instant) {
            return val2;
        }
        if (val2 instanceof Date) {
            return ((Date)val2).toInstant();
        }
        throw new IllegalArgumentException("Can't convert to Instant from " + val2);
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        return Date.from((Instant)value);
    }
}

