/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.lang.reflect.Array;
import java.util.List;

public class FloatConverter
extends TypeConverter
implements SimpleValueConverter {
    public FloatConverter() {
        super(Float.TYPE, Float.class, float[].class, Float[].class);
    }

    public Object decode(Class targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Float) {
            return val2;
        }
        if (val2 instanceof Number) {
            return Float.valueOf(((Number)val2).floatValue());
        }
        if (val2 instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return this.convertToArray(type, (List)val2);
        }
        return Float.valueOf(Float.parseFloat(val2.toString()));
    }

    private Object convertToArray(Class type, List<?> values) {
        Object array = Array.newInstance(type, values.size());
        try {
            return values.toArray((Object[])array);
        }
        catch (Exception e) {
            for (int i = 0; i < values.size(); ++i) {
                Array.set(array, i, this.decode(Float.class, values.get(i)));
            }
            return array;
        }
    }
}

