/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.utils.ReflectionUtils;
import java.util.List;

public class DoubleConverter
extends TypeConverter
implements SimpleValueConverter {
    public DoubleConverter() {
        super(Double.TYPE, Double.class, double[].class, Double[].class);
    }

    public Object decode(Class targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2 instanceof Double) {
            return val2;
        }
        if (val2 instanceof Number) {
            return ((Number)val2).doubleValue();
        }
        if (val2 instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return ReflectionUtils.convertToArray(type, (List)val2);
        }
        return Double.parseDouble(val2.toString());
    }
}

