/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.ConverterNotFoundException;
import dev.morphia.converters.Converters;
import dev.morphia.converters.DefaultConverters;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import dev.morphia.mapping.Mapper;

public class CustomConverters
extends Converters {
    private final DefaultConverters defaultConverters;

    public CustomConverters(Mapper mapper) {
        super(mapper);
        this.defaultConverters = new DefaultConverters(mapper);
    }

    @Override
    public boolean isRegistered(Class<? extends TypeConverter> tcClass) {
        return super.isRegistered(tcClass) || this.defaultConverters.isRegistered(tcClass);
    }

    @Override
    public void removeConverter(TypeConverter tc) {
        super.removeConverter(tc);
        this.defaultConverters.removeConverter(tc);
    }

    @Override
    protected TypeConverter getEncoder(Class c) {
        TypeConverter encoder = super.getEncoder(c);
        if (encoder == null) {
            encoder = this.defaultConverters.getEncoder(c);
        }
        if (encoder != null) {
            return encoder;
        }
        throw new ConverterNotFoundException(String.format("Cannot find encoder for %s", c.getName()));
    }

    @Override
    protected TypeConverter getEncoder(Object val2, MappedField mf) {
        TypeConverter encoder = super.getEncoder(val2, mf);
        if (encoder == null) {
            encoder = this.defaultConverters.getEncoder(val2, mf);
        }
        if (encoder != null) {
            return encoder;
        }
        throw new ConverterNotFoundException(String.format("Cannot find encoder for %s as need for %s", mf.getType(), mf.getFullName()));
    }
}

