/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.converters;

import dev.morphia.converters.SimpleValueConverter;
import dev.morphia.converters.TypeConverter;
import dev.morphia.mapping.MappedField;
import java.lang.reflect.Array;

public class ByteConverter
extends TypeConverter
implements SimpleValueConverter {
    public ByteConverter() {
        super(Byte.TYPE, Byte.class, byte[].class, Byte[].class);
    }

    public Object decode(Class targetClass, Object val2, MappedField optionalExtraInfo) {
        if (val2 == null) {
            return null;
        }
        if (val2.getClass().equals(targetClass)) {
            return val2;
        }
        if (val2 instanceof Number) {
            return ((Number)val2).byteValue();
        }
        if (targetClass.isArray() && val2.getClass().equals(byte[].class)) {
            return this.convertToWrapperArray((byte[])val2);
        }
        return Byte.parseByte(val2.toString());
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value instanceof Byte[]) {
            return super.encode(this.convertToPrimitiveArray((Byte[])value), optionalExtraInfo);
        }
        return super.encode(value, optionalExtraInfo);
    }

    Object convertToPrimitiveArray(Byte[] values) {
        int length = values.length;
        Object array = Array.newInstance(Byte.TYPE, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, values[i]);
        }
        return array;
    }

    Object convertToWrapperArray(byte[] values) {
        int length = values.length;
        Object array = Array.newInstance(Byte.class, length);
        for (int i = 0; i < length; ++i) {
            Array.set(array, i, values[i]);
        }
        return array;
    }
}

