/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import dev.morphia.aggregation.AggregationElement;
import java.util.ArrayList;
import java.util.List;

public class Accumulator
implements AggregationElement {
    private final String operation;
    private final Object value;

    public Accumulator(String operation, String field) {
        this(operation, (Object)("$" + field));
    }

    public Accumulator(String operation, Object field) {
        this.operation = operation;
        this.value = field;
    }

    public static Accumulator accumulator(String operation, String field) {
        return new Accumulator(operation, field);
    }

    public static Accumulator accumulator(String operation, Object field) {
        return new Accumulator(operation, field);
    }

    @Deprecated
    public Object getField() {
        return this.getValue();
    }

    public String getOperation() {
        return this.operation;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public DBObject toDBObject() {
        BasicDBObject dbObject = new BasicDBObject();
        if (this.value instanceof List) {
            ArrayList<DBObject> dbValue = new ArrayList<DBObject>();
            for (Object o : (List)this.value) {
                if (o instanceof AggregationElement) {
                    dbValue.add(((AggregationElement)o).toDBObject());
                    continue;
                }
                dbValue.add((DBObject)o);
            }
            dbObject.put(this.operation, dbValue);
        } else if (this.value instanceof AggregationElement) {
            dbObject.put(this.operation, ((AggregationElement)this.value).toDBObject());
        } else {
            dbObject.put(this.operation, this.value);
        }
        return dbObject;
    }
}

