/*
 * Decompiled with CFR 0.152.
 */
package dev.morphia;

import dev.morphia.AnnotationBuilder;
import dev.morphia.annotations.Collation;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.IndexOptions;
import dev.morphia.annotations.Indexed;
import java.util.Map;
import org.bson.Document;

class IndexOptionsBuilder
extends AnnotationBuilder<IndexOptions>
implements IndexOptions {
    IndexOptionsBuilder() {
    }

    IndexOptionsBuilder(IndexOptions original, String prefix) {
        super(original);
        if (!"".equals(original.partialFilter())) {
            Document parse = Document.parse(original.partialFilter());
            Document filter = new Document();
            for (Map.Entry<String, Object> entry : parse.entrySet()) {
                filter.put(prefix + "." + entry.getKey(), entry.getValue());
            }
            this.partialFilter(filter.toJson());
        }
    }

    @Override
    public Class<IndexOptions> annotationType() {
        return IndexOptions.class;
    }

    @Override
    public boolean background() {
        return (Boolean)this.get("background");
    }

    @Override
    public boolean disableValidation() {
        return (Boolean)this.get("disableValidation");
    }

    @Override
    public boolean dropDups() {
        return (Boolean)this.get("dropDups");
    }

    @Override
    public int expireAfterSeconds() {
        return (Integer)this.get("expireAfterSeconds");
    }

    @Override
    public String language() {
        return (String)this.get("language");
    }

    @Override
    public String languageOverride() {
        return (String)this.get("languageOverride");
    }

    @Override
    public String name() {
        return (String)this.get("name");
    }

    @Override
    public boolean sparse() {
        return (Boolean)this.get("sparse");
    }

    @Override
    public boolean unique() {
        return (Boolean)this.get("unique");
    }

    @Override
    public String partialFilter() {
        return (String)this.get("partialFilter");
    }

    @Override
    public Collation collation() {
        return (Collation)this.get("collation");
    }

    IndexOptionsBuilder background(boolean background) {
        this.put("background", background);
        return this;
    }

    IndexOptionsBuilder disableValidation(boolean disableValidation) {
        this.put("disableValidation", disableValidation);
        return this;
    }

    IndexOptionsBuilder dropDups(boolean dropDups) {
        this.put("dropDups", dropDups);
        return this;
    }

    IndexOptionsBuilder expireAfterSeconds(int expireAfterSeconds) {
        this.put("expireAfterSeconds", expireAfterSeconds);
        return this;
    }

    IndexOptionsBuilder language(String language) {
        this.put("language", language);
        return this;
    }

    IndexOptionsBuilder languageOverride(String languageOverride) {
        this.put("languageOverride", languageOverride);
        return this;
    }

    IndexOptionsBuilder name(String name) {
        this.put("name", name);
        return this;
    }

    IndexOptionsBuilder sparse(boolean sparse) {
        this.put("sparse", sparse);
        return this;
    }

    IndexOptionsBuilder unique(boolean unique) {
        this.put("unique", unique);
        return this;
    }

    IndexOptionsBuilder partialFilter(String partialFilter) {
        this.put("partialFilter", partialFilter);
        return this;
    }

    IndexOptionsBuilder collation(Collation collation) {
        this.put("collation", collation);
        return this;
    }

    IndexOptionsBuilder migrate(Index index) {
        this.putAll(IndexOptionsBuilder.toMap(index));
        return this;
    }

    IndexOptionsBuilder migrate(Indexed index) {
        this.putAll(IndexOptionsBuilder.toMap(index));
        return this;
    }
}

