/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.process.runtime;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import de.flapdoodle.embed.process.collections.Collections;
import de.flapdoodle.embed.process.config.ISupportConfig;
import de.flapdoodle.embed.process.config.process.ProcessConfig;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.io.IStreamProcessor;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Processes {
    private static Logger logger = LoggerFactory.getLogger(ProcessControl.class);
    private static final PidHelper PID_HELPER = Processes.processHasPidMethod() ? PidHelper.PID_METHOD : PidHelper.LEGACY;

    private static boolean processHasPidMethod() {
        try {
            Process.class.getMethod("pid", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Processes() {
    }

    public static Long processId(Process process) {
        return PID_HELPER.getPid(process);
    }

    private static Long unixLikeProcessId(Process process) {
        Class<?> clazz = process.getClass();
        try {
            if (SystemUtils.IS_OS_UNIX) {
                Field pidField = clazz.getDeclaredField("pid");
                pidField.setAccessible(true);
                Object value = pidField.get(process);
                if (value instanceof Integer) {
                    logger.debug("Detected pid: {}", value);
                    return ((Integer)value).longValue();
                }
            }
        }
        catch (SecurityException sx) {
            logger.debug("Could not determine pid", sx);
        }
        catch (NoSuchFieldException e) {
            logger.debug("Could not determine pid", e);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Could not determine pid", e);
        }
        catch (IllegalAccessException e) {
            logger.debug("Could not determine pid", e);
        }
        return null;
    }

    private static Long windowsProcessId(Process process) {
        if (process.getClass().getName().equals("java.lang.Win32Process") || process.getClass().getName().equals("java.lang.ProcessImpl")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                Kernel32 kernel = Kernel32.INSTANCE;
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant(handl));
                int ret = kernel.GetProcessId(handle);
                logger.debug("Detected pid: {}", (Object)ret);
                return ret;
            }
            catch (Throwable e) {
                logger.debug("Could not determine pid", e);
            }
        }
        return null;
    }

    public static boolean killProcess(ISupportConfig support, Platform platform, IStreamProcessor output, long pid) {
        if (platform.isUnixLike()) {
            return ProcessControl.executeCommandLine(support, "[kill process]", new ProcessConfig(Collections.newArrayList("kill", "-2", "" + pid), output));
        }
        return false;
    }

    public static boolean termProcess(ISupportConfig support, Platform platform, IStreamProcessor output, long pid) {
        if (platform.isUnixLike()) {
            return ProcessControl.executeCommandLine(support, "[term process]", new ProcessConfig(Collections.newArrayList("kill", "" + pid), output));
        }
        return false;
    }

    public static boolean tryKillProcess(ISupportConfig support, Platform platform, IStreamProcessor output, long pid) {
        if (platform == Platform.Windows) {
            return ProcessControl.executeCommandLine(support, "[taskkill process]", new ProcessConfig(Collections.newArrayList("taskkill", "/F", "/pid", "" + pid), output));
        }
        return false;
    }

    public static boolean isProcessRunning(Platform platform, long pid) {
        try {
            if (platform.isUnixLike()) {
                Process pidof = Runtime.getRuntime().exec(new String[]{"kill", "-0", "" + pid});
                return pidof.waitFor() == 0;
            }
            String[] cmd = new String[]{"tasklist.exe", "/FI", "PID eq " + pid, "/FO", "CSV"};
            logger.trace("Command: {}", (Object)Arrays.asList(cmd));
            ProcessBuilder processBuilder = ProcessControl.newProcessBuilder(Arrays.asList(cmd), true);
            Process process = processBuilder.start();
            LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor("" + pid, new HashSet<String>(), StreamToLineProcessor.wrap(Processors.silent()));
            Processors.connect(new InputStreamReader(process.getInputStream()), logWatch);
            logWatch.waitForResult(2000L);
            logger.trace("logWatch output: {}", (Object)logWatch.getOutput());
            return logWatch.isInitWithSuccess();
        }
        catch (IOException | InterruptedException e) {
            logger.error("Trying to get process status", e);
            return false;
        }
    }

    private static enum PidHelper {
        PID_METHOD{

            @Override
            Long getPid(Process process) {
                try {
                    Method pid = Process.class.getMethod("pid", new Class[0]);
                    return (Long)pid.invoke((Object)process, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }
        ,
        LEGACY{

            @Override
            Long getPid(Process process) {
                Long pid = Processes.unixLikeProcessId(process);
                if (pid == null) {
                    pid = Processes.windowsProcessId(process);
                }
                return pid;
            }
        };


        abstract Long getPid(Process var1);
    }
}

