/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.Storage;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.config.processlistener.IMongoProcessListener;
import de.flapdoodle.embed.mongo.config.processlistener.NoopProcessListener;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public class MongodConfigBuilder
extends AbstractMongoConfigBuilder<IMongodConfig> {
    protected static final TypedProperty<Storage> REPLICATION = TypedProperty.with("Replication", Storage.class);
    protected static final TypedProperty<Boolean> CONFIG_SERVER = TypedProperty.with("ConfigServer", Boolean.class);
    protected static final TypedProperty<Boolean> SHARD_SERVER = TypedProperty.with("ShardServer", Boolean.class);
    protected static final TypedProperty<IMongoProcessListener> PROCESS_LISTENER = TypedProperty.with("ProcessListener", IMongoProcessListener.class);
    protected Map<String, String> params = new LinkedHashMap<String, String>();
    protected Map<String, String> args = new LinkedHashMap<String, String>();

    public MongodConfigBuilder() throws IOException {
        this.property(REPLICATION).setDefault(new Storage());
        this.property(CONFIG_SERVER).setDefault(false);
        this.property(SHARD_SERVER).setDefault(false);
        this.property(PROCESS_LISTENER).setDefault(new NoopProcessListener());
        this.property(PID_FILE).setDefault("mongod.pid");
    }

    public MongodConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set(version);
        return this;
    }

    public MongodConfigBuilder timeout(Timeout timeout) {
        this.timeout().set(timeout);
        return this;
    }

    public MongodConfigBuilder net(Net net) {
        this.net().set(net);
        return this;
    }

    public MongodConfigBuilder cmdOptions(IMongoCmdOptions cmdOptions) {
        this.cmdOptions().set(cmdOptions);
        return this;
    }

    public MongodConfigBuilder setParameter(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public MongodConfigBuilder withLaunchArgument(String name) {
        this.args.put(name, null);
        return this;
    }

    public MongodConfigBuilder withLaunchArgument(String name, String value) {
        this.args.put(name, value);
        return this;
    }

    public MongodConfigBuilder replication(Storage replication) {
        this.set(REPLICATION, replication);
        return this;
    }

    public MongodConfigBuilder configServer(boolean configServer) {
        this.set(CONFIG_SERVER, configServer);
        return this;
    }

    public MongodConfigBuilder shardServer(boolean shardServer) {
        this.set(SHARD_SERVER, shardServer);
        return this;
    }

    public MongodConfigBuilder processListener(IMongoProcessListener processListener) {
        this.set(PROCESS_LISTENER, processListener);
        return this;
    }

    public MongodConfigBuilder pidFile(String pidFile) {
        this.pidFile().set(pidFile);
        return this;
    }

    public MongodConfigBuilder stopTimeoutInMillis(long timeout) {
        this.stopTimeout().set(timeout);
        return this;
    }

    @Override
    public IMongodConfig build() {
        IFeatureAwareVersion version = this.version().get();
        Net net = this.net().get();
        Timeout timeout = this.timeout().get();
        Storage replication = this.get(REPLICATION);
        boolean configServer = this.get(CONFIG_SERVER);
        boolean shardServer = this.get(SHARD_SERVER);
        IMongoCmdOptions cmdOptions = (IMongoCmdOptions)this.get(CMD_OPTIONS);
        IMongoProcessListener processListener = this.get(PROCESS_LISTENER);
        String pidFile = (String)this.get(PID_FILE);
        Long stopTimeoutInMillis = (Long)this.get(STOP_TIMEOUT_MILLIS);
        return new ImmutableMongodConfig(version, net, timeout, cmdOptions, pidFile, replication, configServer, shardServer, processListener, stopTimeoutInMillis, this.params, this.args);
    }

    static class ImmutableMongodConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongodConfig {
        private final Storage _replication;
        private final boolean _configServer;
        private final boolean _shardServer;
        private final IMongoProcessListener _processListener;
        private final Map<String, String> _params;
        private final Map<String, String> _args;

        public ImmutableMongodConfig(IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile, Storage replication, boolean configServer, boolean shardServer, IMongoProcessListener processListener, long stopTimeoutInMillis, Map<String, String> params, Map<String, String> args) {
            super(new SupportConfig(Command.MongoD, stopTimeoutInMillis), version, net, null, null, timeout, cmdOptions, pidFile);
            this._replication = replication;
            this._configServer = configServer;
            this._shardServer = shardServer;
            this._processListener = processListener;
            this._params = new LinkedHashMap<String, String>(params);
            this._args = new LinkedHashMap<String, String>(args);
        }

        @Override
        public Storage replication() {
            return this._replication;
        }

        @Override
        public boolean isConfigServer() {
            return this._configServer;
        }

        @Override
        public boolean isShardServer() {
            return this._shardServer;
        }

        @Override
        public IMongoProcessListener processListener() {
            return this._processListener;
        }

        @Override
        public Map<String, String> params() {
            return Collections.unmodifiableMap(this._params);
        }

        @Override
        public Map<String, String> args() {
            return Collections.unmodifiableMap(this._args);
        }
    }
}

