/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.AbstractMongoConfigBuilder;
import de.flapdoodle.embed.mongo.config.IMongoCmdOptions;
import de.flapdoodle.embed.mongo.config.IMongoShellConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.config.SupportConfig;
import de.flapdoodle.embed.mongo.config.Timeout;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.builder.TypedProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MongoShellConfigBuilder
extends AbstractMongoConfigBuilder<IMongoShellConfig> {
    protected static final TypedProperty<String> JS_SCRIPT = TypedProperty.with("scriptName", String.class);
    protected static final TypedProperty<List> JS_SCRIPT_PARAMETERS = TypedProperty.with("parameters", List.class);

    public MongoShellConfigBuilder() throws IOException {
        this.property(PID_FILE).setDefault("mongo.pid");
    }

    public MongoShellConfigBuilder version(IFeatureAwareVersion version) {
        this.version().set(version);
        return this;
    }

    public MongoShellConfigBuilder timeout(Timeout timeout) {
        this.timeout().set(timeout);
        return this;
    }

    public MongoShellConfigBuilder username(String username) {
        this.username().set(username);
        return this;
    }

    public MongoShellConfigBuilder password(String password) {
        this.password().set(password);
        return this;
    }

    public MongoShellConfigBuilder net(Net net) {
        this.net().set(net);
        return this;
    }

    public MongoShellConfigBuilder dbName(String dbName) {
        this.dbName().set(dbName);
        return this;
    }

    public MongoShellConfigBuilder cmdOptions(IMongoCmdOptions cmdOptions) {
        this.cmdOptions().set(cmdOptions);
        return this;
    }

    public MongoShellConfigBuilder scriptName(String scriptName) {
        this.set(JS_SCRIPT, scriptName);
        return this;
    }

    public MongoShellConfigBuilder parameters(String ... parameters) {
        return this.parameters(Arrays.asList(parameters));
    }

    public MongoShellConfigBuilder parameters(List<String> parameters) {
        this.set(JS_SCRIPT_PARAMETERS, parameters);
        return this;
    }

    public MongoShellConfigBuilder stopTimeoutInMillis(long timeout) {
        this.stopTimeout().set(timeout);
        return this;
    }

    @Override
    public IMongoShellConfig build() {
        IFeatureAwareVersion version = this.version().get();
        Net net = this.net().get();
        Timeout timeout = this.timeout().get();
        IMongoCmdOptions cmdOptions = (IMongoCmdOptions)this.get(CMD_OPTIONS);
        String pidFile = (String)this.get(PID_FILE);
        String name = this.get(JS_SCRIPT, null);
        List parameters = this.get(JS_SCRIPT_PARAMETERS, new ArrayList());
        if (name == null && parameters.isEmpty()) {
            throw new RuntimeException("you must set parameters or scriptName");
        }
        Long stopTimeoutInMillis = (Long)this.get(STOP_TIMEOUT_MILLIS);
        return new ImmutableMongoShellConfig(version, net, timeout, cmdOptions, pidFile, name, this.username().get(), this.password().get(), this.dbName().get(), stopTimeoutInMillis, parameters);
    }

    static class ImmutableMongoShellConfig
    extends AbstractMongoConfigBuilder.ImmutableMongoConfig
    implements IMongoShellConfig {
        private final String _name;
        private final String _dbname;
        private final List<String> _parameters;

        public ImmutableMongoShellConfig(IFeatureAwareVersion version, Net net, Timeout timeout, IMongoCmdOptions cmdOptions, String pidFile, String scriptName, String username, String password, String dbName, Long stopTimeoutInMillis, List<String> parameters) {
            super(new SupportConfig(Command.Mongo, stopTimeoutInMillis), version, net, username, password, timeout, cmdOptions, pidFile);
            this._dbname = dbName;
            this._name = scriptName;
            this._parameters = Collections.unmodifiableList(new ArrayList<String>(parameters));
        }

        @Override
        public List<String> getScriptParameters() {
            return this._parameters;
        }

        @Override
        public String getScriptName() {
            return this._name;
        }

        @Override
        public String getDbName() {
            return this._dbname;
        }
    }
}

