/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.Paths;
import de.flapdoodle.embed.process.config.store.DownloadConfigBuilder;
import de.flapdoodle.embed.process.config.store.IDownloadPath;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Platform;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.FixedPath;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.io.directories.UserHome;
import de.flapdoodle.embed.process.io.progress.StandardConsoleProgressListener;
import java.util.Optional;

public class DownloadConfigBuilder
extends de.flapdoodle.embed.process.config.store.DownloadConfigBuilder {
    private final Optional<String> artifactDownloadLocationEnvironmentVariable;

    public DownloadConfigBuilder() {
        this(Optional.ofNullable(System.getenv().get("EMBEDDED_MONGO_ARTIFACTS")));
    }

    protected DownloadConfigBuilder(Optional<String> artifactDownloadLocationEnvironmentVariable) {
        this.artifactDownloadLocationEnvironmentVariable = artifactDownloadLocationEnvironmentVariable;
    }

    public DownloadConfigBuilder packageResolverForCommand(Command command) {
        this.packageResolver(new Paths(command));
        return this;
    }

    public DownloadConfigBuilder defaultsForCommand(Command command) {
        return this.defaults().packageResolverForCommand(command);
    }

    public DownloadConfigBuilder defaults() {
        this.fileNaming().setDefault(new UUIDTempNaming());
        this.downloadPath().setDefault(new PlatformDependentDownloadPath());
        this.progressListener().setDefault(new StandardConsoleProgressListener());
        this.artifactStorePath().setDefault(this.defaultArtifactDownloadLocation());
        this.downloadPrefix().setDefault(new DownloadConfigBuilder.DownloadPrefix("embedmongo-download"));
        this.userAgent().setDefault(new DownloadConfigBuilder.UserAgent("Mozilla/5.0 (compatible; Embedded MongoDB; +https://github.com/flapdoodle-oss/embedmongo.flapdoodle.de)"));
        return this;
    }

    private IDirectory defaultArtifactDownloadLocation() {
        if (this.artifactDownloadLocationEnvironmentVariable.isPresent()) {
            return new FixedPath(this.artifactDownloadLocationEnvironmentVariable.get());
        }
        return new UserHome(".embedmongo");
    }

    private static class PlatformDependentDownloadPath
    implements IDownloadPath {
        private PlatformDependentDownloadPath() {
        }

        @Override
        public String getPath(Distribution distribution) {
            if (distribution.getPlatform() == Platform.Windows) {
                return "https://downloads.mongodb.org/";
            }
            return "https://fastdl.mongodb.org/";
        }
    }
}

