/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo;

import de.flapdoodle.embed.mongo.config.IMongoConfig;
import de.flapdoodle.embed.mongo.runtime.Mongod;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.config.io.ProcessOutput;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.io.LogWatchStreamProcessor;
import de.flapdoodle.embed.process.io.Processors;
import de.flapdoodle.embed.process.io.StreamToLineProcessor;
import de.flapdoodle.embed.process.runtime.AbstractProcess;
import de.flapdoodle.embed.process.runtime.Executable;
import de.flapdoodle.embed.process.runtime.IStopable;
import de.flapdoodle.embed.process.runtime.ProcessControl;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoProcess<T extends IMongoConfig, E extends Executable<T, P>, P extends IStopable>
extends AbstractProcess<T, E, P> {
    private static Logger logger = LoggerFactory.getLogger(AbstractMongoProcess.class);
    boolean stopped = false;

    public AbstractMongoProcess(Distribution distribution, T config, IRuntimeConfig runtimeConfig, E executable) throws IOException {
        super(distribution, config, runtimeConfig, executable);
    }

    @Override
    protected final void onAfterProcessStart(ProcessControl process, IRuntimeConfig runtimeConfig) throws IOException {
        ProcessOutput outputConfig = runtimeConfig.getProcessOutput();
        LogWatchStreamProcessor logWatch = new LogWatchStreamProcessor(this.successMessage(), this.knownFailureMessages(), StreamToLineProcessor.wrap(outputConfig.getOutput()));
        Processors.connect(process.getReader(), logWatch);
        Processors.connect(process.getError(), StreamToLineProcessor.wrap(outputConfig.getError()));
        logWatch.waitForResult(((IMongoConfig)this.getConfig()).timeout().getStartupTimeout());
        if (logWatch.isInitWithSuccess()) {
            this.setProcessId(Mongod.getMongodProcessId(logWatch.getOutput(), -1));
        } else {
            String failureFound = logWatch.getFailureFound();
            if (failureFound == null) {
                failureFound = "\n----------------------\nHmm.. no failure message.. \n...the cause must be somewhere in the process output\n----------------------\n" + logWatch.getOutput();
            }
            try {
                if (process.waitFor() != 0) {
                    throw new IOException("Could not start process: " + failureFound);
                }
            }
            catch (InterruptedException e) {
                throw new IOException("Could not start process: " + failureFound, e);
            }
        }
    }

    protected String successMessage() {
        return "waiting for connections on port";
    }

    private Set<String> knownFailureMessages() {
        HashSet<String> ret = new HashSet<String>();
        ret.add("failed errno");
        ret.add("ERROR:");
        ret.add("error command line");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopInternal() {
        AbstractMongoProcess abstractMongoProcess = this;
        synchronized (abstractMongoProcess) {
            if (!this.stopped) {
                this.stopped = true;
                logger.debug("try to stop mongod");
                if (!this.sendStopToMongoInstance()) {
                    logger.warn("could not stop mongod with db command, try next");
                    if (!this.sendKillToProcess()) {
                        logger.warn("could not stop mongod, try next");
                        if (!this.tryKillToProcess()) {
                            logger.warn("could not stop mongod the second time, try one last thing");
                        }
                    }
                }
                this.stopProcess();
            }
        }
    }

    @Override
    protected void cleanupInternal() {
        this.deleteTempFiles();
    }

    protected void deleteTempFiles() {
    }

    protected final boolean sendStopToMongoInstance() {
        try {
            return Mongod.sendShutdown(((IMongoConfig)this.getConfig()).net().getServerAddress(), ((IMongoConfig)this.getConfig()).net().getPort());
        }
        catch (UnknownHostException e) {
            logger.error("sendStop", e);
            return false;
        }
    }
}

