/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.api.response.FileAPIResponse;
import com.zoho.crm.library.common.ZCRMConfigUtil;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.restclient.ZCRMRestClient;
import com.zoho.oauth.client.ZohoOAuth;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class APIRequest {
    private String url = ZCRMConfigUtil.getApiBaseURL() + "/crm/" + ZCRMConfigUtil.getApiVersion() + '/';
    private APIConstants.RequestMethod requestMethod = APIConstants.RequestMethod.GET;
    private HashMap<String, String> headers = new HashMap();
    private HashMap<String, String> params = new HashMap();
    private JSONObject requestBody = new JSONObject();
    private HttpEntity requestEntity = null;
    private HttpResponse response = null;
    private String responseJSONRootKey;

    private APIRequest(APIHandler handler) {
        this.url = handler.getUrlPath().contains("http") ? handler.getUrlPath() : this.url + handler.getUrlPath();
        this.requestMethod = handler.getRequestMethod();
        this.setRequestBody(handler.getRequestBody());
        this.headers = handler.getRequestHeadersAsMap();
        this.params = handler.getRequestQueryParamsAsMap();
        this.responseJSONRootKey = handler.getJsonRootKey();
    }

    public static APIRequest getInstance(APIHandler handler) {
        return new APIRequest(handler);
    }

    public APIRequest(String url) {
        this.url = url.contains("http") ? url : this.url + url;
    }

    public void setHeaders(HttpUriRequest request, HashMap<String, String> headersMap) {
        for (String header : headersMap.keySet()) {
            request.addHeader(header, headersMap.get(header));
        }
    }

    public void setQueryParams(URIBuilder uriBuilder, HashMap<String, String> paramsMap) {
        for (String param : paramsMap.keySet()) {
            uriBuilder.addParameter(param, paramsMap.get(param));
        }
    }

    public void setRequestBody(JSONObject body) {
        this.requestBody = body;
    }

    private JSONObject getRequestBody() {
        return this.requestBody;
    }

    public void setQueryParam(String name, String value) {
        this.params.put(name, value);
    }

    private String getQueryParam(String name) {
        return this.params.get(name);
    }

    private HashMap<String, String> getParams() {
        return this.params;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    private String getHeader(String name) {
        return this.headers.get(name);
    }

    private HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setRequestMethod(APIConstants.RequestMethod method) {
        this.requestMethod = method;
    }

    private APIConstants.RequestMethod getRequestMethod() {
        return this.requestMethod;
    }

    private void authenticateRequest() throws ZCRMException {
        try {
            String accessToken = (String)Class.forName(ZCRMConfigUtil.getAuthenticationClass()).getMethod("getAccessToken", new Class[0]).invoke(null, new Object[0]);
            if (accessToken == null) {
                ZCRMLogger.logError(" Access token is not set ");
                throw new ZCRMException("AUTHENTICATION_FAILURE", "Access token is not set");
            }
            this.setHeader("Authorization", APIConstants.authHeaderPrefix + accessToken);
            ZCRMLogger.logInfo(" Token fetched successfully..");
        }
        catch (InvocationTargetException e) {
            ZCRMLogger.logError(e.getTargetException());
            if (e.getTargetException() instanceof ZCRMException) {
                throw (ZCRMException)e.getTargetException();
            }
            throw new ZCRMException(e.getTargetException());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            ZCRMLogger.logError(e);
            throw new ZCRMException(e);
        }
    }

    public void setRequestEntity() throws UnsupportedEncodingException {
        if (this.requestBody.length() > 0) {
            this.requestEntity = new StringEntity(this.requestBody.toString(), "UTF-8");
        }
    }

    public String getResponse() throws ZCRMException {
        try {
            this.setRequestEntity();
            this.getResponseFromServer();
            if (this.response.getEntity() != null) {
                return EntityUtils.toString(this.response.getEntity());
            }
            return null;
        }
        catch (IOException ex) {
            ZCRMLogger.logError(ex);
            throw new ZCRMException(ex);
        }
    }

    public APIResponse getAPIResponse() throws ZCRMException {
        try {
            this.setRequestEntity();
            this.getResponseFromServer();
            return new APIResponse(this.response, this.responseJSONRootKey);
        }
        catch (IOException | JSONException ex) {
            ZCRMLogger.logError(ex);
            throw new ZCRMException(ex);
        }
    }

    public BulkAPIResponse getBulkAPIResponse() throws ZCRMException {
        try {
            this.setRequestEntity();
            this.getResponseFromServer();
            return new BulkAPIResponse(this.response, this.responseJSONRootKey);
        }
        catch (IOException | JSONException ex) {
            ZCRMLogger.logError(ex);
            throw new ZCRMException(ex);
        }
    }

    private void getResponseFromServer() throws ZCRMException {
        try {
            CloseableHttpClient httpclient = this.getHttpClient();
            this.headers.putAll(ZCRMRestClient.getStaticHeaders());
            if (ZCRMRestClient.getDynamicHeaders() != null) {
                this.headers.putAll((Map<String, String>)ZCRMRestClient.DYNAMIC_HEADERS.get());
            } else {
                this.authenticateRequest();
            }
            if (ZCRMConfigUtil.configProperties.get("appType") != null && ZCRMConfigUtil.configProperties.get("appType").equals("zcrmcp") && ZCRMConfigUtil.configProperties.containsKey("portalName")) {
                this.headers.put("X-CRMPORTAL", ZCRMConfigUtil.getConfigValue("portalName"));
            }
            URIBuilder uriBuilder = new URIBuilder(this.url);
            this.setQueryParams(uriBuilder, this.getParams());
            HttpUriRequest requestObj = this.getAptRequestObj(uriBuilder.build());
            this.setHeaders(requestObj, this.getHeaders());
            ZCRMLogger.logInfo(this.toString());
            this.response = httpclient.execute(requestObj);
        }
        catch (IOException | URISyntaxException | NoSuchAlgorithmException e) {
            ZCRMLogger.logError(e, true);
            throw new ZCRMException(e);
        }
    }

    private CloseableHttpClient getHttpClient() throws NoSuchAlgorithmException {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        String timeout = ZCRMConfigUtil.getConfigValue("timeOut");
        String userAgent = ZCRMConfigUtil.getConfigValue("userAgent");
        if (timeout != null) {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(Integer.parseInt(timeout)).setConnectionRequestTimeout(Integer.parseInt(timeout)).setSocketTimeout(Integer.parseInt(timeout)).build();
            httpClientBuilder.setDefaultRequestConfig(config);
        }
        if (userAgent != null) {
            httpClientBuilder.setUserAgent(userAgent);
        }
        if (ZohoOAuth.getAllConfigs().containsKey("proxyHost") && ZohoOAuth.getAllConfigs().containsKey("proxyPort")) {
            String proxyHost = ZohoOAuth.getConfigValue("proxyHost");
            Integer proxyPort = Integer.valueOf(ZohoOAuth.getConfigValue("proxyPort"));
            String proxyUserDomain = ZohoOAuth.getConfigValue("proxyUserDomain");
            String proxyUser = ZohoOAuth.getConfigValue("proxyUser");
            String proxyPassword = ZohoOAuth.getConfigValue("proxyPassword");
            HttpHost proxy = new HttpHost(proxyHost, (int)proxyPort);
            if (proxyUser != null && !proxyUser.isEmpty()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(proxyUser, proxyPassword, null, proxyUserDomain));
                httpClientBuilder.setDefaultCredentialsProvider(credsProvider);
            }
            httpClientBuilder.setProxy(proxy);
            ZCRMLogger.logInfo("JAVA SDK Proxy settings - Host : " + proxyHost + " , Port : " + proxyPort + " , Domain : " + proxyUserDomain + " , Proxy User : " + proxyUser);
        }
        SSLContext sslContext = SSLContext.getDefault();
        SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return httpClientBuilder.setSSLSocketFactory(sslConnectionSocketFactory).build();
    }

    private HttpUriRequest getAptRequestObj(URI urlPath) throws UnsupportedEncodingException {
        switch (this.requestMethod) {
            case GET: {
                return new HttpGet(urlPath);
            }
            case DELETE: {
                return new HttpDelete(urlPath);
            }
            case POST: 
            case PUT: {
                return this.handleRequestBody(urlPath);
            }
        }
        return null;
    }

    private HttpUriRequest handleRequestBody(URI urlPath) throws UnsupportedEncodingException {
        HttpEntityEnclosingRequestBase requestBase = null;
        switch (this.requestMethod) {
            case POST: {
                requestBase = new HttpPost(urlPath);
                break;
            }
            case PUT: {
                requestBase = new HttpPut(urlPath);
            }
        }
        if (this.requestEntity != null) {
            requestBase.setEntity(this.requestEntity);
            if (this.requestEntity instanceof StringEntity) {
                requestBase.setHeader("Content-Type", "application/json; charset=utf-8");
            }
        } else {
            MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create();
            multipartEntity.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            this.requestEntity = multipartEntity.build();
            requestBase.setEntity(this.requestEntity);
        }
        return requestBase;
    }

    public APIResponse uploadFile(String filePath) throws ZCRMException {
        try {
            FileBody fileBody = new FileBody(new File(filePath));
            MultipartEntityBuilder multipartEntity = MultipartEntityBuilder.create();
            multipartEntity.addPart("file", fileBody);
            this.requestEntity = multipartEntity.build();
            this.getResponseFromServer();
            return new APIResponse(this.response, this.responseJSONRootKey);
        }
        catch (IOException | JSONException ex) {
            ZCRMLogger.logError(ex);
            throw new ZCRMException(ex);
        }
    }

    public FileAPIResponse downloadFile() throws ZCRMException {
        try {
            this.getResponseFromServer();
            FileAPIResponse response = new FileAPIResponse(this.response);
            return response;
        }
        catch (IOException | JSONException ex) {
            ZCRMLogger.logError(ex);
            throw new ZCRMException(ex);
        }
    }

    public String toString() {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.putAll(this.headers);
        reqHeaders.put("Authorization", " ## can't disclose ## ");
        return "URL = " + this.url + " , " + "HEADERS" + " = " + reqHeaders + " , " + "PARAMS" + " = " + this.params + " . ";
    }
}

