/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.proxy.toys.delegate;

import com.thoughtworks.proxy.Invoker;
import com.thoughtworks.proxy.ProxyFactory;
import com.thoughtworks.proxy.factory.StandardProxyFactory;
import com.thoughtworks.proxy.kit.ObjectReference;
import com.thoughtworks.proxy.kit.ReflectionUtils;
import com.thoughtworks.proxy.kit.SimpleReference;
import com.thoughtworks.proxy.toys.delegate.DelegationException;
import com.thoughtworks.proxy.toys.delegate.DelegationMode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingInvoker<T>
implements Invoker {
    private static final long serialVersionUID = 1L;
    private transient Map<Method, Method> methodCache;
    private ProxyFactory proxyFactory;
    private ObjectReference<T> delegateReference;
    private DelegationMode delegationMode;

    public DelegatingInvoker(ProxyFactory proxyFactory, ObjectReference<T> delegateReference, DelegationMode delegationMode) {
        this.proxyFactory = proxyFactory;
        this.delegateReference = delegateReference;
        this.delegationMode = delegationMode;
        this.methodCache = new HashMap<Method, Method>();
    }

    public DelegatingInvoker(T delegate) {
        this(new StandardProxyFactory(), new SimpleReference<T>(delegate), DelegationMode.SIGNATURE);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        T delegate = this.delegate();
        if (method.equals(ReflectionUtils.equals)) {
            Object arg = args[0];
            while (delegate != null && this.proxyFactory.isProxyClass(delegate.getClass())) {
                Invoker invoker = this.proxyFactory.getInvoker(delegate);
                if (!(invoker instanceof DelegatingInvoker)) continue;
                delegate = ((DelegatingInvoker)DelegatingInvoker.class.cast(invoker)).delegate();
            }
            result = arg == null ? Boolean.valueOf(delegate == null) : Boolean.valueOf(arg.equals(delegate));
        } else if (method.equals(ReflectionUtils.hashCode)) {
            result = delegate == null ? 47 : delegate.hashCode();
        } else if (delegate == null) {
            result = null;
        } else {
            Method methodToCall = this.methodCache.get(method);
            if (methodToCall == null) {
                methodToCall = this.getMethodToInvoke(method, args);
                this.methodCache.put(method, methodToCall);
            }
            result = this.invokeOnDelegate(methodToCall, args);
        }
        return result;
    }

    protected T delegate() {
        return this.delegateReference.get();
    }

    protected Method getMethodToInvoke(Method method, Object[] args) {
        if (this.delegationMode == DelegationMode.DIRECT) {
            return method;
        }
        String methodName = method.getName();
        try {
            return this.delegate().getClass().getMethod(methodName, method.getParameterTypes());
        }
        catch (Exception e) {
            throw new DelegationException("Unable to find method " + methodName, e, this.delegate());
        }
    }

    protected Object invokeOnDelegate(Method method, Object[] args) throws InvocationTargetException {
        T delegate = this.delegate();
        try {
            return method.invoke(delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DelegationException("Problem invoking " + method, e, delegate);
        }
    }

    protected ObjectReference<T> getDelegateReference() {
        return this.delegateReference;
    }

    protected ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DelegatingInvoker) {
            DelegatingInvoker invoker = (DelegatingInvoker)DelegatingInvoker.class.cast(obj);
            return invoker.delegationMode == this.delegationMode && this.delegate().equals(invoker.delegate());
        }
        return false;
    }

    public int hashCode() {
        T delegate = this.delegate();
        return this.delegationMode.hashCode() * (delegate == null ? System.identityHashCode(this) : delegate.hashCode());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.methodCache = new HashMap<Method, Method>();
    }
}

