/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Executable
implements RunnableFuture<Executable>,
Serializable {
    private static final long serialVersionUID = 8L;
    private transient Logger log;
    private transient Logger outputLog;
    private transient Logger errorLog;
    private transient FutureTask<Executable> future;
    private volatile transient boolean running;
    private transient String lastCommand;
    private File workingDirectory;
    private Iterable<?> commands;
    private Map<String, Object> substitutions = new ConcurrentHashMap<String, Object>(3);
    private Map<String, Object> environment = new ConcurrentHashMap<String, Object>(3);
    private String encoding = Charset.defaultCharset().name();
    private ThreadFactory threadFactory = new ConfigurableThreadFactory();
    private StreamPumper<?> stdoutPumper = new QueueStreamPumper();
    private StreamPumper<?> stderrPumper = new QueueStreamPumper();
    private List<Object> exitValues = new ArrayList<Object>(3);
    private boolean stopOnFailure = false;
    private int limit = -1;
    private int[] expectedExitValues = new int[1];

    public Executable(Object ... commands) {
        this(commands == null ? null : Arrays.asList(commands));
    }

    public Executable(Iterable<?> commands) {
        this.commands = commands == null ? Collections.EMPTY_LIST : commands;
        this.init();
    }

    private void init() {
        this.future = new FutureTask<Executable>(new ExecuteStreamHandlerImpl(), this);
        this.log = LoggerFactory.getLogger(this.getClass());
        this.outputLog = LoggerFactory.getLogger(this.getClass().getName().concat("Output"));
        this.errorLog = LoggerFactory.getLogger(this.getClass().getName().concat("Error"));
    }

    public Executable in(Object workingDirectory) {
        if (workingDirectory != null) {
            this.workingDirectory = workingDirectory instanceof File ? (File)workingDirectory : new File(workingDirectory.toString());
            this.workingDirectory.mkdirs();
        }
        return this;
    }

    public Executable priority(int priority) {
        assert (priority >= 1 && priority <= 10);
        if (this.threadFactory instanceof ConfigurableThreadFactory) {
            ((ConfigurableThreadFactory)this.threadFactory).priority = priority;
        }
        return this;
    }

    public Executable daemonThreads() {
        if (this.threadFactory instanceof ConfigurableThreadFactory) {
            ((ConfigurableThreadFactory)this.threadFactory).daemon = true;
        }
        return this;
    }

    public Executable lowPriority() {
        return this.priority(1).daemonThreads();
    }

    public Executable encoding(String encoding) {
        assert (encoding != null);
        assert (Charset.availableCharsets().containsKey(encoding));
        this.encoding = encoding;
        return this;
    }

    public Executable stdout(StreamPumper pumper) {
        this.stdoutPumper = pumper == null ? new NullStreamPumper() : pumper;
        return this;
    }

    public Executable stderr(StreamPumper pumper) {
        this.stderrPumper = pumper == null ? new NullStreamPumper() : pumper;
        return this;
    }

    public Executable ignoreStdout() {
        return this.stdout(null);
    }

    public Executable ignoreStderr() {
        return this.stderr(null);
    }

    public Executable bufferStdout() {
        return this.stdout(new BufferStreamPumper());
    }

    public Executable bufferStderr() {
        return this.stderr(new BufferStreamPumper());
    }

    public Executable substitute(String key, Object value) {
        if (key != null && value != null) {
            this.substitutions.put(key, value);
        }
        return this;
    }

    public Executable substitute(Map<String, Object> substitutions) {
        if (substitutions != null) {
            for (Map.Entry<String, Object> e : substitutions.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                this.substitutions.put(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public Executable expect(Object values) {
        if (values instanceof int[]) {
            this.expectedExitValues = (int[])((int[])values).clone();
        } else if (values instanceof Iterable) {
            ArrayList<Integer> tempList = new ArrayList<Integer>();
            for (Object o : (Iterable)values) {
                if (o instanceof Number) {
                    tempList.add(((Number)o).intValue());
                    continue;
                }
                if (o == null) continue;
                String oString = String.valueOf(o).trim();
                try {
                    tempList.add(Integer.parseInt(oString));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.expectedExitValues = new int[tempList.size()];
            int i = 0;
            while (i < this.expectedExitValues.length) {
                this.expectedExitValues[i] = (Integer)tempList.get(i);
                ++i;
            }
        } else if (values instanceof Number) {
            this.expectedExitValues = new int[]{((Number)values).intValue()};
        } else if (values != null) {
            String valueString = String.valueOf(values).trim();
            try {
                this.expectedExitValues = new int[]{Integer.parseInt(valueString)};
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return this;
    }

    public Executable expect(int value) {
        this.expectedExitValues = new int[]{value};
        return this;
    }

    public Object getOutput() {
        return this.stdoutPumper != null ? this.stdoutPumper.output : null;
    }

    public Object getError() {
        return this.stderrPumper != null ? this.stderrPumper.output : null;
    }

    public List<Object> getExitValues() {
        return Collections.unmodifiableList(this.exitValues);
    }

    public Executable stopOnFailure() {
        this.stopOnFailure = true;
        return this;
    }

    public Executable limit(int linesOrCharacters) {
        assert (linesOrCharacters > 0);
        this.limit = linesOrCharacters;
        return this;
    }

    public Executable with(ThreadFactory factory) {
        assert (factory != null);
        this.threadFactory = factory;
        return this;
    }

    public String lastCommand() {
        return this.lastCommand;
    }

    public Map<String, Object> getEnv() {
        return this.environment;
    }

    public boolean isRunning() {
        return this.running && !this.isDone();
    }

    @Override
    public void run() {
        this.future.run();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public Executable get() throws InterruptedException, ExecutionException {
        return this.future.get();
    }

    @Override
    public Executable get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BufferStreamPumper
    extends StreamPumper<StringBuffer> {
        private static final long serialVersionUID = -8699014458525194564L;

        BufferStreamPumper() {
            super(new StringBuffer());
        }

        @Override
        public void run() {
            if (this.stream == null) {
                return;
            }
            char[] buf = new char[256];
            try {
                int b;
                InputStreamReader reader = new InputStreamReader(this.stream, Executable.this.encoding);
                while (this.stream != null && (b = reader.read(buf)) != -1) {
                    ((StringBuffer)this.output).append(buf, 0, b);
                    if (Executable.this.limit == -1 || ((StringBuffer)this.output).length() <= Executable.this.limit) continue;
                    ((StringBuffer)this.output).delete(0, ((StringBuffer)this.output).length() - Executable.this.limit);
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static class ConfigurableThreadFactory
    implements ThreadFactory,
    Serializable {
        private static final long serialVersionUID = -7050011797275726271L;
        private int priority = 5;
        private boolean daemon;

        private ConfigurableThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setPriority(this.priority);
            t.setDaemon(this.daemon);
            return t;
        }
    }

    private class ExecuteStreamHandlerImpl
    implements ExecuteStreamHandler,
    Runnable {
        private Thread errorThread;
        private Thread outputThread;

        private ExecuteStreamHandlerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Executable.this.running = true;
            DefaultExecutor executor = new DefaultExecutor();
            executor.setExitValues(Executable.this.expectedExitValues);
            executor.setStreamHandler((ExecuteStreamHandler)this);
            executor.setWorkingDirectory(Executable.this.workingDirectory);
            Iterator it = Executable.this.commands.iterator();
            while (it.hasNext() && !Executable.this.isCancelled()) {
                List list;
                Object command = it.next();
                if (command == null) continue;
                CommandLine line = CommandLine.parse((String)command.toString(), (Map)Executable.this.substitutions);
                Executable.this.lastCommand = line.toString();
                long then = Executable.this.currentTimeMillis();
                try {
                    Executable.this.log.trace("executing {}", (Object)line);
                    int exitValue = executor.execute(line, Executable.this.environment.isEmpty() ? null : Executable.this.environment);
                    list = Executable.this.exitValues;
                    synchronized (list) {
                        Executable.this.exitValues.add(exitValue);
                    }
                    Executable.this.log.trace("executed  {}", (Object)line);
                    if (Executable.this.log.isDebugEnabled() && !Executable.this.log.isTraceEnabled()) {
                        Executable.this.log.debug("{} ms: {}", (Object)this.delta(then), (Object)line);
                    }
                    this.logOutput();
                    this.logError();
                }
                catch (IOException ex) {
                    list = Executable.this.exitValues;
                    synchronized (list) {
                        Executable.this.exitValues.add(ex);
                    }
                    Executable.this.log.warn("{} exited after {} ms with {}", line, this.delta(then), ExceptionUtils.getRootCauseMessage(ex));
                    this.logOutput();
                    this.logError();
                    if (!Executable.this.stopOnFailure) continue;
                    Executable.this.cancel(false);
                }
            }
        }

        private void logError() {
            if (Executable.this.errorLog.isDebugEnabled() && Executable.this.stderrPumper != null && ((Executable)Executable.this).stderrPumper.output != null) {
                Executable.this.errorLog.debug(this.toString(((Executable)Executable.this).stderrPumper.output));
            }
        }

        private void logOutput() {
            if (Executable.this.outputLog.isDebugEnabled() && Executable.this.stdoutPumper != null && ((Executable)Executable.this).stdoutPumper.output != null) {
                Executable.this.outputLog.debug(this.toString(((Executable)Executable.this).stdoutPumper.output));
            }
        }

        public void setProcessErrorStream(InputStream stream) {
            ((Executable)Executable.this).stderrPumper.stream = stream;
        }

        public void setProcessOutputStream(InputStream stream) {
            ((Executable)Executable.this).stdoutPumper.stream = stream;
        }

        public void setProcessInputStream(OutputStream stream) {
        }

        public void start() {
            this.errorThread = Executable.this.threadFactory.newThread(Executable.this.stderrPumper);
            this.errorThread.start();
            this.outputThread = Executable.this.threadFactory.newThread(Executable.this.stdoutPumper);
            this.outputThread.start();
        }

        public void stop() {
            try {
                this.errorThread.join();
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.outputThread.join();
            }
            catch (InterruptedException interruptedException) {}
            this.outputThread = null;
            this.errorThread = null;
            ((Executable)Executable.this).stderrPumper.stream = null;
            ((Executable)Executable.this).stdoutPumper.stream = null;
        }

        long delta(long then) {
            return Executable.this.currentTimeMillis() - then;
        }

        String toString(Object output) {
            if (output instanceof Iterable) {
                return StringUtils.join(((Iterable)output).iterator(), StringUtils.defaultString(SystemUtils.LINE_SEPARATOR, "\n"));
            }
            if (output instanceof Object[]) {
                return StringUtils.join((Object[])output, StringUtils.defaultString(SystemUtils.LINE_SEPARATOR, "\n"));
            }
            return String.valueOf(output);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NullStreamPumper
    extends StreamPumper<Object> {
        private static final long serialVersionUID = 6790148206019003388L;
        private static final byte[] buf = new byte[256];

        NullStreamPumper() {
            super(null);
        }

        @Override
        public void run() {
            try {
                while (this.stream != null && this.stream.read(buf) != -1) {
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueueStreamPumper
    extends StreamPumper<ConcurrentLinkedQueue<String>> {
        private static final long serialVersionUID = -8753895328547724538L;

        QueueStreamPumper() {
            super(new ConcurrentLinkedQueue());
        }

        @Override
        public void run() {
            if (this.stream == null) {
                return;
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.stream, Executable.this.encoding), 256);
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        ((ConcurrentLinkedQueue)this.output).add(line);
                        if (Executable.this.limit == -1 || ((ConcurrentLinkedQueue)this.output).size() <= Executable.this.limit) continue;
                        ((ConcurrentLinkedQueue)this.output).poll();
                    }
                }
                catch (OutOfMemoryError err) {
                    try {
                        reader.close();
                        reader = null;
                        Executable.this.log.error("got an OutOfMemoryError");
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw err;
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StreamPumper<T>
    implements Runnable,
    Serializable {
        private static final long serialVersionUID = -2282419048545498727L;
        protected transient InputStream stream;
        protected T output;

        public StreamPumper(T output) {
            this.output = output;
        }
    }
}

