/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.configuration;

import com.eaio.configuration.Configuration;
import com.eaio.util.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.apache.log4j.helpers.OptionConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseConfiguration
extends ConcurrentHashMap<String, String>
implements Configuration {
    private static final long serialVersionUID = 3749446309723647414L;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final String PROPERTIES_SUFFIX = ".properties";
    private final File userHome = new File(SystemUtils.USER_HOME);
    private final File userDir = new File(SystemUtils.USER_DIR);
    private static String[] additionalPaths = System.getProperty("configuration.paths", "").split(SystemUtils.PATH_SEPARATOR);
    private final String key;
    private final boolean substitute;

    public BaseConfiguration(String key) {
        this(key, true);
    }

    public BaseConfiguration(String key, boolean substitute) {
        this.key = key;
        this.substitute = substitute;
        this.load();
    }

    @Override
    public void load() {
        Properties p = new Properties();
        p.put("key", this.key);
        this.tryLoading(this.buildName(null), p);
        InetAddress[] localHosts = this.localHosts();
        int i = 0;
        while (i < localHosts.length) {
            this.tryLoading(this.buildName(localHosts[i].getHostName()), p);
            this.tryLoading(this.buildName(localHosts[i].getHostAddress()), p);
            ++i;
        }
        if (this.substitute) {
            this.substituteVariables(p);
        }
        for (String key : p.stringPropertyNames()) {
            this.put(key, p.getProperty(key));
        }
        this.LOG.debug("loaded configuration for {}", (Object)this.key);
    }

    private void substituteVariables(Properties p) {
        for (Object key : p.keySet()) {
            String val2 = p.getProperty((String)key);
            if (!val2.contains("${")) continue;
            p.setProperty((String)key, OptionConverter.substVars((String)val2, (Properties)p));
        }
    }

    void tryLoading(String resource, Properties p) {
        block15: {
            String actualResource;
            File f = null;
            if (this.userHome != null) {
                f = this.returnNewFileIfFileAndReadable(f, new File(this.userHome, resource));
            }
            if (this.userDir != null && !this.userDir.equals(this.userHome)) {
                f = this.returnNewFileIfFileAndReadable(f, new File(this.userDir, resource));
            }
            if (additionalPaths != null) {
                int i = 0;
                while (i < additionalPaths.length) {
                    File additional = new File(additionalPaths[i]);
                    if (!additional.equals(this.userHome) && !additional.equals(this.userDir)) {
                        f = this.returnNewFileIfFileAndReadable(f, new File(additional, resource));
                    }
                    ++i;
                }
            }
            InputStream in = null;
            if (f == null) {
                actualResource = new StrBuilder(resource.length() + 1).append('/').append(resource).toString();
                in = BaseConfiguration.class.getResourceAsStream(actualResource);
            } else {
                actualResource = f.getAbsolutePath();
                try {
                    in = new FileInputStream(f);
                }
                catch (FileNotFoundException ex) {
                    this.LOG.error("could not find file {} even though checked before", (Object)f, (Object)ex);
                }
            }
            if (in != null) {
                try {
                    try {
                        this.LOG.debug("loading from {}", (Object)actualResource);
                        p.load(in);
                    }
                    catch (IOException ex) {
                        this.LOG.warn("while loading " + actualResource + " from " + resource, ex);
                        Resource.close(in);
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    Resource.close(in);
                    throw throwable;
                }
                Resource.close(in);
            }
        }
    }

    File returnNewFileIfFileAndReadable(File curr, File newFile) {
        this.LOG.trace("checking {}", (Object)newFile.getAbsolutePath());
        return newFile.isFile() && newFile.canRead() ? newFile : curr;
    }

    String buildName(String middle) {
        StrBuilder out = new StrBuilder();
        out.append(this.key);
        if (middle != null) {
            out.append('.');
            out.append(middle);
        }
        out.append(".properties");
        return out.toString();
    }

    private InetAddress[] localHosts() {
        InetAddress localHost = null;
        InetAddress[] out = null;
        try {
            localHost = InetAddress.getLocalHost();
            if (localHost != null) {
                out = InetAddress.getAllByName(localHost.getHostName());
            }
        }
        catch (UnknownHostException ex) {
            this.LOG.warn("unknown host", ex);
        }
        if (out == null) {
            out = localHost != null ? new InetAddress[]{localHost} : new InetAddress[]{};
        }
        return out;
    }
}

