/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractReconnectionHandler;
import com.datastax.driver.core.AsyncInitSession;
import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.ClusterNameMismatchException;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.DefaultResultSetFuture;
import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.EventDebouncer;
import com.datastax.driver.core.ExceptionCatchingRunnable;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.LatencyTracker;
import com.datastax.driver.core.LifecycleAwareLatencyTracker;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.MetricsOptions;
import com.datastax.driver.core.NettyOptions;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Requests;
import com.datastax.driver.core.Responses;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.SystemProperties;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TimestampGenerator;
import com.datastax.driver.core.UnsupportedProtocolVersionException;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.policies.AddressTranslater;
import com.datastax.driver.core.policies.CloseableAddressTranslater;
import com.datastax.driver.core.policies.CloseableLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.utils.MoreFutures;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Functions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.FutureFallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    @VisibleForTesting
    static final int NEW_NODE_DELAY_SECONDS = SystemProperties.getInt("com.datastax.driver.NEW_NODE_DELAY_SECONDS", 1);
    private static final int NON_BLOCKING_EXECUTOR_SIZE = SystemProperties.getInt("com.datastax.driver.NON_BLOCKING_EXECUTOR_SIZE", Runtime.getRuntime().availableProcessors());
    private static final ResourceBundle driverProperties = ResourceBundle.getBundle("com.datastax.driver.core.Driver");
    private static final AtomicInteger CLUSTER_ID = new AtomicInteger(0);
    private static final int DEFAULT_THREAD_KEEP_ALIVE = 30;
    private static final int NOTIF_LOCK_TIMEOUT_SECONDS = SystemProperties.getInt("com.datastax.driver.NOTIF_LOCK_TIMEOUT_SECONDS", 60);
    final Manager manager;

    protected Cluster(String name, List<InetSocketAddress> contactPoints, Configuration configuration) {
        this(name, contactPoints, configuration, Collections.emptySet());
    }

    protected Cluster(Initializer initializer) {
        this(initializer.getClusterName(), Cluster.checkNotEmpty(initializer.getContactPoints()), initializer.getConfiguration(), initializer.getInitialListeners());
    }

    private static List<InetSocketAddress> checkNotEmpty(List<InetSocketAddress> contactPoints) {
        if (contactPoints.isEmpty()) {
            throw new IllegalArgumentException("Cannot build a cluster without contact points");
        }
        return contactPoints;
    }

    private Cluster(String name, List<InetSocketAddress> contactPoints, Configuration configuration, Collection<Host.StateListener> listeners) {
        this.manager = new Manager(name, contactPoints, configuration, listeners);
    }

    public Cluster init() {
        this.manager.init();
        return this;
    }

    public static Cluster buildFrom(Initializer initializer) {
        return new Cluster(initializer);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static String getDriverVersion() {
        return driverProperties.getString("driver.version");
    }

    public Session newSession() {
        Cluster.checkNotClosed(this.manager);
        return this.manager.newSession();
    }

    public Session connect() {
        try {
            return Uninterruptibles.getUninterruptibly(this.connectAsync());
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Session connect(String keyspace) {
        try {
            return Uninterruptibles.getUninterruptibly(this.connectAsync(keyspace));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Session> connectAsync() {
        return this.connectAsync(null);
    }

    public ListenableFuture<Session> connectAsync(String keyspace) {
        Cluster.checkNotClosed(this.manager);
        this.init();
        final AsyncInitSession session = this.manager.newSession();
        ListenableFuture<Session> sessionInitialized = session.initAsync();
        if (keyspace == null) {
            return sessionInitialized;
        }
        final String useQuery = "USE " + keyspace;
        ListenableFuture<ResultSet> keyspaceSet = Futures.transform(sessionInitialized, new AsyncFunction<Session, ResultSet>(){

            @Override
            public ListenableFuture<ResultSet> apply(Session session) throws Exception {
                return session.executeAsync(useQuery);
            }
        });
        ListenableFuture<ResultSet> withErrorHandling = Futures.withFallback(keyspaceSet, new FutureFallback<ResultSet>(){

            @Override
            public ListenableFuture<ResultSet> create(Throwable t) throws Exception {
                session.closeAsync();
                if (t instanceof SyntaxError) {
                    SyntaxError e = (SyntaxError)t;
                    t = new SyntaxError(e.getAddress(), String.format("Error executing \"%s\" (%s). Check that your keyspace name is valid", useQuery, e.getMessage()));
                }
                throw Throwables.propagate(t);
            }
        });
        return Futures.transform(withErrorHandling, Functions.constant(session));
    }

    public String getClusterName() {
        return this.manager.clusterName;
    }

    public Metadata getMetadata() {
        this.manager.init();
        return this.manager.metadata;
    }

    public Configuration getConfiguration() {
        return this.manager.configuration;
    }

    public Metrics getMetrics() {
        Cluster.checkNotClosed(this.manager);
        return this.manager.metrics;
    }

    public Cluster register(Host.StateListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean added = this.manager.listeners.add(listener);
        if (added && listener instanceof Host.LifecycleAwareStateListener) {
            ((Host.LifecycleAwareStateListener)listener).onRegister(this);
        }
        return this;
    }

    public Cluster unregister(Host.StateListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean removed = this.manager.listeners.remove(listener);
        if (removed && listener instanceof Host.LifecycleAwareStateListener) {
            ((Host.LifecycleAwareStateListener)listener).onUnregister(this);
        }
        return this;
    }

    public Cluster register(LatencyTracker tracker) {
        Cluster.checkNotClosed(this.manager);
        boolean added = this.manager.trackers.add(tracker);
        if (added && tracker instanceof LifecycleAwareLatencyTracker) {
            ((LifecycleAwareLatencyTracker)tracker).onRegister(this);
        }
        return this;
    }

    public Cluster unregister(LatencyTracker tracker) {
        Cluster.checkNotClosed(this.manager);
        boolean removed = this.manager.trackers.remove(tracker);
        if (removed && tracker instanceof LifecycleAwareLatencyTracker) {
            ((LifecycleAwareLatencyTracker)tracker).onUnregister(this);
        }
        return this;
    }

    public Cluster register(SchemaChangeListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean added = this.manager.schemaChangeListeners.add(listener);
        if (added) {
            listener.onRegister(this);
        }
        return this;
    }

    public Cluster unregister(SchemaChangeListener listener) {
        Cluster.checkNotClosed(this.manager);
        boolean removed = this.manager.schemaChangeListeners.remove(listener);
        if (removed) {
            listener.onUnregister(this);
        }
        return this;
    }

    public CloseFuture closeAsync() {
        return this.manager.close();
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean isClosed() {
        return this.manager.closeFuture.get() != null;
    }

    private static void checkNotClosed(Manager manager) {
        if (manager.isClosed()) {
            throw new IllegalStateException("Can't use this cluster instance because it was previously closed");
        }
    }

    static long timeSince(long startNanos, TimeUnit destUnit) {
        return destUnit.convert(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
    }

    private static String generateClusterName() {
        return "cluster" + CLUSTER_ID.incrementAndGet();
    }

    static class ConnectionReaper {
        private static final int INTERVAL_MS = 15000;
        private final ScheduledExecutorService executor;
        @VisibleForTesting
        final Map<Connection, Long> connections = new ConcurrentHashMap<Connection, Long>();
        private volatile boolean shutdown;
        private final Runnable reaperTask = new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                Iterator<Map.Entry<Connection, Long>> iterator = ConnectionReaper.this.connections.entrySet().iterator();
                while (iterator.hasNext()) {
                    boolean terminated;
                    Map.Entry<Connection, Long> entry = iterator.next();
                    Connection connection = entry.getKey();
                    Long terminateTime = entry.getValue();
                    if (terminateTime > now || !(terminated = connection.tryTerminate(true))) continue;
                    iterator.remove();
                }
            }
        };

        ConnectionReaper(Manager manager) {
            this.executor = Executors.newScheduledThreadPool(1, manager.threadFactory("connection-reaper"));
            this.executor.scheduleWithFixedDelay(this.reaperTask, 15000L, 15000L, TimeUnit.MILLISECONDS);
        }

        void register(Connection connection, long terminateTime) {
            if (this.shutdown) {
                logger.warn("Connection registered after reaper shutdown: {}", (Object)connection);
                connection.tryTerminate(true);
            } else {
                this.connections.put(connection, terminateTime);
            }
        }

        void shutdown() {
            this.shutdown = true;
            this.executor.shutdownNow();
            this.reaperTask.run();
        }
    }

    private static enum HostEvent {
        UP,
        DOWN,
        ADDED,
        REMOVED;

    }

    class Manager
    implements Connection.DefaultResponseHandler {
        final String clusterName;
        private boolean isInit;
        private volatile boolean isFullyInit;
        final List<InetSocketAddress> contactPoints;
        final Set<SessionManager> sessions = new CopyOnWriteArraySet<SessionManager>();
        Metadata metadata;
        final Configuration configuration;
        Metrics metrics;
        Connection.Factory connectionFactory;
        ControlConnection controlConnection;
        final ConvictionPolicy.Factory convictionPolicyFactory = new ConvictionPolicy.DefaultConvictionPolicy.Factory();
        ScheduledThreadPoolExecutor reconnectionExecutor;
        ScheduledThreadPoolExecutor scheduledTasksExecutor;
        ListeningExecutorService executor;
        LinkedBlockingQueue<Runnable> executorQueue;
        ListeningExecutorService blockingExecutor;
        LinkedBlockingQueue<Runnable> blockingExecutorQueue;
        ConnectionReaper reaper;
        final AtomicReference<CloseFuture> closeFuture = new AtomicReference();
        ConcurrentMap<MD5Digest, PreparedStatement> preparedQueries;
        final Set<Host.StateListener> listeners;
        final Set<LatencyTracker> trackers = new CopyOnWriteArraySet<LatencyTracker>();
        final Set<SchemaChangeListener> schemaChangeListeners = new CopyOnWriteArraySet<SchemaChangeListener>();
        EventDebouncer<NodeListRefreshRequest> nodeListRefreshRequestDebouncer;
        EventDebouncer<NodeRefreshRequest> nodeRefreshRequestDebouncer;
        EventDebouncer<SchemaRefreshRequest> schemaRefreshRequestDebouncer;

        private Manager(String clusterName, List<InetSocketAddress> contactPoints, Configuration configuration, Collection<Host.StateListener> listeners) {
            this.clusterName = clusterName == null ? Cluster.generateClusterName() : clusterName;
            this.configuration = configuration;
            this.contactPoints = contactPoints;
            this.listeners = new CopyOnWriteArraySet<Host.StateListener>(listeners);
        }

        synchronized void init() {
            Cluster.checkNotClosed(this);
            if (this.isInit) {
                return;
            }
            this.isInit = true;
            logger.debug("Starting new cluster with contact points " + this.contactPoints);
            this.configuration.register(this);
            this.executorQueue = new LinkedBlockingQueue();
            this.executor = this.makeExecutor(NON_BLOCKING_EXECUTOR_SIZE, "worker", this.executorQueue);
            this.blockingExecutorQueue = new LinkedBlockingQueue();
            this.blockingExecutor = this.makeExecutor(2, "blocking-task-worker", this.blockingExecutorQueue);
            this.reconnectionExecutor = new ScheduledThreadPoolExecutor(2, this.threadFactory("reconnection"));
            this.scheduledTasksExecutor = new ScheduledThreadPoolExecutor(1, this.threadFactory("scheduled-task-worker"));
            this.reaper = new ConnectionReaper(this);
            this.metadata = new Metadata(this);
            this.connectionFactory = new Connection.Factory(this, this.configuration);
            this.controlConnection = new ControlConnection(this);
            this.metrics = this.configuration.getMetricsOptions() == null ? null : new Metrics(this);
            this.preparedQueries = new MapMaker().weakValues().makeMap();
            QueryOptions queryOptions = this.configuration.getQueryOptions();
            this.nodeListRefreshRequestDebouncer = new EventDebouncer<NodeListRefreshRequest>("Node list refresh", this.scheduledTasksExecutor, new NodeListRefreshRequestDeliveryCallback(), queryOptions.getRefreshNodeListIntervalMillis(), queryOptions.getMaxPendingRefreshNodeListRequests(), 10000);
            this.nodeRefreshRequestDebouncer = new EventDebouncer<NodeRefreshRequest>("Node refresh", this.scheduledTasksExecutor, new NodeRefreshRequestDeliveryCallback(), queryOptions.getRefreshNodeIntervalMillis(), queryOptions.getMaxPendingRefreshNodeRequests(), 10000);
            this.schemaRefreshRequestDebouncer = new EventDebouncer<SchemaRefreshRequest>("Schema refresh", this.scheduledTasksExecutor, new SchemaRefreshRequestDeliveryCallback(), queryOptions.getRefreshSchemaIntervalMillis(), queryOptions.getMaxPendingRefreshSchemaRequests(), 10000);
            this.scheduledTasksExecutor.scheduleWithFixedDelay(new CleanupIdleConnectionsTask(), 10L, 10L, TimeUnit.SECONDS);
            for (InetSocketAddress address : this.contactPoints) {
                this.metadata.add(address);
            }
            Collection<Host> allHosts = this.metadata.allHosts();
            HashSet<Host> contactPointHosts = Sets.newHashSet(allHosts);
            try {
                try {
                    this.controlConnection.connect();
                }
                catch (UnsupportedProtocolVersionException e) {
                    logger.debug("Cannot connect with protocol {}, trying {}", (Object)e.unsupportedVersion, (Object)e.serverVersion);
                    this.connectionFactory.protocolVersion = e.serverVersion;
                    try {
                        this.controlConnection.connect();
                    }
                    catch (UnsupportedProtocolVersionException e1) {
                        throw new DriverInternalError("Cannot connect to node with its own version, this makes no sense", e);
                    }
                }
                HashSet<Host> downContactPointHosts = Sets.newHashSet();
                HashSet<Host> removedContactPointHosts = Sets.newHashSet();
                for (Host host : contactPointHosts) {
                    if (!allHosts.contains(host)) {
                        removedContactPointHosts.add(host);
                        continue;
                    }
                    if (host.state != Host.State.DOWN) continue;
                    downContactPointHosts.add(host);
                }
                contactPointHosts.removeAll(removedContactPointHosts);
                contactPointHosts.removeAll(downContactPointHosts);
                this.loadBalancingPolicy().init(Cluster.this, contactPointHosts);
                this.speculativeRetryPolicy().init(Cluster.this);
                for (LatencyTracker tracker : this.trackers) {
                    if (!(tracker instanceof LifecycleAwareLatencyTracker)) continue;
                    ((LifecycleAwareLatencyTracker)tracker).onRegister(Cluster.this);
                }
                for (Host.StateListener listener : this.listeners) {
                    if (!(listener instanceof Host.LifecycleAwareStateListener)) continue;
                    ((Host.LifecycleAwareStateListener)listener).onRegister(Cluster.this);
                }
                for (Host host : removedContactPointHosts) {
                    this.loadBalancingPolicy().onRemove(host);
                    for (Host.StateListener listener : this.listeners) {
                        listener.onRemove(host);
                    }
                }
                for (Host host : downContactPointHosts) {
                    this.loadBalancingPolicy().onDown(host);
                    for (Host.StateListener listener : this.listeners) {
                        listener.onDown(host);
                    }
                    this.startPeriodicReconnectionAttempt(host, true);
                }
                this.configuration.getPoolingOptions().setProtocolVersion(this.protocolVersion());
                for (Host host : allHosts) {
                    if (host.state == Host.State.DOWN) continue;
                    logger.info("New Cassandra host {} added", (Object)host);
                    if (!this.connectionFactory.protocolVersion.isSupportedBy(host)) {
                        this.logUnsupportedVersionProtocol(host, this.connectionFactory.protocolVersion);
                        continue;
                    }
                    if (!contactPointHosts.contains(host)) {
                        this.loadBalancingPolicy().onAdd(host);
                    }
                    host.setUp();
                    for (Host.StateListener listener : this.listeners) {
                        listener.onAdd(host);
                    }
                }
                this.nodeListRefreshRequestDebouncer.start();
                this.schemaRefreshRequestDebouncer.start();
                this.nodeRefreshRequestDebouncer.start();
                this.isFullyInit = true;
            }
            catch (NoHostAvailableException e) {
                this.close();
                throw e;
            }
        }

        ProtocolVersion protocolVersion() {
            return this.connectionFactory.protocolVersion;
        }

        ThreadFactory threadFactory(String name) {
            return new ThreadFactoryBuilder().setNameFormat(this.clusterName + "-" + name + "-%d").build();
        }

        private ListeningExecutorService makeExecutor(int threads, String name, LinkedBlockingQueue<Runnable> workQueue) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(threads, threads, 30L, TimeUnit.SECONDS, workQueue, this.threadFactory(name));
            executor.allowCoreThreadTimeOut(true);
            return MoreExecutors.listeningDecorator(executor);
        }

        Cluster getCluster() {
            return Cluster.this;
        }

        LoadBalancingPolicy loadBalancingPolicy() {
            return this.configuration.getPolicies().getLoadBalancingPolicy();
        }

        SpeculativeExecutionPolicy speculativeRetryPolicy() {
            return this.configuration.getPolicies().getSpeculativeExecutionPolicy();
        }

        ReconnectionPolicy reconnectionPolicy() {
            return this.configuration.getPolicies().getReconnectionPolicy();
        }

        InetSocketAddress translateAddress(InetAddress address) {
            InetSocketAddress sa = new InetSocketAddress(address, this.connectionFactory.getPort());
            InetSocketAddress translated = this.configuration.getPolicies().getAddressTranslater().translate(sa);
            return translated == null ? sa : translated;
        }

        private AsyncInitSession newSession() {
            SessionManager session = new SessionManager(Cluster.this);
            this.sessions.add(session);
            return session;
        }

        boolean removeSession(Session session) {
            return this.sessions.remove(session);
        }

        void reportLatency(Host host, Statement statement, Exception exception, long latencyNanos) {
            for (LatencyTracker tracker : this.trackers) {
                tracker.update(host, statement, exception, latencyNanos);
            }
        }

        boolean isClosed() {
            return this.closeFuture.get() != null;
        }

        private CloseFuture close() {
            CloseFuture future = this.closeFuture.get();
            if (future != null) {
                return future;
            }
            if (this.isInit) {
                LoadBalancingPolicy loadBalancingPolicy;
                logger.debug("Shutting down");
                this.nodeListRefreshRequestDebouncer.stop();
                this.nodeRefreshRequestDebouncer.stop();
                this.schemaRefreshRequestDebouncer.stop();
                this.shutdownNow(this.reconnectionExecutor);
                this.shutdownNow(this.scheduledTasksExecutor);
                this.shutdownNow(this.blockingExecutor);
                this.executor.shutdown();
                if (this.metrics != null) {
                    this.metrics.shutdown();
                }
                if ((loadBalancingPolicy = this.loadBalancingPolicy()) instanceof CloseableLoadBalancingPolicy) {
                    ((CloseableLoadBalancingPolicy)loadBalancingPolicy).close();
                }
                this.speculativeRetryPolicy().close();
                AddressTranslater translater = this.configuration.getPolicies().getAddressTranslater();
                if (translater instanceof CloseableAddressTranslater) {
                    ((CloseableAddressTranslater)translater).close();
                }
                for (LatencyTracker latencyTracker : this.trackers) {
                    if (!(latencyTracker instanceof LifecycleAwareLatencyTracker)) continue;
                    ((LifecycleAwareLatencyTracker)latencyTracker).onUnregister(Cluster.this);
                }
                for (Host.StateListener stateListener : this.listeners) {
                    if (!(stateListener instanceof Host.LifecycleAwareStateListener)) continue;
                    ((Host.LifecycleAwareStateListener)stateListener).onUnregister(Cluster.this);
                }
                for (SchemaChangeListener schemaChangeListener : this.schemaChangeListeners) {
                    schemaChangeListener.onUnregister(Cluster.this);
                }
                ArrayList<CloseFuture> futures = new ArrayList<CloseFuture>(this.sessions.size() + 1);
                futures.add(this.controlConnection.closeAsync());
                for (Session session : this.sessions) {
                    futures.add(session.closeAsync());
                }
                future = new ClusterCloseFuture(futures);
            } else {
                future = CloseFuture.immediateFuture();
            }
            return this.closeFuture.compareAndSet(null, future) ? future : this.closeFuture.get();
        }

        private void shutdownNow(ExecutorService executor) {
            List<Runnable> pendingTasks = executor.shutdownNow();
            for (Runnable pendingTask : pendingTasks) {
                if (!(pendingTask instanceof FutureTask)) continue;
                ((FutureTask)pendingTask).cancel(false);
            }
        }

        void logUnsupportedVersionProtocol(Host host, ProtocolVersion version) {
            logger.warn("Detected added or restarted Cassandra host {} but ignoring it since it does not support the version {} of the native protocol which is currently in use. If you want to force the use of a particular version of the native protocol, use Cluster.Builder#usingProtocolVersion() when creating the Cluster instance.", (Object)host, (Object)version);
        }

        void logClusterNameMismatch(Host host, String expectedClusterName, String actualClusterName) {
            logger.warn("Detected added or restarted Cassandra host {} but ignoring it since its cluster name '{}' does not match the one currently known ({})", host, actualClusterName, expectedClusterName);
        }

        public ListenableFuture<?> triggerOnUp(final Host host) {
            if (!this.isClosed()) {
                return this.executor.submit(new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onUp(host, null);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * Exception decompiling
         */
        private void onUp(Host host, Connection reusedConnection) throws InterruptedException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public ListenableFuture<?> triggerOnDown(Host host, boolean startReconnection) {
            return this.triggerOnDown(host, false, startReconnection);
        }

        public ListenableFuture<?> triggerOnDown(final Host host, final boolean isHostAddition, final boolean startReconnection) {
            if (!this.isClosed()) {
                return this.executor.submit(new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onDown(host, isHostAddition, startReconnection);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onDown(Host host, boolean isHostAddition, boolean startReconnection) throws InterruptedException, ExecutionException {
            if (this.isClosed()) {
                return;
            }
            boolean locked = host.notificationsLock.tryLock(NOTIF_LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            if (!locked) {
                logger.warn("Could not acquire notifications lock within {} seconds, ignoring DOWN notification for {}", (Object)NOTIF_LOCK_TIMEOUT_SECONDS, (Object)host);
                return;
            }
            try {
                if (host.reconnectionAttempt.get() != null) {
                    logger.debug("Aborting onDown because a reconnection is running on DOWN host {}", (Object)host);
                    return;
                }
                Host.statesLogger.debug("[{}] marking host DOWN", (Object)host);
                HostDistance distance = this.loadBalancingPolicy().distance(host);
                boolean wasUp = host.isUp();
                host.setDown();
                this.loadBalancingPolicy().onDown(host);
                this.controlConnection.onDown(host);
                for (SessionManager s : this.sessions) {
                    s.onDown(host);
                }
                if (wasUp) {
                    for (Host.StateListener listener : this.listeners) {
                        listener.onDown(host);
                    }
                }
                if (distance == HostDistance.IGNORED || !startReconnection) {
                    return;
                }
                this.startPeriodicReconnectionAttempt(host, isHostAddition);
            }
            finally {
                host.notificationsLock.unlock();
            }
        }

        void startPeriodicReconnectionAttempt(final Host host, final boolean isHostAddition) {
            new AbstractReconnectionHandler(host.toString(), this.reconnectionExecutor, this.reconnectionPolicy().newSchedule(), host.reconnectionAttempt){

                @Override
                protected Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
                    return Manager.this.connectionFactory.open(host);
                }

                @Override
                protected void onReconnection(Connection connection) {
                    block6: {
                        if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                            logger.debug("Successful reconnection to {}, setting host UP", (Object)host);
                            try {
                                if (isHostAddition) {
                                    Manager.this.onAdd(host, connection);
                                    break block6;
                                }
                                Manager.this.onUp(host, connection);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (Exception e) {
                                logger.error("Unexpected error while setting node up", e);
                            }
                        } else {
                            logger.debug("Not enough info for {}, ignoring host", (Object)host);
                            connection.closeAsync();
                        }
                    }
                }

                @Override
                protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed reconnection to {} ({}), scheduling retry in {} milliseconds", host, e.getMessage(), nextDelayMs);
                    }
                    return true;
                }

                @Override
                protected boolean onUnknownException(Exception e, long nextDelayMs) {
                    logger.error(String.format("Unknown error during reconnection to %s, scheduling retry in %d milliseconds", host, nextDelayMs), e);
                    return true;
                }

                @Override
                protected boolean onAuthenticationException(AuthenticationException e, long nextDelayMs) {
                    logger.error(String.format("Authentication error during reconnection to %s, scheduling retry in %d milliseconds", host, nextDelayMs), e);
                    return true;
                }
            }.start();
        }

        void startSingleReconnectionAttempt(final Host host) {
            if (this.isClosed() || host.isUp()) {
                return;
            }
            logger.debug("Scheduling one-time reconnection to {}", (Object)host);
            new AbstractReconnectionHandler(host.toString(), this.reconnectionExecutor, this.reconnectionPolicy().newSchedule(), host.reconnectionAttempt, 0L){

                @Override
                protected Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
                    return Manager.this.connectionFactory.open(host);
                }

                @Override
                protected void onReconnection(Connection connection) {
                    if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                        logger.debug("Successful reconnection to {}, setting host UP", (Object)host);
                        try {
                            Manager.this.onUp(host, connection);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        catch (Exception e) {
                            logger.error("Unexpected error while setting node up", e);
                        }
                    } else {
                        logger.debug("Not enough info for {}, ignoring host", (Object)host);
                        connection.closeAsync();
                    }
                }

                @Override
                protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed one-time reconnection to {} ({})", (Object)host, (Object)e.getMessage());
                    }
                    return false;
                }

                @Override
                protected boolean onUnknownException(Exception e, long nextDelayMs) {
                    logger.error(String.format("Unknown error during one-time reconnection to %s", host), e);
                    return false;
                }

                @Override
                protected boolean onAuthenticationException(AuthenticationException e, long nextDelayMs) {
                    logger.error(String.format("Authentication error during one-time reconnection to %s", host), e);
                    return false;
                }
            }.start();
        }

        public ListenableFuture<?> triggerOnAdd(final Host host) {
            if (!this.isClosed()) {
                return this.executor.submit(new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onAdd(host, null);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * Exception decompiling
         */
        private void onAdd(Host host, Connection reusedConnection) throws InterruptedException, ExecutionException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public ListenableFuture<?> triggerOnRemove(final Host host) {
            if (!this.isClosed()) {
                return this.executor.submit(new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.onRemove(host);
                    }
                });
            }
            return MoreFutures.VOID_SUCCESS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRemove(Host host) throws InterruptedException, ExecutionException {
            if (this.isClosed()) {
                return;
            }
            boolean locked = host.notificationsLock.tryLock(NOTIF_LOCK_TIMEOUT_SECONDS, TimeUnit.SECONDS);
            if (!locked) {
                logger.warn("Could not acquire notifications lock within {} seconds, ignoring REMOVE notification for {}", (Object)NOTIF_LOCK_TIMEOUT_SECONDS, (Object)host);
                return;
            }
            try {
                host.setDown();
                Host.statesLogger.debug("[{}] removing host", (Object)host);
                this.loadBalancingPolicy().onRemove(host);
                this.controlConnection.onRemove(host);
                for (SessionManager s : this.sessions) {
                    s.onRemove(host);
                }
                for (Host.StateListener listener : this.listeners) {
                    listener.onRemove(host);
                }
            }
            finally {
                host.notificationsLock.unlock();
            }
        }

        public void signalHostDown(Host host, boolean isHostAddition) {
            if (!this.isFullyInit || this.isClosed()) {
                return;
            }
            this.triggerOnDown(host, isHostAddition, true);
        }

        public void removeHost(Host host, boolean isInitialConnection) {
            if (host == null) {
                return;
            }
            if (this.metadata.remove(host)) {
                if (isInitialConnection) {
                    logger.warn("You listed {} in your contact points, but it wasn't found in the control host's system.peers at startup", (Object)host);
                } else {
                    logger.info("Cassandra host {} removed", (Object)host);
                    this.triggerOnRemove(host);
                }
            }
        }

        public void ensurePoolsSizing() {
            if (this.protocolVersion().compareTo(ProtocolVersion.V3) >= 0) {
                return;
            }
            for (SessionManager session : this.sessions) {
                for (HostConnectionPool pool : session.pools.values()) {
                    pool.ensureCoreConnections();
                }
            }
        }

        public PreparedStatement addPrepared(PreparedStatement stmt) {
            PreparedStatement previous = this.preparedQueries.putIfAbsent(stmt.getPreparedId().id, stmt);
            if (previous != null) {
                logger.warn("Re-preparing already prepared query {}. Please note that preparing the same query more than once is generally an anti-pattern and will likely affect performance. Consider preparing the statement only once.", (Object)stmt.getQueryString());
                return previous;
            }
            return stmt;
        }

        private Connection prepareAllQueries(Host host, Connection reusedConnection) throws InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException {
            if (this.preparedQueries.isEmpty()) {
                return reusedConnection;
            }
            logger.debug("Preparing {} prepared queries on newly up node {}", (Object)this.preparedQueries.size(), (Object)host);
            Connection connection = null;
            try {
                connection = reusedConnection == null ? this.connectionFactory.open(host) : reusedConnection;
                try {
                    this.controlConnection.waitForSchemaAgreement();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                HashMultimap<String, String> perKeyspace = HashMultimap.create();
                for (PreparedStatement ps : this.preparedQueries.values()) {
                    String keyspace = ps.getQueryKeyspace() == null ? "" : ps.getQueryKeyspace();
                    perKeyspace.put(keyspace, ps.getQueryString());
                }
                for (String keyspace : perKeyspace.keySet()) {
                    if (!keyspace.isEmpty()) {
                        connection.setKeyspace(keyspace);
                    }
                    ArrayList<Connection.Future> futures = new ArrayList<Connection.Future>(this.preparedQueries.size());
                    for (String query : perKeyspace.get(keyspace)) {
                        futures.add(connection.write(new Requests.Prepare(query)));
                    }
                    for (Connection.Future future : futures) {
                        try {
                            future.get();
                        }
                        catch (ExecutionException e) {
                            logger.debug("Unexpected error while preparing queries on new/newly up host", e);
                        }
                    }
                }
                return connection;
            }
            catch (ConnectionException e) {
                if (connection != null) {
                    connection.closeAsync();
                }
                return null;
            }
            catch (AuthenticationException e) {
                if (connection != null) {
                    connection.closeAsync();
                }
                return null;
            }
            catch (BusyConnectionException e) {
                if (connection != null) {
                    connection.closeAsync();
                }
                return null;
            }
        }

        ListenableFuture<Void> submitSchemaRefresh(SchemaElement targetType, String targetKeyspace, String targetName) {
            SchemaRefreshRequest request = new SchemaRefreshRequest(targetType, targetKeyspace, targetName);
            logger.trace("Submitting schema refresh: {}", (Object)request);
            return this.schemaRefreshRequestDebouncer.eventReceived(request);
        }

        void submitNodeListRefresh() {
            logger.trace("Submitting node list and token map refresh");
            this.nodeListRefreshRequestDebouncer.eventReceived(new NodeListRefreshRequest());
        }

        void submitNodeRefresh(InetSocketAddress address, HostEvent eventType) {
            NodeRefreshRequest request = new NodeRefreshRequest(address, eventType);
            logger.trace("Submitting node refresh: {}", (Object)request);
            this.nodeRefreshRequestDebouncer.eventReceived(request);
        }

        public void refreshSchemaAndSignal(Connection connection, DefaultResultSetFuture future, ResultSet rs, SchemaElement target, String keyspace, String name) {
            if (logger.isDebugEnabled()) {
                logger.debug("Refreshing schema for {}{}", (Object)(target == null ? "everything" : keyspace), (Object)(target == SchemaElement.KEYSPACE ? "" : "." + name + " (" + (Object)((Object)target) + ")"));
            }
            this.maybeRefreshSchemaAndSignal(connection, future, rs, target, keyspace, name);
        }

        public void waitForSchemaAgreementAndSignal(Connection connection, DefaultResultSetFuture future, ResultSet rs) {
            this.maybeRefreshSchemaAndSignal(connection, future, rs, null, null, null);
        }

        private void maybeRefreshSchemaAndSignal(Connection connection, final DefaultResultSetFuture future, final ResultSet rs, final SchemaElement targetType, final String targetKeyspace, final String targetName) {
            final boolean refreshSchema = targetKeyspace != null;
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    boolean schemaInAgreement = false;
                    try {
                        schemaInAgreement = Manager.this.controlConnection.waitForSchemaAgreement();
                        if (!schemaInAgreement) {
                            logger.warn("No schema agreement from live replicas after {} s. The schema may not be up to date on some nodes.", (Object)Manager.this.configuration.getProtocolOptions().getMaxSchemaAgreementWaitSeconds());
                        }
                        ListenableFuture<Void> schemaReady = refreshSchema ? Manager.this.submitSchemaRefresh(targetType, targetKeyspace, targetName) : MoreFutures.VOID_SUCCESS;
                        final boolean finalSchemaInAgreement = schemaInAgreement;
                        schemaReady.addListener(new Runnable(){

                            @Override
                            public void run() {
                                rs.getExecutionInfo().setSchemaInAgreement(finalSchemaInAgreement);
                                future.setResult(rs);
                            }
                        }, MoreExecutors.sameThreadExecutor());
                    }
                    catch (Exception e) {
                        logger.warn("Error while waiting for schema agreement", e);
                        rs.getExecutionInfo().setSchemaInAgreement(schemaInAgreement);
                        future.setResult(rs);
                    }
                }
            });
        }

        @Override
        public void handle(Message.Response response) {
            if (!(response instanceof Responses.Event)) {
                logger.error("Received an unexpected message from the server: {}", (Object)response);
                return;
            }
            ProtocolEvent event = ((Responses.Event)response).event;
            logger.debug("Received event {}, scheduling delivery", (Object)response);
            block0 : switch (event.type) {
                case TOPOLOGY_CHANGE: {
                    ProtocolEvent.TopologyChange tpc = (ProtocolEvent.TopologyChange)event;
                    InetSocketAddress tpAddr = this.translateAddress(tpc.node.getAddress());
                    Host.statesLogger.debug("[{}] received event {}", (Object)tpAddr, (Object)tpc.change);
                    switch (tpc.change) {
                        case NEW_NODE: {
                            this.submitNodeRefresh(tpAddr, HostEvent.ADDED);
                            break;
                        }
                        case REMOVED_NODE: {
                            this.submitNodeRefresh(tpAddr, HostEvent.REMOVED);
                            break;
                        }
                        case MOVED_NODE: {
                            this.submitNodeListRefresh();
                        }
                    }
                    break;
                }
                case STATUS_CHANGE: {
                    ProtocolEvent.StatusChange stc = (ProtocolEvent.StatusChange)event;
                    InetSocketAddress stAddr = this.translateAddress(stc.node.getAddress());
                    Host.statesLogger.debug("[{}] received event {}", (Object)stAddr, (Object)stc.status);
                    switch (stc.status) {
                        case UP: {
                            this.submitNodeRefresh(stAddr, HostEvent.UP);
                            break;
                        }
                        case DOWN: {
                            this.submitNodeRefresh(stAddr, HostEvent.DOWN);
                        }
                    }
                    break;
                }
                case SCHEMA_CHANGE: {
                    if (!this.configuration.getQueryOptions().isMetadataEnabled()) {
                        return;
                    }
                    ProtocolEvent.SchemaChange scc = (ProtocolEvent.SchemaChange)event;
                    switch (scc.change) {
                        case CREATED: 
                        case UPDATED: {
                            this.submitSchemaRefresh(scc.targetType, scc.targetKeyspace, scc.targetName);
                            break block0;
                        }
                        case DROPPED: {
                            switch (scc.targetType) {
                                case KEYSPACE: {
                                    final KeyspaceMetadata removedKeyspace = Cluster.this.manager.metadata.removeKeyspace(scc.targetKeyspace);
                                    if (removedKeyspace == null) break block0;
                                    this.executor.submit(new Runnable(){

                                        @Override
                                        public void run() {
                                            Cluster.this.manager.metadata.triggerOnKeyspaceRemoved(removedKeyspace);
                                        }
                                    });
                                    break block0;
                                }
                                case TABLE: {
                                    KeyspaceMetadata keyspace = Cluster.this.manager.metadata.getKeyspaceInternal(scc.targetKeyspace);
                                    if (keyspace == null) {
                                        logger.warn("Received a DROPPED notification for table {}.{}, but this keyspace is unknown in our metadata", (Object)scc.targetKeyspace, (Object)scc.targetName);
                                        break block0;
                                    }
                                    final TableMetadata removedTable = keyspace.removeTable(scc.targetName);
                                    if (removedTable == null) break block0;
                                    this.executor.submit(new Runnable(){

                                        @Override
                                        public void run() {
                                            Cluster.this.manager.metadata.triggerOnTableRemoved(removedTable);
                                        }
                                    });
                                    break block0;
                                }
                                case TYPE: {
                                    KeyspaceMetadata keyspace = Cluster.this.manager.metadata.getKeyspaceInternal(scc.targetKeyspace);
                                    if (keyspace == null) {
                                        logger.warn("Received a DROPPED notification for UDT {}.{}, but this keyspace is unknown in our metadata", (Object)scc.targetKeyspace, (Object)scc.targetName);
                                        break block0;
                                    }
                                    final UserType removedType = keyspace.removeUserType(scc.targetName);
                                    if (removedType == null) break block0;
                                    this.executor.submit(new Runnable(){

                                        @Override
                                        public void run() {
                                            Cluster.this.manager.metadata.triggerOnUserTypeRemoved(removedType);
                                        }
                                    });
                                }
                            }
                        }
                    }
                }
            }
        }

        void refreshConnectedHosts() {
            Host ccHost = this.controlConnection.connectedHost();
            if (ccHost == null || this.loadBalancingPolicy().distance(ccHost) != HostDistance.LOCAL) {
                this.controlConnection.triggerReconnect();
            }
            try {
                for (SessionManager s : this.sessions) {
                    Uninterruptibles.getUninterruptibly(s.updateCreatedPools());
                }
            }
            catch (ExecutionException e) {
                throw DriverThrowables.propagateCause(e);
            }
        }

        void refreshConnectedHost(Host host) {
            Host ccHost = this.controlConnection.connectedHost();
            if (ccHost == null || ccHost.equals(host) && this.loadBalancingPolicy().distance(ccHost) != HostDistance.LOCAL) {
                this.controlConnection.triggerReconnect();
            }
            for (SessionManager s : this.sessions) {
                s.updateCreatedPools(host);
            }
        }

        private class NodeListRefreshRequestDeliveryCallback
        implements EventDebouncer.DeliveryCallback<NodeListRefreshRequest> {
            private NodeListRefreshRequestDeliveryCallback() {
            }

            @Override
            public ListenableFuture<?> deliver(List<NodeListRefreshRequest> events) {
                return Manager.this.executor.submit(new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        Manager.this.controlConnection.refreshNodeListAndTokenMap();
                    }
                });
            }
        }

        private class NodeListRefreshRequest {
            private NodeListRefreshRequest() {
            }

            public String toString() {
                return "Refresh node list and token map";
            }
        }

        private class NodeRefreshRequestDeliveryCallback
        implements EventDebouncer.DeliveryCallback<NodeRefreshRequest> {
            private NodeRefreshRequestDeliveryCallback() {
            }

            @Override
            public ListenableFuture<?> deliver(List<NodeRefreshRequest> events) {
                HashMap<InetSocketAddress, HostEvent> hosts = new HashMap<InetSocketAddress, HostEvent>();
                for (NodeRefreshRequest req : events) {
                    hosts.put(req.address, req.eventType);
                }
                ArrayList futures = new ArrayList(hosts.size());
                for (Map.Entry entry : hosts.entrySet()) {
                    InetSocketAddress address = (InetSocketAddress)entry.getKey();
                    HostEvent eventType = (HostEvent)((Object)entry.getValue());
                    switch (eventType) {
                        case UP: {
                            Host upHost = Manager.this.metadata.getHost(address);
                            if (upHost == null) {
                                upHost = Manager.this.metadata.add(address);
                                if (upHost == null) break;
                                futures.add(this.schedule(this.hostAdded(upHost)));
                                break;
                            }
                            futures.add(this.schedule(this.hostUp(upHost)));
                            break;
                        }
                        case ADDED: {
                            Host newHost = Manager.this.metadata.add(address);
                            if (newHost != null) {
                                futures.add(this.schedule(this.hostAdded(newHost)));
                                break;
                            }
                            Host existingHost = Manager.this.metadata.getHost(address);
                            if (existingHost.isUp()) break;
                            futures.add(this.schedule(this.hostUp(existingHost)));
                            break;
                        }
                        case DOWN: {
                            Host downHost = Manager.this.metadata.getHost(address);
                            if (downHost == null) break;
                            if (downHost.convictionPolicy.hasActiveConnections()) {
                                logger.debug("Ignoring down event on {} because it still has active connections", (Object)downHost);
                                break;
                            }
                            futures.add(this.execute(this.hostDown(downHost)));
                            break;
                        }
                        case REMOVED: {
                            Host removedHost = Manager.this.metadata.getHost(address);
                            if (removedHost == null) break;
                            futures.add(this.execute(this.hostRemoved(removedHost)));
                        }
                    }
                }
                return Futures.allAsList(futures);
            }

            private ListenableFuture<?> execute(ExceptionCatchingRunnable task) {
                return Manager.this.executor.submit(task);
            }

            private ListenableFuture<?> schedule(final ExceptionCatchingRunnable task) {
                final SettableFuture future = SettableFuture.create();
                Manager.this.scheduledTasksExecutor.schedule(new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        ListenableFuture f = NodeRefreshRequestDeliveryCallback.this.execute(task);
                        Futures.addCallback(f, new FutureCallback<Object>(){

                            @Override
                            public void onSuccess(Object result) {
                                future.set(null);
                            }

                            @Override
                            public void onFailure(Throwable t) {
                                future.setException(t);
                            }
                        });
                    }
                }, (long)NEW_NODE_DELAY_SECONDS, TimeUnit.SECONDS);
                return future;
            }

            private ExceptionCatchingRunnable hostAdded(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                            Manager.this.onAdd(host, null);
                        } else {
                            logger.debug("Not enough info for {}, ignoring host", (Object)host);
                        }
                    }
                };
            }

            private ExceptionCatchingRunnable hostUp(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        if (Manager.this.controlConnection.refreshNodeInfo(host)) {
                            Manager.this.onUp(host, null);
                        } else {
                            logger.debug("Not enough info for {}, ignoring host", (Object)host);
                        }
                    }
                };
            }

            private ExceptionCatchingRunnable hostDown(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        Manager.this.onDown(host, false, true);
                    }
                };
            }

            private ExceptionCatchingRunnable hostRemoved(final Host host) {
                return new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws Exception {
                        if (Manager.this.metadata.remove(host)) {
                            logger.info("Cassandra host {} removed", (Object)host);
                            Manager.this.onRemove(host);
                        }
                    }
                };
            }
        }

        private class NodeRefreshRequest {
            private final InetSocketAddress address;
            private final HostEvent eventType;

            private NodeRefreshRequest(InetSocketAddress address, HostEvent eventType) {
                this.address = address;
                this.eventType = eventType;
            }

            public String toString() {
                return this.address + " " + (Object)((Object)this.eventType);
            }
        }

        private class SchemaRefreshRequestDeliveryCallback
        implements EventDebouncer.DeliveryCallback<SchemaRefreshRequest> {
            private SchemaRefreshRequestDeliveryCallback() {
            }

            @Override
            public ListenableFuture<?> deliver(final List<SchemaRefreshRequest> events) {
                return Manager.this.executor.submit(new ExceptionCatchingRunnable(){

                    @Override
                    public void runMayThrow() throws InterruptedException, ExecutionException {
                        SchemaRefreshRequest coalesced = null;
                        for (SchemaRefreshRequest request : events) {
                            coalesced = coalesced == null ? request : coalesced.coalesce(request);
                        }
                        assert (coalesced != null);
                        logger.trace("Coalesced schema refresh request: {}", (Object)coalesced);
                        Manager.this.controlConnection.refreshSchema(coalesced.targetType, coalesced.targetKeyspace, coalesced.targetName);
                    }
                });
            }
        }

        private class SchemaRefreshRequest {
            private final SchemaElement targetType;
            private final String targetKeyspace;
            private final String targetName;

            public SchemaRefreshRequest(SchemaElement targetType, String targetKeyspace, String targetName) {
                this.targetType = targetType;
                this.targetKeyspace = Strings.emptyToNull(targetKeyspace);
                this.targetName = Strings.emptyToNull(targetName);
            }

            SchemaRefreshRequest coalesce(SchemaRefreshRequest that) {
                if (this.targetType == null || that.targetType == null) {
                    return new SchemaRefreshRequest(null, null, null);
                }
                if (!this.targetKeyspace.equals(that.targetKeyspace)) {
                    return new SchemaRefreshRequest(null, null, null);
                }
                if (this.targetName == null || that.targetName == null) {
                    return new SchemaRefreshRequest(SchemaElement.KEYSPACE, this.targetKeyspace, null);
                }
                if (!this.targetName.equals(that.targetName)) {
                    return new SchemaRefreshRequest(SchemaElement.KEYSPACE, this.targetKeyspace, null);
                }
                return this;
            }

            public String toString() {
                if (this.targetType == null) {
                    return "Refresh ALL";
                }
                if (this.targetName == null) {
                    return "Refresh keyspace " + this.targetKeyspace;
                }
                return String.format("Refresh %s %s.%s", new Object[]{this.targetType, this.targetKeyspace, this.targetName});
            }
        }

        private class CleanupIdleConnectionsTask
        implements Runnable {
            private CleanupIdleConnectionsTask() {
            }

            @Override
            public void run() {
                try {
                    long now = System.currentTimeMillis();
                    for (SessionManager session : Manager.this.sessions) {
                        session.cleanupIdleConnections(now);
                    }
                }
                catch (Exception e) {
                    logger.warn("Error while trashing idle connections", e);
                }
            }
        }

        private class ClusterCloseFuture
        extends CloseFuture.Forwarding {
            ClusterCloseFuture(List<CloseFuture> futures) {
                super(futures);
            }

            @Override
            public CloseFuture force() {
                Manager.this.shutdownNow(Manager.this.executor);
                return super.force();
            }

            @Override
            protected void onFuturesDone() {
                new Thread("Shutdown-checker"){

                    @Override
                    public void run() {
                        try {
                            Manager.this.reconnectionExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.scheduledTasksExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.blockingExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
                            Manager.this.connectionFactory.shutdown();
                            Manager.this.reaper.shutdown();
                            ClusterCloseFuture.this.set(null);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            ClusterCloseFuture.this.setException(e);
                        }
                    }
                }.start();
            }
        }
    }

    public static class Builder
    implements Initializer {
        private String clusterName;
        private final List<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        private final List<InetAddress> rawAddresses = new ArrayList<InetAddress>();
        private int port = 9042;
        private int maxSchemaAgreementWaitSeconds = 10;
        private ProtocolVersion protocolVersion;
        private AuthProvider authProvider = AuthProvider.NONE;
        private LoadBalancingPolicy loadBalancingPolicy;
        private ReconnectionPolicy reconnectionPolicy;
        private RetryPolicy retryPolicy;
        private AddressTranslater addressTranslater;
        private TimestampGenerator timestampGenerator;
        private SpeculativeExecutionPolicy speculativeExecutionPolicy;
        private ProtocolOptions.Compression compression = ProtocolOptions.Compression.NONE;
        private SSLOptions sslOptions = null;
        private boolean metricsEnabled = true;
        private boolean jmxEnabled = true;
        private PoolingOptions poolingOptions;
        private SocketOptions socketOptions;
        private QueryOptions queryOptions;
        private NettyOptions nettyOptions = NettyOptions.DEFAULT_INSTANCE;
        private Collection<Host.StateListener> listeners;

        @Override
        public String getClusterName() {
            return this.clusterName;
        }

        @Override
        public List<InetSocketAddress> getContactPoints() {
            if (this.rawAddresses.isEmpty()) {
                return this.addresses;
            }
            ArrayList<InetSocketAddress> allAddresses = new ArrayList<InetSocketAddress>(this.addresses);
            for (InetAddress address : this.rawAddresses) {
                allAddresses.add(new InetSocketAddress(address, this.port));
            }
            return allAddresses;
        }

        public Builder withClusterName(String name) {
            this.clusterName = name;
            return this;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder withMaxSchemaAgreementWaitSeconds(int maxSchemaAgreementWaitSeconds) {
            if (maxSchemaAgreementWaitSeconds <= 0) {
                throw new IllegalArgumentException("Max schema agreement wait must be greater than zero");
            }
            this.maxSchemaAgreementWaitSeconds = maxSchemaAgreementWaitSeconds;
            return this;
        }

        public Builder withProtocolVersion(ProtocolVersion version) {
            this.protocolVersion = version;
            return this;
        }

        @Deprecated
        public Builder withProtocolVersion(int version) {
            this.protocolVersion = ProtocolVersion.fromInt(version);
            return this;
        }

        public Builder addContactPoint(String address) {
            if (address == null) {
                throw new NullPointerException();
            }
            try {
                this.rawAddresses.add(InetAddress.getByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder addContactPoints(String address) {
            if (address == null) {
                throw new NullPointerException();
            }
            try {
                this.addContactPoints(InetAddress.getAllByName(address));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return this;
        }

        public Builder addContactPoints(InetAddress ... addresses) {
            Collections.addAll(this.rawAddresses, addresses);
            return this;
        }

        public Builder addContactPoints(Collection<InetAddress> addresses) {
            this.rawAddresses.addAll(addresses);
            return this;
        }

        public Builder addContactPointsWithPorts(InetSocketAddress ... addresses) {
            Collections.addAll(this.addresses, addresses);
            return this;
        }

        public Builder addContactPointsWithPorts(Collection<InetSocketAddress> addresses) {
            this.addresses.addAll(addresses);
            return this;
        }

        public Builder withLoadBalancingPolicy(LoadBalancingPolicy policy) {
            this.loadBalancingPolicy = policy;
            return this;
        }

        public Builder withReconnectionPolicy(ReconnectionPolicy policy) {
            this.reconnectionPolicy = policy;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy policy) {
            this.retryPolicy = policy;
            return this;
        }

        public Builder withAddressTranslater(AddressTranslater translater) {
            this.addressTranslater = translater;
            return this;
        }

        public Builder withTimestampGenerator(TimestampGenerator timestampGenerator) {
            this.timestampGenerator = timestampGenerator;
            return this;
        }

        public Builder withSpeculativeExecutionPolicy(SpeculativeExecutionPolicy policy) {
            this.speculativeExecutionPolicy = policy;
            return this;
        }

        public Builder withCredentials(String username, String password) {
            this.authProvider = new PlainTextAuthProvider(username, password);
            return this;
        }

        public Builder withAuthProvider(AuthProvider authProvider) {
            this.authProvider = authProvider;
            return this;
        }

        public Builder withCompression(ProtocolOptions.Compression compression) {
            this.compression = compression;
            return this;
        }

        public Builder withoutMetrics() {
            this.metricsEnabled = false;
            return this;
        }

        public Builder withSSL() {
            this.sslOptions = new SSLOptions();
            return this;
        }

        public Builder withSSL(SSLOptions sslOptions) {
            this.sslOptions = sslOptions;
            return this;
        }

        public Builder withInitialListeners(Collection<Host.StateListener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder withoutJMXReporting() {
            this.jmxEnabled = false;
            return this;
        }

        public Builder withPoolingOptions(PoolingOptions options) {
            this.poolingOptions = options;
            return this;
        }

        public Builder withSocketOptions(SocketOptions options) {
            this.socketOptions = options;
            return this;
        }

        public Builder withQueryOptions(QueryOptions options) {
            this.queryOptions = options;
            return this;
        }

        public Builder withNettyOptions(NettyOptions nettyOptions) {
            this.nettyOptions = nettyOptions;
            return this;
        }

        @Override
        public Configuration getConfiguration() {
            Policies policies = Policies.builder().withLoadBalancingPolicy(this.loadBalancingPolicy).withReconnectionPolicy(this.reconnectionPolicy).withRetryPolicy(this.retryPolicy).withAddressTranslater(this.addressTranslater).withTimestampGenerator(this.timestampGenerator).withSpeculativeExecutionPolicy(this.speculativeExecutionPolicy).build();
            return new Configuration(policies, new ProtocolOptions(this.port, this.protocolVersion, this.maxSchemaAgreementWaitSeconds, this.sslOptions, this.authProvider).setCompression(this.compression), this.poolingOptions == null ? new PoolingOptions() : this.poolingOptions, this.socketOptions == null ? new SocketOptions() : this.socketOptions, this.metricsEnabled ? new MetricsOptions(this.jmxEnabled) : null, this.queryOptions == null ? new QueryOptions() : this.queryOptions, this.nettyOptions);
        }

        @Override
        public Collection<Host.StateListener> getInitialListeners() {
            return this.listeners == null ? Collections.emptySet() : this.listeners;
        }

        public Cluster build() {
            return Cluster.buildFrom(this);
        }
    }

    public static interface Initializer {
        public String getClusterName();

        public List<InetSocketAddress> getContactPoints();

        public Configuration getConfiguration();

        public Collection<Host.StateListener> getInitialListeners();
    }
}

