/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.cloud.service.dps.storm.topologies.xslt.bolt;

import eu.europeana.cloud.service.commons.urls.UrlParser;
import eu.europeana.cloud.service.commons.urls.UrlPart;
import eu.europeana.cloud.service.dps.storm.AbstractDpsBolt;
import eu.europeana.cloud.service.dps.storm.StormTaskTuple;
import eu.europeana.metis.transformation.service.XsltTransformer;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XsltBolt
extends AbstractDpsBolt {
    public static final Logger LOGGER = LoggerFactory.getLogger(XsltBolt.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(StormTaskTuple stormTaskTuple) {
        StringWriter writer = null;
        try {
            String fileUrl = stormTaskTuple.getFileUrl();
            String xsltUrl = stormTaskTuple.getParameter("XSLT_URL");
            LOGGER.info("processing file: {} with xslt schema:{}", (Object)fileUrl, (Object)xsltUrl);
            String datasetValue = stormTaskTuple.getParameter("METIS_DATASET_ID");
            XsltTransformer transformer = new XsltTransformer(xsltUrl, datasetValue);
            writer = transformer.transform(this.fileToTransform(stormTaskTuple));
            LOGGER.info("XsltBolt: transformation success for: {}", (Object)fileUrl);
            stormTaskTuple.setFileData(writer.toString().getBytes(Charset.forName("UTF-8")));
            UrlParser urlParser = new UrlParser(fileUrl);
            if (urlParser.isUrlToRepresentationVersionFile()) {
                stormTaskTuple.addParameter("CLOUD_ID", urlParser.getPart(UrlPart.RECORDS));
                stormTaskTuple.addParameter("REPRESENTATION_NAME", urlParser.getPart(UrlPart.REPRESENTATIONS));
                stormTaskTuple.addParameter("REPRESENTATION_VERSION", urlParser.getPart(UrlPart.VERSIONS));
            }
            stormTaskTuple.getParameters().remove("XSLT_URL");
            this.outputCollector.emit((List)stormTaskTuple.toStormTuple());
        }
        catch (Exception e) {
            LOGGER.error("XsltBolt error:" + e.getMessage());
            this.emitErrorNotification(stormTaskTuple.getTaskId(), "", e.getMessage(), stormTaskTuple.getParameters().toString());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error("error: during closing the writter" + e.getMessage());
                }
            }
        }
    }

    private byte[] fileToTransform(StormTaskTuple stormTaskTuple) {
        return stormTaskTuple.getFileData();
    }

    public void prepare() {
    }
}

