/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.matchers;

import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.xmlunit.builder.Input;
import org.xmlunit.util.IsNullPredicate;
import org.xmlunit.util.Linqy;
import org.xmlunit.util.Mapper;
import org.xmlunit.util.Predicate;
import org.xmlunit.validation.JAXPValidator;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;

public class ValidationMatcher
extends BaseMatcher {
    private final Source[] schemaSource;
    private final Schema schema;
    private Source instance;
    private ValidationResult result;

    public ValidationMatcher(Object ... schemaSource) {
        if (schemaSource == null) {
            throw new IllegalArgumentException("schemaSource must not be null");
        }
        List<Object> schemaSourceList = Arrays.asList(schemaSource);
        if (Linqy.any(schemaSourceList, new IsNullPredicate())) {
            throw new IllegalArgumentException("schemaSource must not contain null values");
        }
        this.schemaSource = Linqy.asList(Linqy.map(schemaSourceList, new Mapper<Object, Source>(){

            @Override
            public Source apply(Object source) {
                return Input.from(source).build();
            }
        })).toArray(new Source[schemaSource.length]);
        this.schema = null;
    }

    public ValidationMatcher(Schema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("schema must not be null");
        }
        this.schemaSource = new Source[0];
        this.schema = schema;
    }

    @Override
    public boolean matches(Object instance) {
        this.instance = Input.from(instance).build();
        JAXPValidator v = new JAXPValidator("http://www.w3.org/2001/XMLSchema");
        if (this.schema != null) {
            v.setSchema(this.schema);
        } else if (this.schemaSource.length > 0) {
            v.setSchemaSources(this.schemaSource);
        }
        this.result = v.validateInstance(this.instance);
        return this.result.isValid();
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(" that ").appendValue(this.instance != null && this.instance.getSystemId() != null ? this.instance.getSystemId() : "instance");
        if (this.schema != null && Linqy.any(Arrays.asList(this.schemaSource), new HasSystemIdPredicate())) {
            description.appendText(" validates against ");
            boolean first = true;
            for (Source schema : Arrays.asList(this.schemaSource)) {
                if (!first) {
                    description.appendValue(", ");
                }
                first = false;
                description.appendValue(schema.getSystemId() != null ? schema.getSystemId() : "schema without systemId");
            }
        } else {
            description.appendText(" validates");
        }
    }

    @Override
    public void describeMismatch(Object item, Description mismatchDescription) {
        if (this.result != null && this.result.getProblems() != null) {
            mismatchDescription.appendText(" got validation errors: ");
            for (ValidationProblem problem : this.result.getProblems()) {
                mismatchDescription.appendText(problem.toString());
            }
        } else {
            mismatchDescription.appendText(" got unexpected error!");
        }
    }

    @Factory
    public static ValidationMatcher valid(Object schemaSource) {
        return new ValidationMatcher(schemaSource);
    }

    @Factory
    public static ValidationMatcher valid(Schema schema) {
        return new ValidationMatcher(schema);
    }

    private static class HasSystemIdPredicate
    implements Predicate<Source> {
        private HasSystemIdPredicate() {
        }

        @Override
        public boolean test(Source s2) {
            return s2.getSystemId() != null;
        }
    }
}

