/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredResult<T> {
    private static final Log logger = LogFactory.getLog(DeferredResult.class);
    private static final Object RESULT_NONE = new Object();
    private final Long timeout;
    private final Object timeoutResult;
    private Runnable timeoutCallback;
    private Runnable completionCallback;
    private DeferredResultHandler resultHandler;
    private Object result = RESULT_NONE;
    private boolean expired;

    public DeferredResult() {
        this(null, RESULT_NONE);
    }

    public DeferredResult(long timeout) {
        this(timeout, RESULT_NONE);
    }

    public DeferredResult(Long timeout, Object timeoutResult) {
        this.timeoutResult = timeoutResult;
        this.timeout = timeout;
    }

    public final boolean isSetOrExpired() {
        return this.result != RESULT_NONE || this.expired;
    }

    final Long getTimeoutValue() {
        return this.timeout;
    }

    public void onTimeout(Runnable callback) {
        this.timeoutCallback = callback;
    }

    public void onCompletion(Runnable callback) {
        this.completionCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResultHandler(DeferredResultHandler resultHandler) {
        Assert.notNull(resultHandler, "DeferredResultHandler is required");
        DeferredResult deferredResult = this;
        synchronized (deferredResult) {
            this.resultHandler = resultHandler;
            if (this.result != RESULT_NONE && !this.expired) {
                try {
                    this.resultHandler.handleResult(this.result);
                }
                catch (Throwable t) {
                    logger.trace("DeferredResult not handled", t);
                }
            }
        }
    }

    public boolean setResult(T result2) {
        return this.setResultInternal(result2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setResultInternal(Object result2) {
        DeferredResult deferredResult = this;
        synchronized (deferredResult) {
            if (this.isSetOrExpired()) {
                return false;
            }
            this.result = result2;
        }
        if (this.resultHandler != null) {
            this.resultHandler.handleResult(this.result);
        }
        return true;
    }

    public boolean setErrorResult(Object result2) {
        return this.setResultInternal(result2);
    }

    final DeferredResultProcessingInterceptor getInterceptor() {
        return new DeferredResultProcessingInterceptorAdapter(){

            public <S> boolean handleTimeout(NativeWebRequest request, DeferredResult<S> deferredResult) {
                if (DeferredResult.this.timeoutCallback != null) {
                    DeferredResult.this.timeoutCallback.run();
                }
                if (DeferredResult.this.timeoutResult != RESULT_NONE) {
                    DeferredResult.this.setResultInternal(DeferredResult.this.timeoutResult);
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <S> void afterCompletion(NativeWebRequest request, DeferredResult<S> deferredResult) {
                DeferredResult deferredResult2 = DeferredResult.this;
                synchronized (deferredResult2) {
                    DeferredResult.this.expired = true;
                }
                if (DeferredResult.this.completionCallback != null) {
                    DeferredResult.this.completionCallback.run();
                }
            }
        };
    }

    public static interface DeferredResultHandler {
        public void handleResult(Object var1);
    }
}

