/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.beans.PropertyEditorSupport;
import org.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.util.StringUtils;

public class TransactionAttributeEditor
extends PropertyEditorSupport {
    public void setAsText(String text2) throws IllegalArgumentException {
        if (StringUtils.hasLength(text2)) {
            String[] tokens = StringUtils.commaDelimitedListToStringArray(text2);
            RuleBasedTransactionAttribute attr = new RuleBasedTransactionAttribute();
            for (int i = 0; i < tokens.length; ++i) {
                String token2 = StringUtils.trimWhitespace(tokens[i].trim());
                if (StringUtils.containsWhitespace(token2)) {
                    throw new IllegalArgumentException("Transaction attribute token contains illegal whitespace: [" + token2 + "]");
                }
                if (token2.startsWith("PROPAGATION_")) {
                    attr.setPropagationBehaviorName(token2);
                    continue;
                }
                if (token2.startsWith("ISOLATION_")) {
                    attr.setIsolationLevelName(token2);
                    continue;
                }
                if (token2.startsWith("timeout_")) {
                    String value2 = token2.substring("timeout_".length());
                    attr.setTimeout(Integer.parseInt(value2));
                    continue;
                }
                if (token2.equals("readOnly")) {
                    attr.setReadOnly(true);
                    continue;
                }
                if (token2.startsWith("+")) {
                    attr.getRollbackRules().add(new NoRollbackRuleAttribute(token2.substring(1)));
                    continue;
                }
                if (token2.startsWith("-")) {
                    attr.getRollbackRules().add(new RollbackRuleAttribute(token2.substring(1)));
                    continue;
                }
                throw new IllegalArgumentException("Invalid transaction attribute token: [" + token2 + "]");
            }
            this.setValue(attr);
        } else {
            this.setValue(null);
        }
    }
}

