/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class SaveContextOnUpdateOrErrorResponseWrapper
extends HttpServletResponseWrapper {
    private final Log logger = LogFactory.getLog(this.getClass());
    private boolean disableSaveOnResponseCommitted;
    private boolean contextSaved = false;
    private final boolean disableUrlRewriting;

    public SaveContextOnUpdateOrErrorResponseWrapper(HttpServletResponse response, boolean disableUrlRewriting) {
        super(response);
        this.disableUrlRewriting = disableUrlRewriting;
    }

    public void disableSaveOnResponseCommitted() {
        this.disableSaveOnResponseCommitted = true;
    }

    protected abstract void saveContext(SecurityContext var1);

    public final void sendError(int sc) throws IOException {
        this.doSaveContext();
        super.sendError(sc);
    }

    public final void sendError(int sc, String msg) throws IOException {
        this.doSaveContext();
        super.sendError(sc, msg);
    }

    public final void sendRedirect(String location) throws IOException {
        this.doSaveContext();
        super.sendRedirect(location);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new SaveContextServletOutputStream(super.getOutputStream());
    }

    public PrintWriter getWriter() throws IOException {
        return new SaveContextPrintWriter(super.getWriter());
    }

    public void flushBuffer() throws IOException {
        this.doSaveContext();
        super.flushBuffer();
    }

    private void doSaveContext() {
        if (!this.disableSaveOnResponseCommitted) {
            this.saveContext(SecurityContextHolder.getContext());
            this.contextSaved = true;
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Skip saving SecurityContext since saving on response commited is disabled");
        }
    }

    public final String encodeRedirectUrl(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeRedirectUrl(url);
    }

    public final String encodeRedirectURL(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeRedirectURL(url);
    }

    public final String encodeUrl(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeUrl(url);
    }

    public final String encodeURL(String url) {
        if (this.disableUrlRewriting) {
            return url;
        }
        return super.encodeURL(url);
    }

    public final boolean isContextSaved() {
        return this.contextSaved;
    }

    private class SaveContextServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegate;

        public SaveContextServletOutputStream(ServletOutputStream delegate) {
            this.delegate = delegate;
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        public void flush() throws IOException {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            this.delegate.flush();
        }

        public void close() throws IOException {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public void print(boolean b) throws IOException {
            this.delegate.print(b);
        }

        public void print(char c) throws IOException {
            this.delegate.print(c);
        }

        public void print(double d) throws IOException {
            this.delegate.print(d);
        }

        public void print(float f) throws IOException {
            this.delegate.print(f);
        }

        public void print(int i) throws IOException {
            this.delegate.print(i);
        }

        public void print(long l) throws IOException {
            this.delegate.print(l);
        }

        public void print(String arg0) throws IOException {
            this.delegate.print(arg0);
        }

        public void println() throws IOException {
            this.delegate.println();
        }

        public void println(boolean b) throws IOException {
            this.delegate.println(b);
        }

        public void println(char c) throws IOException {
            this.delegate.println(c);
        }

        public void println(double d) throws IOException {
            this.delegate.println(d);
        }

        public void println(float f) throws IOException {
            this.delegate.println(f);
        }

        public void println(int i) throws IOException {
            this.delegate.println(i);
        }

        public void println(long l) throws IOException {
            this.delegate.println(l);
        }

        public void println(String s2) throws IOException {
            this.delegate.println(s2);
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public String toString() {
            return this.getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }
    }

    private class SaveContextPrintWriter
    extends PrintWriter {
        private final PrintWriter delegate;

        public SaveContextPrintWriter(PrintWriter delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public void flush() {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            this.delegate.flush();
        }

        public void close() {
            SaveContextOnUpdateOrErrorResponseWrapper.this.doSaveContext();
            this.delegate.close();
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public String toString() {
            return this.getClass().getName() + "[delegate=" + this.delegate.toString() + "]";
        }

        public boolean checkError() {
            return this.delegate.checkError();
        }

        public void write(int c) {
            this.delegate.write(c);
        }

        public void write(char[] buf, int off, int len) {
            this.delegate.write(buf, off, len);
        }

        public void write(char[] buf) {
            this.delegate.write(buf);
        }

        public void write(String s2, int off, int len) {
            this.delegate.write(s2, off, len);
        }

        public void write(String s2) {
            this.delegate.write(s2);
        }

        public void print(boolean b) {
            this.delegate.print(b);
        }

        public void print(char c) {
            this.delegate.print(c);
        }

        public void print(int i) {
            this.delegate.print(i);
        }

        public void print(long l) {
            this.delegate.print(l);
        }

        public void print(float f) {
            this.delegate.print(f);
        }

        public void print(double d) {
            this.delegate.print(d);
        }

        public void print(char[] s2) {
            this.delegate.print(s2);
        }

        public void print(String s2) {
            this.delegate.print(s2);
        }

        public void print(Object obj) {
            this.delegate.print(obj);
        }

        public void println() {
            this.delegate.println();
        }

        public void println(boolean x) {
            this.delegate.println(x);
        }

        public void println(char x) {
            this.delegate.println(x);
        }

        public void println(int x) {
            this.delegate.println(x);
        }

        public void println(long x) {
            this.delegate.println(x);
        }

        public void println(float x) {
            this.delegate.println(x);
        }

        public void println(double x) {
            this.delegate.println(x);
        }

        public void println(char[] x) {
            this.delegate.println(x);
        }

        public void println(String x) {
            this.delegate.println(x);
        }

        public void println(Object x) {
            this.delegate.println(x);
        }

        public PrintWriter printf(String format2, Object ... args) {
            return this.delegate.printf(format2, args);
        }

        public PrintWriter printf(Locale l, String format2, Object ... args) {
            return this.delegate.printf(l, format2, args);
        }

        public PrintWriter format(String format2, Object ... args) {
            return this.delegate.format(format2, args);
        }

        public PrintWriter format(Locale l, String format2, Object ... args) {
            return this.delegate.format(l, format2, args);
        }

        public PrintWriter append(CharSequence csq) {
            return this.delegate.append(csq);
        }

        public PrintWriter append(CharSequence csq, int start, int end) {
            return this.delegate.append(csq, start, end);
        }

        public PrintWriter append(char c) {
            return this.delegate.append(c);
        }
    }
}

