/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.vote.AbstractAclVoter;
import org.springframework.security.acls.domain.ObjectIdentityRetrievalStrategyImpl;
import org.springframework.security.acls.domain.SidRetrievalStrategyImpl;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.ObjectIdentityRetrievalStrategy;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.SidRetrievalStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AclEntryVoter
extends AbstractAclVoter {
    private static final Log logger = LogFactory.getLog(AclEntryVoter.class);
    private AclService aclService;
    private ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy = new ObjectIdentityRetrievalStrategyImpl();
    private SidRetrievalStrategy sidRetrievalStrategy = new SidRetrievalStrategyImpl();
    private String internalMethod;
    private String processConfigAttribute;
    private List<Permission> requirePermission;

    public AclEntryVoter(AclService aclService, String processConfigAttribute, Permission[] requirePermission) {
        Assert.notNull(processConfigAttribute, "A processConfigAttribute is mandatory");
        Assert.notNull(aclService, "An AclService is mandatory");
        if (requirePermission == null || requirePermission.length == 0) {
            throw new IllegalArgumentException("One or more requirePermission entries is mandatory");
        }
        this.aclService = aclService;
        this.processConfigAttribute = processConfigAttribute;
        this.requirePermission = Arrays.asList(requirePermission);
    }

    protected String getInternalMethod() {
        return this.internalMethod;
    }

    public void setInternalMethod(String internalMethod) {
        this.internalMethod = internalMethod;
    }

    protected String getProcessConfigAttribute() {
        return this.processConfigAttribute;
    }

    public void setObjectIdentityRetrievalStrategy(ObjectIdentityRetrievalStrategy objectIdentityRetrievalStrategy) {
        Assert.notNull(objectIdentityRetrievalStrategy, "ObjectIdentityRetrievalStrategy required");
        this.objectIdentityRetrievalStrategy = objectIdentityRetrievalStrategy;
    }

    public void setSidRetrievalStrategy(SidRetrievalStrategy sidRetrievalStrategy) {
        Assert.notNull(sidRetrievalStrategy, "SidRetrievalStrategy required");
        this.sidRetrievalStrategy = sidRetrievalStrategy;
    }

    @Override
    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().equals(this.getProcessConfigAttribute());
    }

    @Override
    public int vote(Authentication authentication, MethodInvocation object, Collection<ConfigAttribute> attributes) {
        for (ConfigAttribute attr : attributes) {
            Acl acl;
            if (!this.supports(attr)) continue;
            Object domainObject = this.getDomainObjectInstance(object);
            if (domainObject == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Voting to abstain - domainObject is null");
                }
                return 0;
            }
            if (StringUtils.hasText(this.internalMethod)) {
                try {
                    Class<?> clazz = domainObject.getClass();
                    Method method = clazz.getMethod(this.internalMethod, new Class[0]);
                    domainObject = method.invoke(domainObject, new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new AuthorizationServiceException("Object of class '" + domainObject.getClass() + "' does not provide the requested internalMethod: " + this.internalMethod);
                }
                catch (IllegalAccessException iae) {
                    logger.debug("IllegalAccessException", iae);
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
                catch (InvocationTargetException ite) {
                    logger.debug("InvocationTargetException", ite);
                    throw new AuthorizationServiceException("Problem invoking internalMethod: " + this.internalMethod + " for object: " + domainObject);
                }
            }
            ObjectIdentity objectIdentity = this.objectIdentityRetrievalStrategy.getObjectIdentity(domainObject);
            List<Sid> sids = this.sidRetrievalStrategy.getSids(authentication);
            try {
                acl = this.aclService.readAclById(objectIdentity, sids);
            }
            catch (NotFoundException nfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Voting to deny access - no ACLs apply for this principal");
                }
                return -1;
            }
            try {
                if (acl.isGranted(this.requirePermission, sids, false)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Voting to grant access");
                    }
                    return 1;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Voting to deny access - ACLs returned, but insufficient permissions for this principal");
                }
                return -1;
            }
            catch (NotFoundException nfe) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Voting to deny access - no ACLs apply for this principal");
                }
                return -1;
            }
        }
        return 0;
    }
}

