/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.BooleanTypedValue;

public class OpOr
extends Operator {
    public OpOr(int pos, SpelNodeImpl ... operands) {
        super("or", pos, operands);
    }

    public BooleanTypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        if (this.getBooleanValue(state, this.getLeftOperand())) {
            return BooleanTypedValue.TRUE;
        }
        return BooleanTypedValue.forValue(this.getBooleanValue(state, this.getRightOperand()));
    }

    private boolean getBooleanValue(ExpressionState state, SpelNodeImpl operand) {
        try {
            Boolean value2 = operand.getValue(state, Boolean.class);
            this.assertValueNotNull(value2);
            return value2;
        }
        catch (SpelEvaluationException ee) {
            ee.setPosition(operand.getStartPosition());
            throw ee;
        }
    }

    private void assertValueNotNull(Boolean value2) {
        if (value2 == null) {
            throw new SpelEvaluationException(SpelMessage.TYPE_CONVERSION_ERROR, "null", "boolean");
        }
    }
}

