/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.InternalParseException;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelParseException;
import org.springframework.expression.spel.ast.FloatLiteral;
import org.springframework.expression.spel.ast.IntLiteral;
import org.springframework.expression.spel.ast.LongLiteral;
import org.springframework.expression.spel.ast.RealLiteral;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public abstract class Literal
extends SpelNodeImpl {
    private final String originalValue;

    public Literal(String originalValue, int pos) {
        super(pos, new SpelNodeImpl[0]);
        this.originalValue = originalValue;
    }

    public final String getOriginalValue() {
        return this.originalValue;
    }

    public final TypedValue getValueInternal(ExpressionState state) throws SpelEvaluationException {
        return this.getLiteralValue();
    }

    public String toString() {
        return this.getLiteralValue().getValue().toString();
    }

    public String toStringAST() {
        return this.toString();
    }

    public abstract TypedValue getLiteralValue();

    public static Literal getIntLiteral(String numberToken, int pos, int radix) {
        try {
            int value2 = Integer.parseInt(numberToken, radix);
            return new IntLiteral(numberToken, pos, value2);
        }
        catch (NumberFormatException nfe) {
            throw new InternalParseException(new SpelParseException(pos >> 16, (Throwable)nfe, SpelMessage.NOT_AN_INTEGER, numberToken));
        }
    }

    public static Literal getLongLiteral(String numberToken, int pos, int radix) {
        try {
            long value2 = Long.parseLong(numberToken, radix);
            return new LongLiteral(numberToken, pos, value2);
        }
        catch (NumberFormatException nfe) {
            throw new InternalParseException(new SpelParseException(pos >> 16, (Throwable)nfe, SpelMessage.NOT_A_LONG, numberToken));
        }
    }

    public static Literal getRealLiteral(String numberToken, int pos, boolean isFloat) {
        try {
            if (isFloat) {
                float value2 = Float.parseFloat(numberToken);
                return new FloatLiteral(numberToken, pos, value2);
            }
            double value3 = Double.parseDouble(numberToken);
            return new RealLiteral(numberToken, pos, value3);
        }
        catch (NumberFormatException nfe) {
            throw new InternalParseException(new SpelParseException(pos >> 16, (Throwable)nfe, SpelMessage.NOT_A_REAL, numberToken));
        }
    }
}

