/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.util.PropertyPlaceholderHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyResolver
implements ConfigurablePropertyResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected ConfigurableConversionService conversionService = new DefaultConversionService();
    private PropertyPlaceholderHelper nonStrictHelper;
    private PropertyPlaceholderHelper strictHelper;
    private boolean ignoreUnresolvableNestedPlaceholders = false;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String valueSeparator = ":";
    private final Set<String> requiredProperties = new LinkedHashSet<String>();

    @Override
    public ConfigurableConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    public void setConversionService(ConfigurableConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value2 = this.getProperty(key);
        return value2 != null ? value2 : defaultValue;
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        T value2 = this.getProperty(key, targetType);
        return value2 != null ? value2 : defaultValue;
    }

    @Override
    public void setRequiredProperties(String ... requiredProperties) {
        for (String key : requiredProperties) {
            this.requiredProperties.add(key);
        }
    }

    @Override
    public void validateRequiredProperties() {
        MissingRequiredPropertiesException ex = new MissingRequiredPropertiesException();
        for (String key : this.requiredProperties) {
            if (this.getProperty(key) != null) continue;
            ex.addMissingRequiredProperty(key);
        }
        if (!ex.getMissingRequiredProperties().isEmpty()) {
            throw ex;
        }
    }

    @Override
    public String getRequiredProperty(String key) throws IllegalStateException {
        String value2 = this.getProperty(key);
        if (value2 == null) {
            throw new IllegalStateException(String.format("required key [%s] not found", key));
        }
        return value2;
    }

    @Override
    public <T> T getRequiredProperty(String key, Class<T> valueType) throws IllegalStateException {
        T value2 = this.getProperty(key, valueType);
        if (value2 == null) {
            throw new IllegalStateException(String.format("required key [%s] not found", key));
        }
        return value2;
    }

    @Override
    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    @Override
    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    @Override
    public void setValueSeparator(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    @Override
    public String resolvePlaceholders(String text2) {
        if (this.nonStrictHelper == null) {
            this.nonStrictHelper = this.createPlaceholderHelper(true);
        }
        return this.doResolvePlaceholders(text2, this.nonStrictHelper);
    }

    @Override
    public String resolveRequiredPlaceholders(String text2) throws IllegalArgumentException {
        if (this.strictHelper == null) {
            this.strictHelper = this.createPlaceholderHelper(false);
        }
        return this.doResolvePlaceholders(text2, this.strictHelper);
    }

    @Override
    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.ignoreUnresolvableNestedPlaceholders = ignoreUnresolvableNestedPlaceholders;
    }

    protected String resolveNestedPlaceholders(String value2) {
        return this.ignoreUnresolvableNestedPlaceholders ? this.resolvePlaceholders(value2) : this.resolveRequiredPlaceholders(value2);
    }

    private PropertyPlaceholderHelper createPlaceholderHelper(boolean ignoreUnresolvablePlaceholders) {
        return new PropertyPlaceholderHelper(this.placeholderPrefix, this.placeholderSuffix, this.valueSeparator, ignoreUnresolvablePlaceholders);
    }

    private String doResolvePlaceholders(String text2, PropertyPlaceholderHelper helper) {
        return helper.replacePlaceholders(text2, new PropertyPlaceholderHelper.PlaceholderResolver(){

            public String resolvePlaceholder(String placeholderName) {
                return AbstractPropertyResolver.this.getPropertyAsRawString(placeholderName);
            }
        });
    }

    protected abstract String getPropertyAsRawString(String var1);
}

