/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.AbstractPropertyAccessor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.MethodInvocationException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.NullValueInNestedPathException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyMatches;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanWrapperImpl
extends AbstractPropertyAccessor
implements BeanWrapper {
    private static final Log logger = LogFactory.getLog(BeanWrapperImpl.class);
    private Object object;
    private String nestedPath = "";
    private Object rootObject;
    private AccessControlContext acc;
    private CachedIntrospectionResults cachedIntrospectionResults;
    private Map<String, BeanWrapperImpl> nestedBeanWrappers;
    private boolean autoGrowNestedPaths = false;
    private int autoGrowCollectionLimit = Integer.MAX_VALUE;

    public BeanWrapperImpl() {
        this(true);
    }

    public BeanWrapperImpl(boolean registerDefaultEditors) {
        if (registerDefaultEditors) {
            this.registerDefaultEditors();
        }
        this.typeConverterDelegate = new TypeConverterDelegate(this);
    }

    public BeanWrapperImpl(Object object) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object);
    }

    public BeanWrapperImpl(Class<?> clazz) {
        this.registerDefaultEditors();
        this.setWrappedInstance(BeanUtils.instantiateClass(clazz));
    }

    public BeanWrapperImpl(Object object, String nestedPath, Object rootObject) {
        this.registerDefaultEditors();
        this.setWrappedInstance(object, nestedPath, rootObject);
    }

    private BeanWrapperImpl(Object object, String nestedPath, BeanWrapperImpl superBw) {
        this.setWrappedInstance(object, nestedPath, superBw.getWrappedInstance());
        this.setExtractOldValueForEditor(superBw.isExtractOldValueForEditor());
        this.setAutoGrowNestedPaths(superBw.isAutoGrowNestedPaths());
        this.setAutoGrowCollectionLimit(superBw.getAutoGrowCollectionLimit());
        this.setConversionService(superBw.getConversionService());
        this.setSecurityContext(superBw.acc);
    }

    public void setWrappedInstance(Object object) {
        this.setWrappedInstance(object, "", null);
    }

    public void setWrappedInstance(Object object, String nestedPath, Object rootObject) {
        Assert.notNull(object, "Bean object must not be null");
        this.object = object;
        this.nestedPath = nestedPath != null ? nestedPath : "";
        this.rootObject = !"".equals(this.nestedPath) ? rootObject : object;
        this.nestedBeanWrappers = null;
        this.typeConverterDelegate = new TypeConverterDelegate(this, object);
        this.setIntrospectionClass(object.getClass());
    }

    @Override
    public final Object getWrappedInstance() {
        return this.object;
    }

    @Override
    public final Class getWrappedClass() {
        return this.object != null ? this.object.getClass() : null;
    }

    public final String getNestedPath() {
        return this.nestedPath;
    }

    public final Object getRootInstance() {
        return this.rootObject;
    }

    public final Class getRootClass() {
        return this.rootObject != null ? this.rootObject.getClass() : null;
    }

    @Override
    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    @Override
    public boolean isAutoGrowNestedPaths() {
        return this.autoGrowNestedPaths;
    }

    @Override
    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    @Override
    public int getAutoGrowCollectionLimit() {
        return this.autoGrowCollectionLimit;
    }

    public void setSecurityContext(AccessControlContext acc) {
        this.acc = acc;
    }

    public AccessControlContext getSecurityContext() {
        return this.acc;
    }

    protected void setIntrospectionClass(Class clazz) {
        if (this.cachedIntrospectionResults != null && !clazz.equals(this.cachedIntrospectionResults.getBeanClass())) {
            this.cachedIntrospectionResults = null;
        }
    }

    private CachedIntrospectionResults getCachedIntrospectionResults() {
        Assert.state(this.object != null, "BeanWrapper does not hold a bean instance");
        if (this.cachedIntrospectionResults == null) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass(this.getWrappedClass());
        }
        return this.cachedIntrospectionResults;
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.getCachedIntrospectionResults().getPropertyDescriptors();
    }

    @Override
    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws BeansException {
        PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
        if (pd == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "No property '" + propertyName + "' found");
        }
        return pd;
    }

    protected PropertyDescriptor getPropertyDescriptorInternal(String propertyName) throws BeansException {
        Assert.notNull(propertyName, "Property name must not be null");
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        return nestedBw.getCachedIntrospectionResults().getPropertyDescriptor(this.getFinalPath(nestedBw, propertyName));
    }

    @Override
    public Class getPropertyType(String propertyName) throws BeansException {
        try {
            PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
            if (pd != null) {
                return pd.getPropertyType();
            }
            Object value2 = this.getPropertyValue(propertyName);
            if (value2 != null) {
                return value2.getClass();
            }
            Class<?> editorType = this.guessPropertyTypeFromEditors(propertyName);
            if (editorType != null) {
                return editorType;
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public TypeDescriptor getPropertyTypeDescriptor(String propertyName) throws BeansException {
        try {
            BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
            String finalPath = this.getFinalPath(nestedBw, propertyName);
            PropertyTokenHolder tokens = this.getPropertyNameTokens(finalPath);
            PropertyDescriptor pd = nestedBw.getCachedIntrospectionResults().getPropertyDescriptor(tokens.actualName);
            if (pd != null) {
                if (tokens.keys != null) {
                    if (pd.getReadMethod() != null || pd.getWriteMethod() != null) {
                        return TypeDescriptor.nested(this.property(pd), tokens.keys.length);
                    }
                } else if (pd.getReadMethod() != null || pd.getWriteMethod() != null) {
                    return new TypeDescriptor(this.property(pd));
                }
            }
        }
        catch (InvalidPropertyException invalidPropertyException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean isReadableProperty(String propertyName) {
        block4: {
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getReadMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isWritableProperty(String propertyName) {
        block4: {
            try {
                PropertyDescriptor pd = this.getPropertyDescriptorInternal(propertyName);
                if (pd != null) {
                    if (pd.getWriteMethod() != null) {
                        return true;
                    }
                    break block4;
                }
                this.getPropertyValue(propertyName);
                return true;
            }
            catch (InvalidPropertyException invalidPropertyException) {
                // empty catch block
            }
        }
        return false;
    }

    private Object convertIfNecessary(String propertyName, Object oldValue, Object newValue, Class<?> requiredType, TypeDescriptor td) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue, newValue, requiredType, td);
        }
        catch (ConverterNotFoundException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, td.getType(), (Throwable)ex);
        }
        catch (ConversionException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
        }
        catch (IllegalStateException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new ConversionNotSupportedException(pce, requiredType, (Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, requiredType, (Throwable)ex);
        }
    }

    public Object convertForProperty(Object value2, String propertyName) throws TypeMismatchException {
        PropertyDescriptor pd = this.getCachedIntrospectionResults().getPropertyDescriptor(propertyName);
        if (pd == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "No property '" + propertyName + "' found");
        }
        return this.convertForProperty(propertyName, null, value2, pd);
    }

    private Object convertForProperty(String propertyName, Object oldValue, Object newValue, PropertyDescriptor pd) throws TypeMismatchException {
        return this.convertIfNecessary(propertyName, oldValue, newValue, pd.getPropertyType(), new TypeDescriptor(this.property(pd)));
    }

    private Property property(PropertyDescriptor pd) {
        GenericTypeAwarePropertyDescriptor typeAware = (GenericTypeAwarePropertyDescriptor)pd;
        return new Property(typeAware.getBeanClass(), typeAware.getReadMethod(), typeAware.getWriteMethod(), typeAware.getName());
    }

    private String getFinalPath(BeanWrapper bw, String nestedPath) {
        if (bw == this) {
            return nestedPath;
        }
        return nestedPath.substring(PropertyAccessorUtils.getLastNestedPropertySeparatorIndex(nestedPath) + 1);
    }

    protected BeanWrapperImpl getBeanWrapperForPropertyPath(String propertyPath) {
        int pos = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex(propertyPath);
        if (pos > -1) {
            String nestedProperty = propertyPath.substring(0, pos);
            String nestedPath = propertyPath.substring(pos + 1);
            BeanWrapperImpl nestedBw = this.getNestedBeanWrapper(nestedProperty);
            return nestedBw.getBeanWrapperForPropertyPath(nestedPath);
        }
        return this;
    }

    private BeanWrapperImpl getNestedBeanWrapper(String nestedProperty) {
        BeanWrapperImpl nestedBw;
        if (this.nestedBeanWrappers == null) {
            this.nestedBeanWrappers = new HashMap<String, BeanWrapperImpl>();
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(nestedProperty);
        String canonicalName = tokens.canonicalName;
        Object propertyValue = this.getPropertyValue(tokens);
        if (propertyValue == null) {
            if (this.autoGrowNestedPaths) {
                propertyValue = this.setDefaultValue(tokens);
            } else {
                throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + canonicalName);
            }
        }
        if ((nestedBw = this.nestedBeanWrappers.get(canonicalName)) == null || nestedBw.getWrappedInstance() != propertyValue) {
            if (logger.isTraceEnabled()) {
                logger.trace("Creating new nested BeanWrapper for property '" + canonicalName + "'");
            }
            nestedBw = this.newNestedBeanWrapper(propertyValue, this.nestedPath + canonicalName + ".");
            this.copyDefaultEditorsTo(nestedBw);
            this.copyCustomEditorsTo(nestedBw, canonicalName);
            this.nestedBeanWrappers.put(canonicalName, nestedBw);
        } else if (logger.isTraceEnabled()) {
            logger.trace("Using cached nested BeanWrapper for property '" + canonicalName + "'");
        }
        return nestedBw;
    }

    private Object setDefaultValue(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        tokens.actualName = propertyName;
        tokens.canonicalName = propertyName;
        return this.setDefaultValue(tokens);
    }

    private Object setDefaultValue(PropertyTokenHolder tokens) {
        PropertyValue pv = this.createDefaultPropertyValue(tokens);
        this.setPropertyValue(tokens, pv);
        return this.getPropertyValue(tokens);
    }

    private PropertyValue createDefaultPropertyValue(PropertyTokenHolder tokens) {
        Class<?> type = this.getPropertyTypeDescriptor(tokens.canonicalName).getType();
        if (type == null) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + tokens.canonicalName, "Could not determine property type for auto-growing a default value");
        }
        Object defaultValue = this.newValue(type, tokens.canonicalName);
        return new PropertyValue(tokens.canonicalName, defaultValue);
    }

    private Object newValue(Class<?> type, String name) {
        try {
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (componentType.isArray()) {
                    Object array = Array.newInstance(componentType, 1);
                    Array.set(array, 0, Array.newInstance(componentType.getComponentType(), 0));
                    return array;
                }
                return Array.newInstance(componentType, 0);
            }
            if (Collection.class.isAssignableFrom(type)) {
                return CollectionFactory.createCollection(type, 16);
            }
            if (Map.class.isAssignableFrom(type)) {
                return CollectionFactory.createMap(type, 16);
            }
            return type.newInstance();
        }
        catch (Exception ex) {
            throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + name, "Could not instantiate property type [" + type.getName() + "] to auto-grow nested property path: " + ex);
        }
    }

    protected BeanWrapperImpl newNestedBeanWrapper(Object object, String nestedPath) {
        return new BeanWrapperImpl(object, nestedPath, this);
    }

    private PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        PropertyTokenHolder tokens = new PropertyTokenHolder();
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = propertyName.indexOf("]", keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        tokens.canonicalName = tokens.actualName = actualName != null ? actualName : propertyName;
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys, "][") + "]";
            tokens.keys = StringUtils.toStringArray(keys);
        }
        return tokens;
    }

    @Override
    public Object getPropertyValue(String propertyName) throws BeansException {
        BeanWrapperImpl nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        return nestedBw.getPropertyValue(tokens);
    }

    private Object getPropertyValue(PropertyTokenHolder tokens) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        PropertyDescriptor pd = this.getCachedIntrospectionResults().getPropertyDescriptor(actualName);
        if (pd == null || pd.getReadMethod() == null) {
            throw new NotReadablePropertyException(this.getRootClass(), this.nestedPath + propertyName);
        }
        final Method readMethod = pd.getReadMethod();
        try {
            Object value2;
            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers()) && !readMethod.isAccessible()) {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            readMethod.setAccessible(true);
                            return null;
                        }
                    });
                } else {
                    readMethod.setAccessible(true);
                }
            }
            if (System.getSecurityManager() != null) {
                try {
                    value2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            return readMethod.invoke(BeanWrapperImpl.this.object, (Object[])null);
                        }
                    }, this.acc);
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            } else {
                value2 = readMethod.invoke(this.object, (Object[])null);
            }
            if (tokens.keys != null) {
                if (value2 == null) {
                    if (this.autoGrowNestedPaths) {
                        value2 = this.setDefaultValue(tokens.actualName);
                    } else {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                }
                String indexedPropertyName = tokens.actualName;
                for (int i = 0; i < tokens.keys.length; ++i) {
                    String key = tokens.keys[i];
                    if (value2 == null) {
                        throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value of property referenced in indexed property path '" + propertyName + "': returned null");
                    }
                    if (value2.getClass().isArray()) {
                        int index2 = Integer.parseInt(key);
                        value2 = this.growArrayIfNecessary(value2, index2, indexedPropertyName);
                        value2 = Array.get(value2, index2);
                    } else if (value2 instanceof List) {
                        int index3 = Integer.parseInt(key);
                        List list2 = (List)value2;
                        this.growCollectionIfNecessary(list2, index3, indexedPropertyName, pd, i + 1);
                        value2 = list2.get(index3);
                    } else if (value2 instanceof Set) {
                        Set set = (Set)value2;
                        int index4 = Integer.parseInt(key);
                        if (index4 < 0 || index4 >= set.size()) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot get element with index " + index4 + " from Set of size " + set.size() + ", accessed using property path '" + propertyName + "'");
                        }
                        Iterator it = set.iterator();
                        int j = 0;
                        while (it.hasNext()) {
                            Object elem2 = it.next();
                            if (j == index4) {
                                value2 = elem2;
                                break;
                            }
                            ++j;
                        }
                    } else if (value2 instanceof Map) {
                        Map map2 = (Map)value2;
                        Class<?> mapKeyType = GenericCollectionTypeResolver.getMapKeyReturnType(pd.getReadMethod(), i + 1);
                        TypeDescriptor typeDescriptor = mapKeyType != null ? TypeDescriptor.valueOf(mapKeyType) : TypeDescriptor.valueOf(Object.class);
                        Object convertedMapKey = this.convertIfNecessary(null, null, key, mapKeyType, typeDescriptor);
                        value2 = map2.get(convertedMapKey);
                    } else {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Set nor a Map; returned value was [" + value2 + "]");
                    }
                    indexedPropertyName = indexedPropertyName + "[" + key + "]";
                }
            }
            return value2;
        }
        catch (IndexOutOfBoundsException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Index of out of bounds in property path '" + propertyName + "'", ex);
        }
        catch (NumberFormatException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
        catch (TypeMismatchException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid index in property path '" + propertyName + "'", ex);
        }
        catch (InvocationTargetException ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Getter for property '" + actualName + "' threw exception", ex);
        }
        catch (Exception ex) {
            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Illegal attempt to get property '" + actualName + "' threw exception", ex);
        }
    }

    private Object growArrayIfNecessary(Object array, int index2, String name) {
        if (!this.autoGrowNestedPaths) {
            return array;
        }
        int length = Array.getLength(array);
        if (index2 >= length && index2 < this.autoGrowCollectionLimit) {
            Class<?> componentType = array.getClass().getComponentType();
            Object newArray = Array.newInstance(componentType, index2 + 1);
            System.arraycopy(array, 0, newArray, 0, length);
            for (int i = length; i < Array.getLength(newArray); ++i) {
                Array.set(newArray, i, this.newValue(componentType, name));
            }
            this.setPropertyValue(name, newArray);
            return this.getPropertyValue(name);
        }
        return array;
    }

    private void growCollectionIfNecessary(Collection collection, int index2, String name, PropertyDescriptor pd, int nestingLevel) {
        Class<?> elementType;
        if (!this.autoGrowNestedPaths) {
            return;
        }
        int size2 = collection.size();
        if (index2 >= size2 && index2 < this.autoGrowCollectionLimit && (elementType = GenericCollectionTypeResolver.getCollectionReturnType(pd.getReadMethod(), nestingLevel)) != null) {
            for (int i = collection.size(); i < index2 + 1; ++i) {
                collection.add(this.newValue(elementType, name));
            }
        }
    }

    @Override
    public void setPropertyValue(String propertyName, Object value2) throws BeansException {
        BeanWrapperImpl nestedBw;
        try {
            nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
        }
        catch (NotReadablePropertyException ex) {
            throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
        }
        PropertyTokenHolder tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
        nestedBw.setPropertyValue(tokens, new PropertyValue(propertyName, value2));
    }

    @Override
    public void setPropertyValue(PropertyValue pv) throws BeansException {
        PropertyTokenHolder tokens = (PropertyTokenHolder)pv.resolvedTokens;
        if (tokens == null) {
            BeanWrapperImpl nestedBw;
            String propertyName = pv.getName();
            try {
                nestedBw = this.getBeanWrapperForPropertyPath(propertyName);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Nested property in path '" + propertyName + "' does not exist", ex);
            }
            tokens = this.getPropertyNameTokens(this.getFinalPath(nestedBw, propertyName));
            if (nestedBw == this) {
                pv.getOriginalPropertyValue().resolvedTokens = tokens;
            }
            nestedBw.setPropertyValue(tokens, pv);
        } else {
            this.setPropertyValue(tokens, pv);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setPropertyValue(PropertyTokenHolder tokens, PropertyValue pv) throws BeansException {
        String propertyName = tokens.canonicalName;
        String actualName = tokens.actualName;
        if (tokens.keys != null) {
            Object propValue;
            PropertyTokenHolder getterTokens = new PropertyTokenHolder();
            getterTokens.canonicalName = tokens.canonicalName;
            getterTokens.actualName = tokens.actualName;
            getterTokens.keys = new String[tokens.keys.length - 1];
            System.arraycopy(tokens.keys, 0, getterTokens.keys, 0, tokens.keys.length - 1);
            try {
                propValue = this.getPropertyValue(getterTokens);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "'", ex);
            }
            String key = tokens.keys[tokens.keys.length - 1];
            if (propValue == null) {
                if (!this.autoGrowNestedPaths) throw new NullValueInNestedPathException(this.getRootClass(), this.nestedPath + propertyName, "Cannot access indexed value in property referenced in indexed property path '" + propertyName + "': returned null");
                int lastKeyIndex = tokens.canonicalName.lastIndexOf(91);
                getterTokens.canonicalName = tokens.canonicalName.substring(0, lastKeyIndex);
                propValue = this.setDefaultValue(getterTokens);
            }
            if (propValue.getClass().isArray()) {
                PropertyDescriptor pd = this.getCachedIntrospectionResults().getPropertyDescriptor(actualName);
                Class<?> requiredType = propValue.getClass().getComponentType();
                int arrayIndex = Integer.parseInt(key);
                Object oldValue = null;
                try {
                    if (this.isExtractOldValueForEditor() && arrayIndex < Array.getLength(propValue)) {
                        oldValue = Array.get(propValue, arrayIndex);
                    }
                    Object convertedValue = this.convertIfNecessary(propertyName, oldValue, pv.getValue(), requiredType, TypeDescriptor.nested(this.property(pd), tokens.keys.length));
                    Array.set(propValue, arrayIndex, convertedValue);
                    return;
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid array index in property path '" + propertyName + "'", ex);
                }
            } else if (propValue instanceof List) {
                PropertyDescriptor pd = this.getCachedIntrospectionResults().getPropertyDescriptor(actualName);
                Class<?> requiredType = GenericCollectionTypeResolver.getCollectionReturnType(pd.getReadMethod(), tokens.keys.length);
                List list2 = (List)propValue;
                int index2 = Integer.parseInt(key);
                Object oldValue = null;
                if (this.isExtractOldValueForEditor() && index2 < list2.size()) {
                    oldValue = list2.get(index2);
                }
                Object convertedValue = this.convertIfNecessary(propertyName, oldValue, pv.getValue(), requiredType, TypeDescriptor.nested(this.property(pd), tokens.keys.length));
                int size2 = list2.size();
                if (index2 >= size2 && index2 < this.autoGrowCollectionLimit) {
                    for (int i = size2; i < index2; ++i) {
                        try {
                            list2.add(null);
                            continue;
                        }
                        catch (NullPointerException ex) {
                            throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Cannot set element with index " + index2 + " in List of size " + size2 + ", accessed using property path '" + propertyName + "': List does not support filling up gaps with null elements");
                        }
                    }
                    list2.add(convertedValue);
                    return;
                } else {
                    try {
                        list2.set(index2, convertedValue);
                        return;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Invalid list index in property path '" + propertyName + "'", ex);
                    }
                }
            } else {
                if (!(propValue instanceof Map)) throw new InvalidPropertyException(this.getRootClass(), this.nestedPath + propertyName, "Property referenced in indexed property path '" + propertyName + "' is neither an array nor a List nor a Map; returned value was [" + pv.getValue() + "]");
                PropertyDescriptor pd = this.getCachedIntrospectionResults().getPropertyDescriptor(actualName);
                Class<?> mapKeyType = GenericCollectionTypeResolver.getMapKeyReturnType(pd.getReadMethod(), tokens.keys.length);
                Class<?> mapValueType = GenericCollectionTypeResolver.getMapValueReturnType(pd.getReadMethod(), tokens.keys.length);
                Map map2 = (Map)propValue;
                TypeDescriptor typeDescriptor = mapKeyType != null ? TypeDescriptor.valueOf(mapKeyType) : TypeDescriptor.valueOf(Object.class);
                Object convertedMapKey = this.convertIfNecessary(null, null, key, mapKeyType, typeDescriptor);
                Object oldValue = null;
                if (this.isExtractOldValueForEditor()) {
                    oldValue = map2.get(convertedMapKey);
                }
                Object convertedMapValue = this.convertIfNecessary(propertyName, oldValue, pv.getValue(), mapValueType, TypeDescriptor.nested(this.property(pd), tokens.keys.length));
                map2.put(convertedMapKey, convertedMapValue);
            }
            return;
        }
        PropertyDescriptor pd = pv.resolvedDescriptor;
        if (pd == null || !pd.getWriteMethod().getDeclaringClass().isInstance(this.object)) {
            pd = this.getCachedIntrospectionResults().getPropertyDescriptor(actualName);
            if (pd == null || pd.getWriteMethod() == null) {
                if (pv.isOptional()) {
                    logger.debug("Ignoring optional value for property '" + actualName + "' - property not found on bean class [" + this.getRootClass().getName() + "]");
                    return;
                }
                PropertyMatches matches = PropertyMatches.forProperty(propertyName, this.getRootClass());
                throw new NotWritablePropertyException(this.getRootClass(), this.nestedPath + propertyName, matches.buildErrorMessage(), matches.getPossibleMatches());
            }
            pv.getOriginalPropertyValue().resolvedDescriptor = pd;
        }
        Object oldValue = null;
        try {
            Method writeMethod;
            Object originalValue;
            Object valueToApply = originalValue = pv.getValue();
            if (!Boolean.FALSE.equals(pv.conversionNecessary)) {
                if (pv.isConverted()) {
                    valueToApply = pv.getConvertedValue();
                } else {
                    block43: {
                        if (this.isExtractOldValueForEditor() && pd.getReadMethod() != null) {
                            final Method readMethod = pd.getReadMethod();
                            if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers()) && !readMethod.isAccessible()) {
                                if (System.getSecurityManager() != null) {
                                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                        @Override
                                        public Object run() {
                                            readMethod.setAccessible(true);
                                            return null;
                                        }
                                    });
                                } else {
                                    readMethod.setAccessible(true);
                                }
                            }
                            try {
                                oldValue = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                                    @Override
                                    public Object run() throws Exception {
                                        return readMethod.invoke(BeanWrapperImpl.this.object, new Object[0]);
                                    }
                                }, this.acc) : readMethod.invoke(this.object, new Object[0]);
                            }
                            catch (Exception ex) {
                                if (ex instanceof PrivilegedActionException) {
                                    ex = ((PrivilegedActionException)ex).getException();
                                }
                                if (!logger.isDebugEnabled()) break block43;
                                logger.debug("Could not read previous value of property '" + this.nestedPath + propertyName + "'", ex);
                            }
                        }
                    }
                    valueToApply = this.convertForProperty(propertyName, oldValue, originalValue, pd);
                }
                pv.getOriginalPropertyValue().conversionNecessary = valueToApply != originalValue;
            }
            Method method = writeMethod = pd instanceof GenericTypeAwarePropertyDescriptor ? ((GenericTypeAwarePropertyDescriptor)pd).getWriteMethodForActualAccess() : pd.getWriteMethod();
            if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers()) && !writeMethod.isAccessible()) {
                if (System.getSecurityManager() != null) {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            writeMethod.setAccessible(true);
                            return null;
                        }
                    });
                } else {
                    writeMethod.setAccessible(true);
                }
            }
            final Object value2 = valueToApply;
            if (System.getSecurityManager() != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            writeMethod.invoke(BeanWrapperImpl.this.object, value2);
                            return null;
                        }
                    }, this.acc);
                    return;
                }
                catch (PrivilegedActionException ex) {
                    throw ex.getException();
                }
            }
            writeMethod.invoke(this.object, value2);
            return;
        }
        catch (TypeMismatchException ex) {
            throw ex;
        }
        catch (InvocationTargetException ex) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, pv.getValue());
            if (!(ex.getTargetException() instanceof ClassCastException)) throw new MethodInvocationException(propertyChangeEvent, ex.getTargetException());
            throw new TypeMismatchException(propertyChangeEvent, pd.getPropertyType(), ex.getTargetException());
        }
        catch (Exception ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.rootObject, this.nestedPath + propertyName, oldValue, pv.getValue());
            throw new MethodInvocationException(pce, (Throwable)ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        if (this.object != null) {
            sb.append(": wrapping object [").append(ObjectUtils.identityToString(this.object)).append("]");
        } else {
            sb.append(": no wrapped object set");
        }
        return sb.toString();
    }

    private static class PropertyTokenHolder {
        public String canonicalName;
        public String actualName;
        public String[] keys;

        private PropertyTokenHolder() {
        }
    }
}

