/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.saxpath.base;

import org.jaxen.saxpath.base.Token;
import org.jaxen.saxpath.base.Verifier;

class XPathLexer {
    private String xpath;
    private int currentPosition;
    private int endPosition;
    private boolean expectOperator = false;

    XPathLexer(String xpath) {
        this.setXPath(xpath);
    }

    private void setXPath(String xpath) {
        this.xpath = xpath;
        this.currentPosition = 0;
        this.endPosition = xpath.length();
    }

    String getXPath() {
        return this.xpath;
    }

    Token nextToken() {
        Token token2 = null;
        do {
            token2 = null;
            block0 : switch (this.LA(1)) {
                case '$': {
                    token2 = this.dollar();
                    break;
                }
                case '\"': 
                case '\'': {
                    token2 = this.literal();
                    break;
                }
                case '/': {
                    token2 = this.slashes();
                    break;
                }
                case ',': {
                    token2 = this.comma();
                    break;
                }
                case '(': {
                    token2 = this.leftParen();
                    break;
                }
                case ')': {
                    token2 = this.rightParen();
                    break;
                }
                case '[': {
                    token2 = this.leftBracket();
                    break;
                }
                case ']': {
                    token2 = this.rightBracket();
                    break;
                }
                case '+': {
                    token2 = this.plus();
                    break;
                }
                case '-': {
                    token2 = this.minus();
                    break;
                }
                case '<': 
                case '>': {
                    token2 = this.relationalOperator();
                    break;
                }
                case '=': {
                    token2 = this.equals();
                    break;
                }
                case '!': {
                    if (this.LA(2) != '=') break;
                    token2 = this.notEquals();
                    break;
                }
                case '|': {
                    token2 = this.pipe();
                    break;
                }
                case '@': {
                    token2 = this.at();
                    break;
                }
                case ':': {
                    if (this.LA(2) == ':') {
                        token2 = this.doubleColon();
                        break;
                    }
                    token2 = this.colon();
                    break;
                }
                case '*': {
                    token2 = this.star();
                    break;
                }
                case '.': {
                    switch (this.LA(2)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            token2 = this.number();
                            break block0;
                        }
                    }
                    token2 = this.dots();
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    token2 = this.number();
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    token2 = this.whitespace();
                    break;
                }
                default: {
                    if (!Verifier.isXMLNCNameStartCharacter(this.LA(1))) break;
                    token2 = this.identifierOrOperatorName();
                }
            }
            if (token2 != null) continue;
            token2 = !this.hasMoreChars() ? new Token(-1, this.getXPath(), this.currentPosition, this.endPosition) : new Token(-3, this.getXPath(), this.currentPosition, this.endPosition);
        } while (token2.getTokenType() == -2);
        switch (token2.getTokenType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                this.expectOperator = false;
                break;
            }
            default: {
                this.expectOperator = true;
            }
        }
        return token2;
    }

    private Token identifierOrOperatorName() {
        Token token2 = null;
        token2 = this.expectOperator ? this.operatorName() : this.identifier();
        return token2;
    }

    private Token identifier() {
        Token token2 = null;
        int start = this.currentPosition;
        while (this.hasMoreChars() && Verifier.isXMLNCNameCharacter(this.LA(1))) {
            this.consume();
        }
        token2 = new Token(16, this.getXPath(), start, this.currentPosition);
        return token2;
    }

    private Token operatorName() {
        Token token2 = null;
        switch (this.LA(1)) {
            case 'a': {
                token2 = this.and();
                break;
            }
            case 'o': {
                token2 = this.or();
                break;
            }
            case 'm': {
                token2 = this.mod();
                break;
            }
            case 'd': {
                token2 = this.div();
            }
        }
        return token2;
    }

    private Token mod() {
        Token token2 = null;
        if (this.LA(1) == 'm' && this.LA(2) == 'o' && this.LA(3) == 'd') {
            token2 = new Token(10, this.getXPath(), this.currentPosition, this.currentPosition + 3);
            this.consume();
            this.consume();
            this.consume();
        }
        return token2;
    }

    private Token div() {
        Token token2 = null;
        if (this.LA(1) == 'd' && this.LA(2) == 'i' && this.LA(3) == 'v') {
            token2 = new Token(11, this.getXPath(), this.currentPosition, this.currentPosition + 3);
            this.consume();
            this.consume();
            this.consume();
        }
        return token2;
    }

    private Token and() {
        Token token2 = null;
        if (this.LA(1) == 'a' && this.LA(2) == 'n' && this.LA(3) == 'd') {
            token2 = new Token(27, this.getXPath(), this.currentPosition, this.currentPosition + 3);
            this.consume();
            this.consume();
            this.consume();
        }
        return token2;
    }

    private Token or() {
        Token token2 = null;
        if (this.LA(1) == 'o' && this.LA(2) == 'r') {
            token2 = new Token(28, this.getXPath(), this.currentPosition, this.currentPosition + 2);
            this.consume();
            this.consume();
        }
        return token2;
    }

    private Token number() {
        int start = this.currentPosition;
        boolean periodAllowed = true;
        block4: while (true) {
            switch (this.LA(1)) {
                case '.': {
                    if (!periodAllowed) break block4;
                    periodAllowed = false;
                    this.consume();
                    continue block4;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.consume();
                    continue block4;
                }
            }
            break;
        }
        return new Token(29, this.getXPath(), start, this.currentPosition);
    }

    private Token whitespace() {
        this.consume();
        block3: while (this.hasMoreChars()) {
            switch (this.LA(1)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    this.consume();
                    continue block3;
                }
            }
        }
        return new Token(-2, this.getXPath(), 0, 0);
    }

    private Token comma() {
        Token token2 = new Token(30, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token equals() {
        Token token2 = new Token(1, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token minus() {
        Token token2 = new Token(8, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token plus() {
        Token token2 = new Token(7, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token dollar() {
        Token token2 = new Token(25, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token pipe() {
        Token token2 = new Token(18, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token at() {
        Token token2 = new Token(17, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token colon() {
        Token token2 = new Token(19, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token doubleColon() {
        Token token2 = new Token(20, this.getXPath(), this.currentPosition, this.currentPosition + 2);
        this.consume();
        this.consume();
        return token2;
    }

    private Token notEquals() {
        Token token2 = new Token(2, this.getXPath(), this.currentPosition, this.currentPosition + 2);
        this.consume();
        this.consume();
        return token2;
    }

    private Token relationalOperator() {
        Token token2 = null;
        switch (this.LA(1)) {
            case '<': {
                if (this.LA(2) == '=') {
                    token2 = new Token(4, this.getXPath(), this.currentPosition, this.currentPosition + 2);
                    this.consume();
                } else {
                    token2 = new Token(3, this.getXPath(), this.currentPosition, this.currentPosition + 1);
                }
                this.consume();
                break;
            }
            case '>': {
                if (this.LA(2) == '=') {
                    token2 = new Token(6, this.getXPath(), this.currentPosition, this.currentPosition + 2);
                    this.consume();
                } else {
                    token2 = new Token(5, this.getXPath(), this.currentPosition, this.currentPosition + 1);
                }
                this.consume();
            }
        }
        return token2;
    }

    private Token star() {
        int tokenType = this.expectOperator ? 31 : 9;
        Token token2 = new Token(tokenType, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token literal() {
        Token token2 = null;
        char match = this.LA(1);
        this.consume();
        int start = this.currentPosition;
        while (token2 == null && this.hasMoreChars()) {
            if (this.LA(1) == match) {
                token2 = new Token(26, this.getXPath(), start, this.currentPosition);
            }
            this.consume();
        }
        return token2;
    }

    private Token dots() {
        Token token2 = null;
        switch (this.LA(2)) {
            case '.': {
                token2 = new Token(15, this.getXPath(), this.currentPosition, this.currentPosition + 2);
                this.consume();
                this.consume();
                break;
            }
            default: {
                token2 = new Token(14, this.getXPath(), this.currentPosition, this.currentPosition + 1);
                this.consume();
            }
        }
        return token2;
    }

    private Token leftBracket() {
        Token token2 = new Token(21, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token rightBracket() {
        Token token2 = new Token(22, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token leftParen() {
        Token token2 = new Token(23, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token rightParen() {
        Token token2 = new Token(24, this.getXPath(), this.currentPosition, this.currentPosition + 1);
        this.consume();
        return token2;
    }

    private Token slashes() {
        Token token2 = null;
        switch (this.LA(2)) {
            case '/': {
                token2 = new Token(13, this.getXPath(), this.currentPosition, this.currentPosition + 2);
                this.consume();
                this.consume();
                break;
            }
            default: {
                token2 = new Token(12, this.getXPath(), this.currentPosition, this.currentPosition + 1);
                this.consume();
            }
        }
        return token2;
    }

    private char LA(int i) {
        if (this.currentPosition + (i - 1) >= this.endPosition) {
            return '\uffff';
        }
        return this.getXPath().charAt(this.currentPosition + (i - 1));
    }

    private void consume() {
        ++this.currentPosition;
    }

    private boolean hasMoreChars() {
        return this.currentPosition < this.endPosition;
    }
}

