/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.function.ext;

import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.jaxen.Function;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public abstract class LocaleFunctionSupport
implements Function {
    protected Locale getLocale(Object value2, Navigator navigator) {
        if (value2 instanceof Locale) {
            return (Locale)value2;
        }
        if (value2 instanceof List) {
            List list2 = (List)value2;
            if (!list2.isEmpty()) {
                return this.getLocale(list2.get(0), navigator);
            }
        } else {
            String text2 = StringFunction.evaluate(value2, navigator);
            if (text2 != null && text2.length() > 0) {
                return this.findLocale(text2);
            }
        }
        return null;
    }

    protected Locale findLocale(String localeText) {
        StringTokenizer tokens = new StringTokenizer(localeText, "-");
        if (tokens.hasMoreTokens()) {
            String language2 = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return this.findLocaleForLanguage(language2);
            }
            String country = tokens.nextToken();
            if (!tokens.hasMoreTokens()) {
                return new Locale(language2, country);
            }
            String variant = tokens.nextToken();
            return new Locale(language2, country, variant);
        }
        return null;
    }

    protected Locale findLocaleForLanguage(String language2) {
        Locale[] locales = Locale.getAvailableLocales();
        int size2 = locales.length;
        for (int i = 0; i < size2; ++i) {
            String variant;
            String country;
            Locale locale = locales[i];
            if (!language2.equals(locale.getLanguage()) || (country = locale.getCountry()) != null && country.length() != 0 || (variant = locale.getVariant()) != null && variant.length() != 0) continue;
            return locale;
        }
        return null;
    }
}

