/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.generator.qdox.model.Annotation;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.annotation.AnnotationAdd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationAnd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationCast;
import org.hamcrest.generator.qdox.model.annotation.AnnotationConstant;
import org.hamcrest.generator.qdox.model.annotation.AnnotationDivide;
import org.hamcrest.generator.qdox.model.annotation.AnnotationEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationExclusiveOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationFieldRef;
import org.hamcrest.generator.qdox.model.annotation.AnnotationGreaterEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationGreaterThan;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLessEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLessThan;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalAnd;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalNot;
import org.hamcrest.generator.qdox.model.annotation.AnnotationLogicalOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationMinusSign;
import org.hamcrest.generator.qdox.model.annotation.AnnotationMultiply;
import org.hamcrest.generator.qdox.model.annotation.AnnotationNot;
import org.hamcrest.generator.qdox.model.annotation.AnnotationNotEquals;
import org.hamcrest.generator.qdox.model.annotation.AnnotationOr;
import org.hamcrest.generator.qdox.model.annotation.AnnotationParenExpression;
import org.hamcrest.generator.qdox.model.annotation.AnnotationPlusSign;
import org.hamcrest.generator.qdox.model.annotation.AnnotationQuery;
import org.hamcrest.generator.qdox.model.annotation.AnnotationRemainder;
import org.hamcrest.generator.qdox.model.annotation.AnnotationShiftLeft;
import org.hamcrest.generator.qdox.model.annotation.AnnotationShiftRight;
import org.hamcrest.generator.qdox.model.annotation.AnnotationSubtract;
import org.hamcrest.generator.qdox.model.annotation.AnnotationTypeRef;
import org.hamcrest.generator.qdox.model.annotation.AnnotationUnsignedShiftRight;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValue;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValueList;
import org.hamcrest.generator.qdox.model.annotation.AnnotationVisitor;

public abstract class EvaluatingVisitor
implements AnnotationVisitor {
    public Object getValue(Annotation annotation, String property) {
        Object result2 = null;
        AnnotationValue value2 = annotation.getProperty(property);
        if (value2 != null) {
            result2 = value2.accept(this);
        }
        return result2;
    }

    public List getListValue(Annotation annotation, String property) {
        Object value2 = this.getValue(annotation, property);
        List<Object> list2 = null;
        if (value2 != null) {
            list2 = value2 instanceof List ? (List<Object>)value2 : Collections.singletonList(value2);
        }
        return list2;
    }

    protected static Class resultType(Object left, Object right) {
        Class type = Void.TYPE;
        if (left instanceof String || right instanceof String) {
            type = String.class;
        } else if (left instanceof Number && right instanceof Number) {
            type = left instanceof Double || right instanceof Double ? Double.class : (left instanceof Float || right instanceof Float ? Float.class : (left instanceof Long || right instanceof Long ? Long.class : Integer.class));
        }
        return type;
    }

    protected static Class numericResultType(Object left, Object right) {
        Class type = Void.TYPE;
        if (left instanceof Number && right instanceof Number) {
            if (left instanceof Long || right instanceof Long) {
                type = Long.class;
            } else if (left instanceof Integer || right instanceof Integer) {
                type = Integer.class;
            }
        }
        return type;
    }

    protected static Class unaryNumericResultType(Object value2) {
        Class type = Void.TYPE;
        if (value2 instanceof Byte || value2 instanceof Short || value2 instanceof Character || value2 instanceof Integer) {
            type = Integer.class;
        } else if (value2 instanceof Long) {
            value2 = Long.class;
        }
        return type;
    }

    protected static Class unaryResultType(Object value2) {
        Class type = EvaluatingVisitor.unaryNumericResultType(value2);
        if (type == Void.TYPE) {
            if (value2 instanceof Float) {
                value2 = Float.class;
            } else if (value2 instanceof Double) {
                value2 = Double.class;
            }
        }
        return type;
    }

    public Object visitAnnotation(Annotation annotation) {
        throw new UnsupportedOperationException("Illegal annotation value '" + annotation + "'.");
    }

    public Object visitAnnotationAdd(AnnotationAdd op) {
        Object result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == String.class) {
            result2 = left.toString() + right.toString();
        } else if (type == Double.class) {
            result2 = new Double(((Number)left).doubleValue() + ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result2 = new Float(((Number)left).floatValue() + ((Number)right).floatValue());
        } else if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() + ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() + ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    public Object visitAnnotationConstant(AnnotationConstant constant) {
        return constant.getValue();
    }

    public Object visitAnnotationDivide(AnnotationDivide op) {
        Number result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result2 = new Double(((Number)left).doubleValue() / ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result2 = new Float(((Number)left).floatValue() / ((Number)right).floatValue());
        } else if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() / ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() / ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    public Object visitAnnotationFieldRef(AnnotationFieldRef fieldRef) {
        JavaField javaField = fieldRef.getField();
        if (javaField == null) {
            throw new IllegalArgumentException("Cannot resolve field reference '" + fieldRef + "'.");
        }
        if (!javaField.isFinal() || !javaField.isStatic()) {
            throw new IllegalArgumentException("Field reference '" + fieldRef + "' must be static and final.");
        }
        Object result2 = this.getFieldReferenceValue(javaField);
        return result2;
    }

    protected abstract Object getFieldReferenceValue(JavaField var1);

    public Object visitAnnotationGreaterThan(AnnotationGreaterThan op) {
        boolean result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result2 = ((Number)left).doubleValue() > ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result2 = ((Number)left).floatValue() > ((Number)right).floatValue();
        } else if (type == Long.class) {
            result2 = ((Number)left).longValue() > ((Number)right).longValue();
        } else if (type == Integer.class) {
            result2 = ((Number)left).intValue() > ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLessThan(AnnotationLessThan op) {
        boolean result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result2 = ((Number)left).doubleValue() < ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result2 = ((Number)left).floatValue() < ((Number)right).floatValue();
        } else if (type == Long.class) {
            result2 = ((Number)left).longValue() < ((Number)right).longValue();
        } else if (type == Integer.class) {
            result2 = ((Number)left).intValue() < ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationMultiply(AnnotationMultiply op) {
        Number result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result2 = new Double(((Number)left).doubleValue() * ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result2 = new Float(((Number)left).floatValue() * ((Number)right).floatValue());
        } else if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() * ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() * ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    public Object visitAnnotationParenExpression(AnnotationParenExpression parenExpression) {
        return parenExpression.getValue().accept(this);
    }

    public Object visitAnnotationSubtract(AnnotationSubtract op) {
        Number result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type == Double.class) {
            result2 = new Double(((Number)left).doubleValue() - ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result2 = new Float(((Number)left).floatValue() - ((Number)right).floatValue());
        } else if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() - ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() - ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    public Object visitAnnotationTypeRef(AnnotationTypeRef typeRef) {
        JavaClass javaClass = typeRef.getType().getJavaClass();
        return javaClass;
    }

    public Object visitAnnotationValueList(AnnotationValueList valueList) {
        ArrayList<Object> list2 = new ArrayList<Object>();
        ListIterator i = valueList.getValueList().listIterator();
        while (i.hasNext()) {
            AnnotationValue value2 = (AnnotationValue)i.next();
            Object v = value2.accept(this);
            list2.add(v);
        }
        return list2;
    }

    public Object visitAnnotationAnd(AnnotationAnd and2) {
        Number result2;
        Object right;
        Object left = and2.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = and2.getRight().accept(this));
        if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() & ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() & ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + and2 + "'.");
        }
        return result2;
    }

    public Object visitAnnotationGreaterEquals(AnnotationGreaterEquals greaterEquals) {
        boolean result2;
        Object right;
        Object left = greaterEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = greaterEquals.getRight().accept(this));
        if (type == Double.class) {
            result2 = ((Number)left).doubleValue() >= ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result2 = ((Number)left).floatValue() >= ((Number)right).floatValue();
        } else if (type == Long.class) {
            result2 = ((Number)left).longValue() >= ((Number)right).longValue();
        } else if (type == Integer.class) {
            result2 = ((Number)left).intValue() >= ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + greaterEquals + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLessEquals(AnnotationLessEquals lessEquals) {
        boolean result2;
        Object right;
        Object left = lessEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = lessEquals.getRight().accept(this));
        if (type == Double.class) {
            result2 = ((Number)left).doubleValue() <= ((Number)right).doubleValue();
        } else if (type == Float.class) {
            result2 = ((Number)left).floatValue() <= ((Number)right).floatValue();
        } else if (type == Long.class) {
            result2 = ((Number)left).longValue() <= ((Number)right).longValue();
        } else if (type == Integer.class) {
            result2 = ((Number)left).intValue() <= ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + lessEquals + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLogicalAnd(AnnotationLogicalAnd and2) {
        Object left = and2.getLeft().accept(this);
        Object right = and2.getRight().accept(this);
        if (!(left instanceof Boolean) || !(right instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + and2 + "'.");
        }
        boolean result2 = (Boolean)left != false && (Boolean)right != false;
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLogicalNot(AnnotationLogicalNot not2) {
        Object value2 = not2.getValue().accept(this);
        if (!(value2 instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + not2 + "'.");
        }
        boolean result2 = (Boolean)value2 == false;
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationLogicalOr(AnnotationLogicalOr or) {
        Object left = or.getLeft().accept(this);
        Object right = or.getRight().accept(this);
        if (!(left instanceof Boolean) || !(right instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + or + "'.");
        }
        boolean result2 = (Boolean)left != false || (Boolean)right != false;
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationMinusSign(AnnotationMinusSign sign2) {
        Number result2;
        Object value2 = sign2.getValue().accept(this);
        Class type = EvaluatingVisitor.unaryResultType(value2);
        if (type == Integer.class) {
            result2 = new Integer(-((Integer)value2).intValue());
        } else if (type == Long.class) {
            result2 = new Long(-((Long)value2).longValue());
        } else if (type == Float.class) {
            result2 = new Float(-((Float)value2).floatValue());
        } else if (type == Double.class) {
            result2 = new Double(-((Double)value2).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + sign2 + "'.");
        }
        return result2;
    }

    public Object visitAnnotationNot(AnnotationNot not2) {
        Number result2;
        Object value2 = not2.getValue().accept(this);
        Class type = EvaluatingVisitor.unaryNumericResultType(value2);
        if (type == Long.class) {
            result2 = new Long((long)((Long)value2 ^ 0xFFFFFFFFFFFFFFFFL));
        } else if (type == Integer.class) {
            result2 = new Integer(~((Integer)value2).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + not2 + "'.");
        }
        return result2;
    }

    public Object visitAnnotationOr(AnnotationOr or) {
        Number result2;
        Object right;
        Object left = or.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = or.getRight().accept(this));
        if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() | ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() | ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + or + "'.");
        }
        return result2;
    }

    public Object visitAnnotationPlusSign(AnnotationPlusSign sign2) {
        Object value2 = sign2.getValue().accept(this);
        if (!(value2 instanceof Number)) {
            throw new IllegalArgumentException("Cannot evaluate '" + sign2 + "'.");
        }
        Object result2 = value2;
        return result2;
    }

    public Object visitAnnotationRemainder(AnnotationRemainder remainder) {
        Number result2;
        Object right;
        Object left = remainder.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = remainder.getRight().accept(this));
        if (type == Double.class) {
            result2 = new Double(((Number)left).doubleValue() % ((Number)right).doubleValue());
        } else if (type == Float.class) {
            result2 = new Float(((Number)left).floatValue() % ((Number)right).floatValue());
        } else if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() % ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() % ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + remainder + "'.");
        }
        return result2;
    }

    public Object visitAnnotationShiftLeft(AnnotationShiftLeft shiftLeft) {
        Number result2;
        Object right;
        Object left = shiftLeft.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = shiftLeft.getRight().accept(this));
        if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() << (int)((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() << ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftLeft + "'.");
        }
        return result2;
    }

    public Object visitAnnotationShiftRight(AnnotationShiftRight shiftRight) {
        Number result2;
        Object right;
        Object left = shiftRight.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = shiftRight.getRight().accept(this));
        if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() >> (int)((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() >> ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftRight + "'.");
        }
        return result2;
    }

    public Object visitAnnotationUnsignedShiftRight(AnnotationUnsignedShiftRight shiftRight) {
        Number result2;
        Object right;
        Object left = shiftRight.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = shiftRight.getRight().accept(this));
        if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() >>> (int)((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() >>> ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftRight + "'.");
        }
        return result2;
    }

    public Object visitAnnotationEquals(AnnotationEquals annotationEquals) {
        Object right;
        Object left = annotationEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = annotationEquals.getRight().accept(this));
        boolean result2 = type == Double.class ? ((Number)left).doubleValue() == ((Number)right).doubleValue() : (type == Float.class ? ((Number)left).floatValue() == ((Number)right).floatValue() : (type == Long.class ? ((Number)left).longValue() == ((Number)right).longValue() : (type == Integer.class ? ((Number)left).intValue() == ((Number)right).intValue() : left == right)));
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationExclusiveOr(AnnotationExclusiveOr annotationExclusiveOr) {
        Number result2;
        Object right;
        Object left = annotationExclusiveOr.getLeft().accept(this);
        Class type = EvaluatingVisitor.numericResultType(left, right = annotationExclusiveOr.getRight().accept(this));
        if (type == Long.class) {
            result2 = new Long(((Number)left).longValue() ^ ((Number)right).longValue());
        } else if (type == Integer.class) {
            result2 = new Integer(((Number)left).intValue() ^ ((Number)right).intValue());
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationExclusiveOr + "'.");
        }
        return result2;
    }

    public Object visitAnnotationNotEquals(AnnotationNotEquals annotationNotEquals) {
        Object right;
        Object left = annotationNotEquals.getLeft().accept(this);
        Class type = EvaluatingVisitor.resultType(left, right = annotationNotEquals.getRight().accept(this));
        boolean result2 = type == Double.class ? ((Number)left).doubleValue() != ((Number)right).doubleValue() : (type == Float.class ? ((Number)left).floatValue() != ((Number)right).floatValue() : (type == Long.class ? ((Number)left).longValue() != ((Number)right).longValue() : (type == Integer.class ? ((Number)left).intValue() != ((Number)right).intValue() : left == right)));
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public Object visitAnnotationQuery(AnnotationQuery annotationQuery) {
        Object value2 = annotationQuery.getCondition().accept(this);
        if (value2 == null || !(value2 instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationQuery + "'.");
        }
        AnnotationValue expression = (Boolean)value2 != false ? annotationQuery.getTrueExpression() : annotationQuery.getFalseExpression();
        return expression.accept(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object visitAnnotationCast(AnnotationCast annotationCast) {
        Object value2 = annotationCast.getValue().accept(this);
        String type = annotationCast.getType().getJavaClass().getFullyQualifiedName();
        if (value2 instanceof Number) {
            Number n = (Number)value2;
            if (type.equals("byte")) {
                return new Byte(n.byteValue());
            }
            if (type.equals("char")) {
                return new Character((char)n.intValue());
            }
            if (type.equals("short")) {
                return new Short(n.shortValue());
            }
            if (type.equals("int")) {
                return new Integer(n.intValue());
            }
            if (type.equals("long")) {
                return new Long(n.longValue());
            }
            if (type.equals("float")) {
                return new Float(n.floatValue());
            }
            if (!type.equals("double")) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
            return new Double(n.doubleValue());
        }
        if (!(value2 instanceof String)) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
        if (!type.equals("java.lang.String")) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
        return value2;
    }
}

