/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model.annotation;

import java.util.StringTokenizer;
import org.hamcrest.generator.qdox.model.AbstractBaseJavaEntity;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaClassParent;
import org.hamcrest.generator.qdox.model.JavaField;
import org.hamcrest.generator.qdox.model.Type;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValue;
import org.hamcrest.generator.qdox.model.annotation.AnnotationVisitor;

public class AnnotationFieldRef
implements AnnotationValue {
    String[] myArray = new String[]{"unchecked"};
    private final int[] parts;
    private final String name;
    private AbstractBaseJavaEntity context;
    private JavaField field;
    private int fieldIndex = -1;

    public AnnotationFieldRef(String name) {
        this.name = name;
        int length = new StringTokenizer(name, ".").countTokens();
        this.parts = new int[length + 1];
        this.parts[0] = -1;
        for (int i = 1; i < length; ++i) {
            this.parts[i] = name.indexOf(46, this.parts[i - 1] + 1);
        }
        this.parts[length] = name.length();
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrefix(int end) {
        return this.name.substring(0, this.parts[end + 1]);
    }

    public String getNamePart(int index2) {
        return this.name.substring(this.parts[index2] + 1, this.parts[index2 + 1]);
    }

    public int getPartCount() {
        return this.parts.length - 1;
    }

    public Object accept(AnnotationVisitor visitor) {
        return visitor.visitAnnotationFieldRef(this);
    }

    public Object getParameterValue() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public AbstractBaseJavaEntity getContext() {
        return this.context;
    }

    public void setContext(AbstractBaseJavaEntity context) {
        this.context = context;
    }

    public String getClassPart() {
        String result2 = null;
        if (this.getField() != null) {
            result2 = this.name.substring(0, this.parts[this.fieldIndex]);
        }
        return result2;
    }

    public String getFieldPart() {
        String result2 = null;
        if (this.getField() != null) {
            result2 = this.name.substring(this.parts[this.fieldIndex] + 1);
        }
        return result2;
    }

    protected JavaField resolveField(JavaClass javaClass, int start, int end) {
        JavaField field2 = null;
        for (int i = start; i < end && (field2 = javaClass.getFieldByName(this.getNamePart(i))) != null; ++i) {
            javaClass = field2.getType().getJavaClass();
        }
        return field2;
    }

    public JavaField getField() {
        if (this.fieldIndex < 0) {
            if (this.context.getParentClass() != null) {
                JavaClass javaClass = this.context.getParentClass();
                this.field = this.resolveField(javaClass, 0, this.parts.length - 1);
                this.fieldIndex = 0;
            }
            if (this.field == null) {
                JavaClass classParent = this.context.getParentClass();
                if (classParent == null) {
                    classParent = (JavaClass)this.context;
                }
                for (int i = 0; i < this.parts.length - 1; ++i) {
                    Type type;
                    JavaClass javaClass;
                    String className = this.getNamePrefix(i);
                    String typeName = classParent.resolveType(className);
                    if (typeName == null || (javaClass = (type = Type.createUnresolved(typeName, 0, (JavaClassParent)classParent)).getJavaClass()) == null) continue;
                    this.fieldIndex = i + 1;
                    this.field = this.resolveField(javaClass, i + 1, this.parts.length - 1);
                    break;
                }
            }
        }
        return this.field;
    }
}

