/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.io.Serializable;
import org.hamcrest.generator.qdox.JavaClassContext;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaClassParent;
import org.hamcrest.generator.qdox.model.TypeVariable;
import org.hamcrest.generator.qdox.model.WildcardType;
import org.hamcrest.generator.qdox.parser.structs.TypeDef;
import org.hamcrest.generator.qdox.parser.structs.WildcardTypeDef;

public class Type
implements Comparable,
Serializable {
    public static final Type[] EMPTY_ARRAY = new Type[0];
    public static final Type VOID = new Type("void");
    private String name;
    private JavaClassParent context;
    private String fullName;
    private int dimensions;
    private Type[] actualArgumentTypes;

    public Type(String fullName, String name, int dimensions, JavaClassParent context) {
        this.fullName = fullName;
        this.name = name;
        this.dimensions = dimensions;
        this.context = context;
    }

    public Type(String fullName, TypeDef typeDef, int dimensions, JavaClassParent context) {
        this.fullName = fullName;
        this.name = typeDef.name;
        this.dimensions = typeDef.dimensions + dimensions;
        if (typeDef.actualArgumentTypes != null && !typeDef.actualArgumentTypes.isEmpty()) {
            this.actualArgumentTypes = new Type[typeDef.actualArgumentTypes.size()];
            for (int index2 = 0; index2 < typeDef.actualArgumentTypes.size(); ++index2) {
                this.actualArgumentTypes[index2] = Type.createUnresolved((TypeDef)typeDef.actualArgumentTypes.get(index2), context);
            }
        }
        this.context = context;
    }

    public Type(String fullName, int dimensions, JavaClassParent context) {
        this(fullName, (String)null, dimensions, context);
    }

    public Type(String fullName, int dimensions) {
        this(fullName, dimensions, null);
    }

    public Type(String fullName) {
        this(fullName, 0);
    }

    public static Type createUnresolved(String name, int dimensions, JavaClassParent context) {
        return new Type(null, name, dimensions, context);
    }

    public static Type createUnresolved(TypeDef typeDef, int dimensions, JavaClassParent context) {
        return new Type(null, typeDef, dimensions, context);
    }

    public static Type createUnresolved(TypeDef typeDef, JavaClassParent context) {
        if (typeDef instanceof WildcardTypeDef) {
            return new WildcardType((WildcardTypeDef)typeDef, context);
        }
        return new Type(null, typeDef, 0, context);
    }

    public JavaClassParent getJavaClassParent() {
        return this.context;
    }

    public String getFullQualifiedName() {
        return this.getFullyQualifiedName();
    }

    public String getFullyQualifiedName() {
        return this.isResolved() ? this.fullName : this.name;
    }

    public String getValue() {
        String fqn = this.getFullyQualifiedName();
        return fqn == null ? "" : fqn.replaceAll("\\$", ".");
    }

    public String getGenericValue() {
        StringBuffer result2 = new StringBuffer(this.getValue());
        if (this.actualArgumentTypes != null && this.actualArgumentTypes.length > 0) {
            result2.append("<");
            for (int index2 = 0; index2 < this.actualArgumentTypes.length; ++index2) {
                result2.append(this.actualArgumentTypes[index2].getGenericValue());
                if (index2 + 1 == this.actualArgumentTypes.length) continue;
                result2.append(",");
            }
            result2.append(">");
        }
        for (int i = 0; i < this.dimensions; ++i) {
            result2.append("[]");
        }
        return result2.toString();
    }

    protected String getGenericValue(TypeVariable[] typeVariableList) {
        StringBuffer result2 = new StringBuffer(this.getResolvedValue(typeVariableList));
        if (this.actualArgumentTypes != null && this.actualArgumentTypes.length > 0) {
            for (int index2 = 0; index2 < this.actualArgumentTypes.length; ++index2) {
                result2.append(this.actualArgumentTypes[index2].getResolvedGenericValue(typeVariableList));
                if (index2 + 1 == this.actualArgumentTypes.length) continue;
                result2.append(",");
            }
        }
        return result2.toString();
    }

    protected String getResolvedValue(TypeVariable[] typeParameters) {
        String result2 = this.getValue();
        for (int typeIndex = 0; typeIndex < typeParameters.length; ++typeIndex) {
            if (!typeParameters[typeIndex].getName().equals(this.getValue())) continue;
            result2 = typeParameters[typeIndex].getValue();
            break;
        }
        return result2;
    }

    protected String getResolvedGenericValue(TypeVariable[] typeParameters) {
        String result2 = this.getGenericValue(typeParameters);
        for (int typeIndex = 0; typeIndex < typeParameters.length; ++typeIndex) {
            if (!typeParameters[typeIndex].getName().equals(this.getValue())) continue;
            result2 = typeParameters[typeIndex].getGenericValue();
            break;
        }
        return result2;
    }

    public boolean isResolved() {
        if (this.fullName == null && this.context != null) {
            this.fullName = this.context.resolveType(this.name);
        }
        return this.fullName != null;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Type)) {
            return 0;
        }
        return this.getValue().compareTo(((Type)o).getValue());
    }

    public boolean isArray() {
        return this.dimensions > 0;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Type[] getActualTypeArguments() {
        return this.actualArgumentTypes;
    }

    public String toString() {
        if (this.dimensions == 0) {
            return this.getValue();
        }
        StringBuffer buff = new StringBuffer(this.getValue());
        for (int i = 0; i < this.dimensions; ++i) {
            buff.append("[]");
        }
        String result2 = buff.toString();
        return result2;
    }

    public String toGenericString() {
        if (this.dimensions == 0) {
            return this.getGenericValue();
        }
        StringBuffer buff = new StringBuffer(this.getGenericValue());
        for (int i = 0; i < this.dimensions; ++i) {
            buff.append("[]");
        }
        String result2 = buff.toString();
        return result2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Type t = (Type)obj;
        return this.getValue().equals(t.getValue()) && t.getDimensions() == this.getDimensions();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public JavaClass getJavaClass() {
        JavaClassContext context;
        JavaClass result2 = null;
        JavaClassParent javaClassParent = this.getJavaClassParent();
        if (javaClassParent != null && (result2 = javaClassParent.getNestedClassByName(this.getFullyQualifiedName())) == null && (context = javaClassParent.getJavaClassContext()).getClassLibrary() != null) {
            result2 = context.getClassByName(this.getFullyQualifiedName());
        }
        return result2;
    }

    public boolean isA(Type type) {
        if (this.equals(type)) {
            return true;
        }
        JavaClass javaClass = this.getJavaClass();
        if (javaClass != null) {
            Type[] implementz = javaClass.getImplements();
            for (int i = 0; i < implementz.length; ++i) {
                if (!implementz[i].isA(type)) continue;
                return true;
            }
            Type supertype = javaClass.getSuperClass();
            if (supertype != null && supertype.isA(type)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPrimitive() {
        String value2 = this.getValue();
        if (value2 == null || value2.length() == 0 || value2.indexOf(46) > -1) {
            return false;
        }
        return "void".equals(value2) || "boolean".equals(value2) || "byte".equals(value2) || "char".equals(value2) || "short".equals(value2) || "int".equals(value2) || "long".equals(value2) || "float".equals(value2) || "double".equals(value2);
    }

    public boolean isVoid() {
        return "void".equals(this.getValue());
    }

    protected int getTypeVariableIndex(JavaClass superClass) {
        TypeVariable[] typeVariables = superClass.getTypeParameters();
        for (int typeIndex = 0; typeIndex < typeVariables.length; ++typeIndex) {
            if (!typeVariables[typeIndex].getFullyQualifiedName().equals(this.getFullyQualifiedName())) continue;
            return typeIndex;
        }
        return -1;
    }

    protected Type resolve(JavaClass parentClass) {
        return this.resolve(parentClass, parentClass);
    }

    protected Type resolve(JavaClass parentClass, JavaClass subclass) {
        Type result2 = this;
        int typeIndex = this.getTypeVariableIndex(parentClass);
        if (typeIndex >= 0) {
            String fqn = parentClass.getFullyQualifiedName();
            if (subclass.getSuperClass() != null && fqn.equals(subclass.getSuperClass().getFullyQualifiedName())) {
                result2 = subclass.getSuperClass().getActualTypeArguments()[typeIndex];
            } else if (subclass.getImplementedInterfaces() != null) {
                for (int i = 0; i < subclass.getImplementedInterfaces().length; ++i) {
                    if (!fqn.equals(subclass.getImplements()[i].getFullyQualifiedName())) continue;
                    result2 = subclass.getImplements()[i].getActualTypeArguments()[typeIndex].resolve(subclass.getImplementedInterfaces()[i]);
                    break;
                }
            }
        }
        if (this.actualArgumentTypes != null) {
            result2 = new Type(this.fullName, this.name, this.dimensions, this.context);
            result2.actualArgumentTypes = new Type[this.actualArgumentTypes.length];
            for (int i = 0; i < this.getActualTypeArguments().length; ++i) {
                result2.actualArgumentTypes[i] = this.actualArgumentTypes[i].resolve(parentClass, subclass);
            }
        }
        return result2;
    }
}

