/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.generator.qdox.JavaClassContext;
import org.hamcrest.generator.qdox.model.AbstractBaseJavaEntity;
import org.hamcrest.generator.qdox.model.Annotation;
import org.hamcrest.generator.qdox.model.JavaClass;

public class JavaPackage
extends AbstractBaseJavaEntity {
    private JavaClassContext context;
    private String name;
    private Annotation[] annotations = new Annotation[0];
    private int lineNumber = -1;
    private List classes = new ArrayList();

    public JavaPackage() {
    }

    public JavaPackage(String name) {
        this(name, null);
    }

    public JavaPackage(String name, Map allPackages) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Annotation[] annotations) {
        this.annotations = annotations;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setContext(JavaClassContext context) {
        this.context = context;
    }

    public void addClass(JavaClass clazz) {
        clazz.setJavaPackage(this);
        this.classes.add(clazz);
    }

    public JavaClass[] getClasses() {
        if (this == this.context.getPackageByName(this.name)) {
            return this.classes.toArray(new JavaClass[this.classes.size()]);
        }
        return this.context.getPackageByName(this.name).getClasses();
    }

    public JavaPackage getParentPackage() {
        String parentName = this.name.substring(0, this.name.lastIndexOf("."));
        return this.context.getPackageByName(parentName);
    }

    public JavaPackage[] getSubPackages() {
        String expected = this.name + ".";
        JavaPackage[] jPackages = this.context.getPackages();
        ArrayList<JavaPackage> retList = new ArrayList<JavaPackage>();
        for (int index2 = 0; index2 < jPackages.length; ++index2) {
            String pName = jPackages[index2].getName();
            if (!pName.startsWith(expected) || pName.substring(expected.length()).indexOf(".") > -1) continue;
            retList.add(this.context.getPackageByName(pName));
        }
        return retList.toArray(new JavaPackage[retList.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaPackage that = (JavaPackage)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package " + this.name;
    }
}

