/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.generator.qdox.model.AbstractInheritableJavaEntity;
import org.hamcrest.generator.qdox.model.DocletTag;
import org.hamcrest.generator.qdox.model.IndentBuffer;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaParameter;
import org.hamcrest.generator.qdox.model.Member;
import org.hamcrest.generator.qdox.model.Type;
import org.hamcrest.generator.qdox.model.TypeVariable;

public class JavaMethod
extends AbstractInheritableJavaEntity
implements Member {
    private TypeVariable[] typeParameters = TypeVariable.EMPTY_ARRAY;
    private Type returns = Type.VOID;
    private List parameters = new LinkedList();
    private JavaParameter[] parametersArray = JavaParameter.EMPTY_ARRAY;
    private Type[] exceptions = Type.EMPTY_ARRAY;
    private boolean constructor;
    private String sourceCode;
    private boolean varArgs;

    public JavaMethod() {
    }

    public JavaMethod(String name) {
        this.setName(name);
    }

    public JavaMethod(Type returns, String name) {
        this.setReturns(returns);
        this.setName(name);
    }

    public Type getReturns() {
        return this.returns;
    }

    public JavaParameter[] getParameters() {
        if (this.parametersArray == null) {
            this.parametersArray = new JavaParameter[this.parameters.size()];
            this.parameters.toArray(this.parametersArray);
        }
        return this.parametersArray;
    }

    public JavaParameter getParameterByName(String name) {
        JavaParameter[] parameters = this.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(name)) continue;
            return parameters[i];
        }
        return null;
    }

    public Type[] getExceptions() {
        return this.exceptions;
    }

    public boolean isConstructor() {
        return this.constructor;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    protected void writeBody(IndentBuffer result2) {
        this.writeBody(result2, true, true, true);
    }

    protected void writeBody(IndentBuffer result2, boolean withModifiers, boolean isDeclaration, boolean isPrettyPrint) {
        int i;
        if (withModifiers) {
            this.writeAccessibilityModifier(result2);
            this.writeNonAccessibilityModifiers(result2);
        }
        if (!this.constructor && isDeclaration) {
            result2.write(this.returns.toString());
            result2.write(' ');
        }
        result2.write(this.name);
        result2.write('(');
        for (i = 0; i < this.getParameters().length; ++i) {
            JavaParameter parameter = this.parametersArray[i];
            if (i > 0) {
                result2.write(", ");
            }
            if (isDeclaration) {
                result2.write(parameter.getType().toString());
                if (parameter.isVarArgs()) {
                    result2.write("...");
                }
                result2.write(' ');
            }
            result2.write(parameter.getName());
        }
        result2.write(')');
        if (isDeclaration && this.exceptions.length > 0) {
            result2.write(" throws ");
            for (i = 0; i < this.exceptions.length; ++i) {
                if (i > 0) {
                    result2.write(", ");
                }
                result2.write(this.exceptions[i].getValue());
            }
        }
        if (isPrettyPrint) {
            if (this.sourceCode != null && this.sourceCode.length() > 0) {
                result2.write(" {");
                result2.newline();
                result2.write(this.sourceCode);
                result2.write("}");
                result2.newline();
            } else {
                result2.write(';');
                result2.newline();
            }
        }
    }

    private String getSignature(boolean withModifiers, boolean isDeclaration) {
        IndentBuffer result2 = new IndentBuffer();
        this.writeBody(result2, withModifiers, isDeclaration, false);
        return result2.toString();
    }

    public String getDeclarationSignature(boolean withModifiers) {
        return this.getSignature(withModifiers, true);
    }

    public String getCallSignature() {
        return this.getSignature(false, false);
    }

    public void setReturns(Type returns) {
        this.returns = returns;
    }

    public void addParameter(JavaParameter javaParameter) {
        javaParameter.setParentMethod(this);
        this.parameters.add(javaParameter);
        this.parametersArray = null;
        this.varArgs = javaParameter.isVarArgs();
    }

    public void setExceptions(Type[] exceptions) {
        this.exceptions = exceptions;
    }

    public void setConstructor(boolean constructor) {
        this.constructor = constructor;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        JavaMethod m = (JavaMethod)obj;
        if (m.isConstructor() != this.isConstructor()) {
            return false;
        }
        if (m.getName() == null) {
            return this.getName() == null;
        }
        if (!m.getName().equals(this.getName())) {
            return false;
        }
        if (m.getReturns() == null) {
            return this.getReturns() == null;
        }
        if (!m.getReturns().equals(this.getReturns())) {
            return false;
        }
        JavaParameter[] myParams = this.getParameters();
        JavaParameter[] otherParams = m.getParameters();
        if (otherParams.length != myParams.length) {
            return false;
        }
        for (int i = 0; i < myParams.length; ++i) {
            if (otherParams[i].equals(myParams[i])) continue;
            return false;
        }
        return this.varArgs == m.varArgs;
    }

    public boolean signatureMatches(String name, Type[] parameterTypes) {
        return this.signatureMatches(name, parameterTypes, false);
    }

    public boolean signatureMatches(String name, Type[] parameterTypes, boolean varArg) {
        if (!name.equals(this.name)) {
            return false;
        }
        Type[] typeArray = parameterTypes = parameterTypes == null ? new Type[]{} : parameterTypes;
        if (parameterTypes.length != this.getParameters().length) {
            return false;
        }
        for (int i = 0; i < this.parametersArray.length; ++i) {
            if (this.parametersArray[i].getType().equals(parameterTypes[i])) continue;
            return false;
        }
        return this.varArgs == varArg;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        if (this.returns != null) {
            hashCode *= this.returns.hashCode();
        }
        return hashCode *= this.getParameters().length;
    }

    public boolean isPublic() {
        return super.isPublic() || this.getParentClass() != null && this.getParentClass().isInterface();
    }

    public boolean isPropertyAccessor() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().length != 0) {
            return false;
        }
        if (this.getName().startsWith("is")) {
            return this.getName().length() > 2 && Character.isUpperCase(this.getName().charAt(2));
        }
        if (this.getName().startsWith("get")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    public boolean isPropertyMutator() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().length != 1) {
            return false;
        }
        if (this.getName().startsWith("set")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    public Type getPropertyType() {
        if (this.isPropertyAccessor()) {
            return this.getReturns();
        }
        if (this.isPropertyMutator()) {
            return this.getParameters()[0].getType();
        }
        return null;
    }

    public String getPropertyName() {
        int start = -1;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            start = 3;
        } else if (this.getName().startsWith("is")) {
            start = 2;
        } else {
            return null;
        }
        return Introspector.decapitalize(this.getName().substring(start));
    }

    public DocletTag[] getTagsByName(String name, boolean inherited) {
        JavaClass clazz = this.getParentClass();
        JavaParameter[] params = this.getParameters();
        Type[] types = new Type[params.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = params[i].getType();
        }
        JavaMethod[] methods = clazz.getMethodsBySignature(this.getName(), types, true);
        ArrayList<DocletTag> result2 = new ArrayList<DocletTag>();
        for (int i = 0; i < methods.length; ++i) {
            JavaMethod method = methods[i];
            DocletTag[] tags = method.getTagsByName(name);
            for (int j = 0; j < tags.length; ++j) {
                DocletTag tag = tags[j];
                if (result2.contains(tag)) continue;
                result2.add(tag);
            }
        }
        return result2.toArray(new DocletTag[result2.size()]);
    }

    public int compareTo(Object o) {
        return this.getDeclarationSignature(false).compareTo(((JavaMethod)o).getDeclarationSignature(false));
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public void setTypeParameters(TypeVariable[] typeParameters) {
        this.typeParameters = typeParameters;
    }

    public TypeVariable[] getTypeParameters() {
        return this.typeParameters;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        if (this.isPrivate()) {
            result2.append("private ");
        } else if (this.isProtected()) {
            result2.append("protected ");
        } else if (this.isPublic()) {
            result2.append("public ");
        }
        if (this.isAbstract()) {
            result2.append("abstract ");
        }
        if (this.isStatic()) {
            result2.append("static ");
        }
        if (this.isFinal()) {
            result2.append("final ");
        }
        if (this.isSynchronized()) {
            result2.append("synchronized ");
        }
        if (this.isNative()) {
            result2.append("native ");
        }
        result2.append(this.getReturns().getValue() + " ");
        if (this.getParentClass() != null) {
            result2.append(this.getParentClass().getFullyQualifiedName() + ".");
        }
        result2.append(this.getName());
        result2.append("(");
        for (int paramIndex = 0; paramIndex < this.getParameters().length; ++paramIndex) {
            if (paramIndex > 0) {
                result2.append(",");
            }
            String typeValue = this.getParameters()[paramIndex].getType().getResolvedValue(this.getTypeParameters());
            result2.append(typeValue);
        }
        result2.append(")");
        for (int i = 0; i < this.exceptions.length; ++i) {
            result2.append(i == 0 ? " throws " : ",");
            result2.append(this.exceptions[i].getValue());
        }
        return result2.toString();
    }

    public Type getGenericReturnType() {
        return this.returns;
    }

    public Type getReturnType() {
        return this.getReturnType(false);
    }

    public Type getReturnType(boolean resolve) {
        return this.getReturnType(resolve, this.getParentClass());
    }

    protected Type getReturnType(boolean resolve, JavaClass callingClass) {
        Type result2 = this.getReturns().resolve(this.getParentClass(), callingClass);
        if (!resolve && !this.returns.getFullyQualifiedName().equals(result2.getFullyQualifiedName())) {
            result2 = new Type("java.lang.Object");
        }
        return result2;
    }

    public Type[] getParameterTypes() {
        return this.getParameterTypes(false);
    }

    public Type[] getParameterTypes(boolean resolve) {
        return this.getParameterTypes(resolve, this.getParentClass());
    }

    protected Type[] getParameterTypes(boolean resolve, JavaClass callingClass) {
        Type[] result2 = new Type[this.getParameters().length];
        for (int paramIndex = 0; paramIndex < this.getParameters().length; ++paramIndex) {
            Type curType = this.getParameters()[paramIndex].getType().resolve(this.getParentClass(), callingClass);
            result2[paramIndex] = !resolve && !this.returns.getFullyQualifiedName().equals(curType.getFullyQualifiedName()) ? new Type("java.lang.Object") : curType;
        }
        return result2;
    }
}

