/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import org.hamcrest.generator.qdox.model.AbstractJavaEntity;
import org.hamcrest.generator.qdox.model.IndentBuffer;
import org.hamcrest.generator.qdox.model.Member;
import org.hamcrest.generator.qdox.model.Type;

public class JavaField
extends AbstractJavaEntity
implements Member {
    private Type type;
    private String initializationExpression;

    public JavaField() {
    }

    public JavaField(String name) {
        this.setName(name);
    }

    public JavaField(Type type, String name) {
        this.setType(type);
        this.setName(name);
    }

    public Type getType() {
        return this.type;
    }

    protected void writeBody(IndentBuffer result2) {
        this.writeAllModifiers(result2);
        result2.write(this.type.toString());
        result2.write(' ');
        result2.write(this.name);
        if (this.initializationExpression != null && this.initializationExpression.length() > 0) {
            result2.write(" = ");
            result2.write(this.initializationExpression);
        }
        result2.write(';');
        result2.newline();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((JavaField)o).getName());
    }

    public String getDeclarationSignature(boolean withModifiers) {
        IndentBuffer result2 = new IndentBuffer();
        if (withModifiers) {
            this.writeAllModifiers(result2);
        }
        result2.write(this.type.toString());
        result2.write(' ');
        result2.write(this.name);
        return result2.toString();
    }

    public String getCallSignature() {
        return this.getName();
    }

    public String getInitializationExpression() {
        return this.initializationExpression;
    }

    public void setInitializationExpression(String initializationExpression) {
        this.initializationExpression = initializationExpression;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        if (this.isPrivate()) {
            result2.append("private ");
        } else if (this.isProtected()) {
            result2.append("protected ");
        } else if (this.isPublic()) {
            result2.append("public ");
        }
        if (this.isStatic()) {
            result2.append("static ");
        }
        if (this.isFinal()) {
            result2.append("final ");
        }
        if (this.isTransient()) {
            result2.append("transient ");
        }
        if (this.isVolatile()) {
            result2.append("volatile ");
        }
        result2.append(this.getType().getValue() + " ");
        result2.append(this.getParentClass().getFullyQualifiedName() + "." + this.getName());
        return result2.toString();
    }
}

