/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hamcrest.generator.qdox.model.AbstractBaseJavaEntity;
import org.hamcrest.generator.qdox.model.Type;
import org.hamcrest.generator.qdox.model.annotation.AnnotationValue;
import org.hamcrest.generator.qdox.model.annotation.AnnotationVisitor;

public class Annotation
implements AnnotationValue,
Serializable {
    private final Type type;
    private final int lineNumber;
    private final Map properties = new LinkedHashMap();
    private final Map namedParameters = new LinkedHashMap();
    private AbstractBaseJavaEntity context;

    public Annotation(Type type, AbstractBaseJavaEntity context, Map namedParameters, int lineNumber) {
        this.type = type;
        this.context = context;
        this.lineNumber = lineNumber;
        if (this.properties != null) {
            Iterator i = this.properties.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry2 = i.next();
                String name = (String)entry2.getKey();
                AnnotationValue value2 = (AnnotationValue)entry2.getValue();
                this.setProperty(name, value2);
            }
        }
    }

    public Annotation(Type type, int line) {
        this(type, null, null, line);
    }

    public void setProperty(String name, AnnotationValue value2) {
        this.properties.put(name, value2);
        this.namedParameters.put(name, value2.getParameterValue());
    }

    public Type getType() {
        return this.type;
    }

    public Object getNamedParameter(String key) {
        return this.namedParameters.get(key);
    }

    public Map getNamedParameterMap() {
        return this.namedParameters;
    }

    public final AbstractBaseJavaEntity getContext() {
        return this.context;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public Object accept(AnnotationVisitor visitor) {
        return visitor.visitAnnotation(this);
    }

    public Object getParameterValue() {
        return this;
    }

    public Map getPropertyMap() {
        return this.properties;
    }

    public AnnotationValue getProperty(String name) {
        return (AnnotationValue)this.properties.get(name);
    }

    public void setContext(AbstractBaseJavaEntity context) {
        this.context = context;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer();
        result2.append('@');
        result2.append(this.type.getValue());
        result2.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator i = this.namedParameters.entrySet().iterator();
            while (i.hasNext()) {
                result2.append(i.next() + ",");
            }
            result2.deleteCharAt(result2.length() - 1);
        }
        result2.append(')');
        return result2.toString();
    }
}

