/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.generator.qdox.DefaultJavaClassCache;
import org.hamcrest.generator.qdox.JavaDocBuilder;
import org.hamcrest.generator.qdox.model.ClassLibrary;
import org.hamcrest.generator.qdox.model.JavaClass;
import org.hamcrest.generator.qdox.model.JavaClassCache;
import org.hamcrest.generator.qdox.model.JavaPackage;

public class JavaClassContext
implements Serializable {
    private final JavaClassCache cache;
    private ClassLibrary classLibrary;
    private JavaDocBuilder builder;
    private Map packageMap = new HashMap();

    public JavaClassContext(JavaDocBuilder builder) {
        this.builder = builder;
        this.cache = new DefaultJavaClassCache();
    }

    public JavaClassContext(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
        this.cache = new DefaultJavaClassCache();
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public ClassLibrary getClassLibrary() {
        return this.classLibrary;
    }

    public JavaClass getClassByName(String name) {
        JavaClass result2 = this.cache.getClassByName(name);
        if (result2 == null && this.builder != null) {
            result2 = this.builder.createBinaryClass(name);
            if (result2 == null) {
                result2 = this.builder.createSourceClass(name);
            }
            if (result2 == null) {
                result2 = this.builder.createUnknownClass(name);
            }
            if (result2 != null) {
                this.add(result2);
                result2.setJavaClassContext(this);
            }
        }
        return result2;
    }

    public JavaClass[] getClasses() {
        return this.cache.getClasses();
    }

    public void add(JavaClass javaClass) {
        this.cache.putClassByName(javaClass.getFullyQualifiedName(), javaClass);
        JavaPackage jPackage = this.getPackageByName(javaClass.getPackageName());
        if (jPackage != null) {
            jPackage.addClass(javaClass);
        }
    }

    public void add(String fullyQualifiedClassName) {
        this.classLibrary.add(fullyQualifiedClassName);
    }

    public Class getClass(String name) {
        return this.classLibrary.getClass(name);
    }

    public JavaPackage getPackageByName(String name) {
        return (JavaPackage)this.packageMap.get(name);
    }

    public void add(JavaPackage jPackage) {
        String packageName = jPackage.getName();
        JavaPackage javaPackage = this.getPackageByName(packageName);
        if (javaPackage == null) {
            javaPackage = new JavaPackage(packageName);
            javaPackage.setContext(this);
            this.packageMap.put(packageName, javaPackage);
        }
        jPackage.setContext(this);
    }

    public JavaPackage[] getPackages() {
        return this.packageMap.values().toArray(new JavaPackage[0]);
    }
}

