/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import org.hamcrest.generator.FactoryMethod;
import org.hamcrest.generator.FactoryWriter;

public class HamcrestFactoryWriter
implements FactoryWriter {
    private final PrintWriter output;
    private final String javaPackageName;
    private final String javaClassName;
    private String indentationString = "  ";
    private String newLine = "\n";
    private int indentation = 1;

    public HamcrestFactoryWriter(String javaPackageName, String javaClassName, Writer output) {
        this.javaPackageName = javaPackageName;
        this.javaClassName = javaClassName;
        this.output = new PrintWriter(output);
    }

    public void writeHeader() throws IOException {
        this.output.append("// Generated source.").append(this.newLine).append("package ").append(this.javaPackageName).append(';').append(this.newLine).append(this.newLine);
        this.output.append("public class ").append(this.javaClassName).append(" {").append(this.newLine).append(this.newLine);
    }

    public void writeFooter() throws IOException {
        this.output.append('}').append(this.newLine);
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void flush() throws IOException {
        this.output.flush();
    }

    public void writeMethod(String generatedMethodName, FactoryMethod factoryMethodToDelegateTo) throws IOException {
        this.writeJavaDoc(factoryMethodToDelegateTo);
        this.indent();
        this.output.append("public static ");
        this.writeGenericTypeParameters(factoryMethodToDelegateTo);
        this.output.append(factoryMethodToDelegateTo.getReturnType());
        if (factoryMethodToDelegateTo.getGenerifiedType() != null) {
            this.output.append('<').append(factoryMethodToDelegateTo.getGenerifiedType()).append('>');
        }
        this.output.append(' ').append(generatedMethodName);
        this.writeParameters(factoryMethodToDelegateTo);
        this.writeExceptions(factoryMethodToDelegateTo);
        this.output.append(" {").append(this.newLine);
        ++this.indentation;
        this.writeMethodBody(factoryMethodToDelegateTo);
        --this.indentation;
        this.indent();
        this.output.append('}').append(this.newLine).append(this.newLine);
    }

    private void writeGenericTypeParameters(FactoryMethod factoryMethod) {
        if (!factoryMethod.getGenericTypeParameters().isEmpty()) {
            this.output.append('<');
            boolean seenFirst = false;
            for (String type : factoryMethod.getGenericTypeParameters()) {
                if (seenFirst) {
                    this.output.append(", ");
                } else {
                    seenFirst = true;
                }
                this.output.append(type);
            }
            this.output.append("> ");
        }
    }

    private void writeMethodBody(FactoryMethod factoryMethod) {
        boolean seenFirst;
        this.indent();
        this.output.append("return ").append(factoryMethod.getMatcherClass());
        this.output.append('.');
        if (!factoryMethod.getGenericTypeParameters().isEmpty()) {
            this.output.append('<');
            seenFirst = false;
            for (String type : factoryMethod.getGenericTypeParameters()) {
                if (seenFirst) {
                    this.output.append(",");
                } else {
                    seenFirst = true;
                }
                StringTokenizer iter2 = new StringTokenizer(type);
                iter2.hasMoreElements();
                this.output.append(iter2.nextToken());
            }
            this.output.append(">");
        }
        this.output.append(factoryMethod.getName());
        this.output.append('(');
        seenFirst = false;
        for (FactoryMethod.Parameter parameter : factoryMethod.getParameters()) {
            if (seenFirst) {
                this.output.append(", ");
            } else {
                seenFirst = true;
            }
            this.output.append(parameter.getName());
        }
        this.output.append(')');
        this.output.append(';').append(this.newLine);
    }

    private void writeExceptions(FactoryMethod factoryMethod) {
        boolean seenFirst = false;
        for (String exception : factoryMethod.getExceptions()) {
            if (seenFirst) {
                this.output.append(", ");
            } else {
                this.output.append(" throws ");
                seenFirst = true;
            }
            this.output.append(exception);
        }
    }

    private void writeParameters(FactoryMethod factoryMethod) {
        this.output.append('(');
        boolean seenFirst = false;
        for (FactoryMethod.Parameter parameter : factoryMethod.getParameters()) {
            if (seenFirst) {
                this.output.append(", ");
            } else {
                seenFirst = true;
            }
            this.output.append(parameter.getType()).append(' ').append(parameter.getName());
        }
        this.output.append(')');
    }

    private void writeJavaDoc(FactoryMethod factoryMethod) {
        String[] lines2;
        if (factoryMethod.getJavaDoc() != null && (lines2 = factoryMethod.getJavaDoc().split("\n")).length > 0) {
            this.indent();
            this.output.append("/**").append(this.newLine);
            for (String line : lines2) {
                this.indent();
                this.output.append(" * ").append(line).append(this.newLine);
            }
            this.indent();
            this.output.append(" */").append(this.newLine);
        }
    }

    private void indent() {
        for (int i = 0; i < this.indentation; ++i) {
            this.output.append(this.indentationString);
        }
    }
}

