/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryMethod {
    private final String matcherClass;
    private final String factoryMethod;
    private final String returnType;
    private String generifiedType;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<String> exceptions = new ArrayList<String>();
    private List<String> genericTypeParameters = new ArrayList<String>();
    private String javaDoc;

    public FactoryMethod(String matcherClass, String factoryMethod, String returnType) {
        this.matcherClass = matcherClass;
        this.factoryMethod = factoryMethod;
        this.returnType = returnType;
    }

    public String getMatcherClass() {
        return this.matcherClass;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getName() {
        return this.factoryMethod;
    }

    public void setGenerifiedType(String generifiedType) {
        this.generifiedType = generifiedType;
    }

    public String getGenerifiedType() {
        return this.generifiedType;
    }

    public void addParameter(String type, String name) {
        this.parameters.add(new Parameter(type, name));
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addException(String exception) {
        this.exceptions.add(exception);
    }

    public List<String> getExceptions() {
        return Collections.unmodifiableList(this.exceptions);
    }

    public void addGenericTypeParameter(String genericTypeParameter) {
        this.genericTypeParameters.add(genericTypeParameter);
    }

    public List<String> getGenericTypeParameters() {
        return Collections.unmodifiableList(this.genericTypeParameters);
    }

    public void setJavaDoc(String javaDoc) {
        this.javaDoc = javaDoc;
    }

    public String getJavaDoc() {
        return this.javaDoc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FactoryMethod other = (FactoryMethod)obj;
        if (this.exceptions == null ? other.exceptions != null : !((Object)this.exceptions).equals(other.exceptions)) {
            return false;
        }
        if (this.factoryMethod == null ? other.factoryMethod != null : !this.factoryMethod.equals(other.factoryMethod)) {
            return false;
        }
        if (this.genericTypeParameters == null ? other.genericTypeParameters != null : !((Object)this.genericTypeParameters).equals(other.genericTypeParameters)) {
            return false;
        }
        if (this.generifiedType == null ? other.generifiedType != null : !this.generifiedType.equals(other.generifiedType)) {
            return false;
        }
        if (this.javaDoc == null ? other.javaDoc != null : !this.javaDoc.equals(other.javaDoc)) {
            return false;
        }
        if (this.matcherClass == null ? other.matcherClass != null : !this.matcherClass.equals(other.matcherClass)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !((Object)this.parameters).equals(other.parameters));
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.exceptions == null ? 0 : ((Object)this.exceptions).hashCode());
        result2 = 31 * result2 + (this.factoryMethod == null ? 0 : this.factoryMethod.hashCode());
        result2 = 31 * result2 + (this.genericTypeParameters == null ? 0 : ((Object)this.genericTypeParameters).hashCode());
        result2 = 31 * result2 + (this.generifiedType == null ? 0 : this.generifiedType.hashCode());
        result2 = 31 * result2 + (this.javaDoc == null ? 0 : this.javaDoc.hashCode());
        result2 = 31 * result2 + (this.matcherClass == null ? 0 : this.matcherClass.hashCode());
        result2 = 31 * result2 + (this.parameters == null ? 0 : ((Object)this.parameters).hashCode());
        return result2;
    }

    public String toString() {
        return "{FactoryMethod: \n  matcherClass = " + this.matcherClass + "\n" + "  factoryMethod = " + this.factoryMethod + "\n" + "  generifiedType = " + this.generifiedType + "\n" + "  parameters = " + this.parameters + "\n" + "  exceptions = " + this.exceptions + "\n" + "  genericTypeParameters = " + this.genericTypeParameters + "\n" + "  javaDoc = " + this.javaDoc + "\n" + "}";
    }

    public static class Parameter {
        private final String type;
        private String name;

        public Parameter(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.type + " " + this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.name == null ? 0 : this.name.hashCode());
            result2 = 31 * result2 + (this.type == null ? 0 : this.type.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Parameter other = (Parameter)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

