/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import org.hamcrest.Factory;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.core.DescribedAs;
import org.hamcrest.core.IsEqual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsArrayWithSize<E>
extends FeatureMatcher<E[], Integer> {
    public IsArrayWithSize(Matcher<? super Integer> sizeMatcher) {
        super(sizeMatcher, "an array with size", "array size");
    }

    @Override
    protected Integer featureValueOf(E[] actual) {
        return actual.length;
    }

    @Factory
    public static <E> Matcher<E[]> arrayWithSize(Matcher<? super Integer> sizeMatcher) {
        return new IsArrayWithSize<E>(sizeMatcher);
    }

    @Factory
    public static <E> Matcher<E[]> arrayWithSize(int size2) {
        return IsArrayWithSize.arrayWithSize(IsEqual.equalTo(size2));
    }

    @Factory
    public static <E> Matcher<E[]> emptyArray() {
        Matcher<E[]> isEmpty2 = IsArrayWithSize.arrayWithSize(0);
        return DescribedAs.describedAs("an empty array", isEmpty2, new Object[0]);
    }
}

