/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractMarshalRecord;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.NullPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.sessions.Session;

public class XMLDirectMapping
extends AbstractDirectMapping
implements XMLMapping,
DirectMapping<AbstractSession, AttributeAccessor, ContainerPolicy, Converter, ClassDescriptor, DatabaseField, XMLMarshaller, Session, XMLUnmarshaller, XMLRecord>,
XMLNillableMapping {
    AbstractNullPolicy nullPolicy = new NullPolicy();
    public boolean isCDATA;
    private boolean isWriteOnly;
    private boolean isCollapsingStringValues;
    private boolean isNormalizingStringValues;
    private boolean isNullValueMarshalled = false;

    public XMLDirectMapping() {
        this.nullPolicy.setNullRepresentedByEmptyNode(true);
        this.isCDATA = false;
    }

    @Override
    public void setNullPolicy(AbstractNullPolicy aNullPolicy) {
        this.nullPolicy = aNullPolicy;
    }

    @Override
    public AbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    @Override
    public boolean isXMLMapping() {
        return true;
    }

    @Override
    public void setXPath(String xpathString) {
        if (xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
            xpathString = String.valueOf(xpathString) + "/text()";
        }
        this.setField(new XMLField(xpathString));
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        ((XMLField)this.getField()).setIsCDATA(this.isCDATA());
        String xpathString = ((XMLField)this.getField()).getXPath();
        if (this.isAbstractDirectMapping() && xpathString.indexOf(XMLConstants.ATTRIBUTE.charValue()) == -1 && !xpathString.endsWith("text()")) {
            throw DescriptorException.invalidXpathForXMLDirectMapping(this);
        }
    }

    @Override
    public Object getAttributeValue(Object fieldValue, AbstractSession session, AbstractUnmarshalRecord record) {
        boolean isNullRepresentedByEmptyNode = this.nullPolicy.isNullRepresentedByEmptyNode();
        boolean isNullRepresentedByXsiNil = this.nullPolicy.isNullRepresentedByXsiNil();
        if (isNullRepresentedByEmptyNode && "".equals(fieldValue)) {
            fieldValue = null;
        } else if (fieldValue == null && !isNullRepresentedByEmptyNode) {
            fieldValue = "";
        }
        Object attributeValue = fieldValue;
        if (attributeValue == XMLRecord.noEntry) {
            if (!this.getNullPolicy().getIsSetPerformedForAbsentNode()) {
                return attributeValue;
            }
            fieldValue = null;
            attributeValue = null;
        }
        if (attributeValue == XMLRecord.NIL && isNullRepresentedByXsiNil) {
            fieldValue = null;
            attributeValue = null;
        }
        if (this.converter != null) {
            attributeValue = this.convertDataValueToObjectValue(attributeValue, session, (XMLUnmarshaller)record.getUnmarshaller());
        } else if (attributeValue == null || attributeValue.getClass() != this.attributeObjectClassification) {
            try {
                attributeValue = session.getDatasourcePlatform().convertObject(attributeValue, this.attributeClassification);
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
        }
        if (attributeValue == null) {
            attributeValue = this.nullValue;
        }
        return attributeValue;
    }

    @Override
    public Object getFieldValue(Object attributeValue, CoreAbstractSession session, AbstractMarshalRecord record) {
        Class fieldClassification;
        Object fieldValue = attributeValue;
        if (this.nullValue != null && this.nullValue.equals(fieldValue) && !this.isNullValueMarshalled && !((XMLField)this.field).isRequired()) {
            return null;
        }
        if ((fieldValue = this.convertObjectValueToDataValue(fieldValue, (AbstractSession)session, (XMLMarshaller)record.getMarshaller())) != null && (fieldClassification = this.getFieldClassification(this.field)) != fieldValue.getClass()) {
            try {
                fieldValue = session.getPlatform(this.descriptor.getJavaClass()).convertObject(fieldValue, fieldClassification);
            }
            catch (ConversionException exception) {
                throw ConversionException.couldNotBeConverted((Object)this, this.descriptor, exception);
            }
        }
        return fieldValue;
    }

    @Override
    public String getXPath() {
        return this.getFieldName();
    }

    @Override
    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) {
        boolean shouldCheckForXsiNil = this.getNullPolicy().isNullRepresentedByXsiNil();
        return this.getAttributeValue(((DOMRecord)row).getIndicatingNoEntry(this.field, false, shouldCheckForXsiNil), executionSession, (AbstractUnmarshalRecord)((XMLRecord)row));
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isReadOnly()) {
            return;
        }
        this.writeSingleValue(this.getAttributeValueFromObject(object), object, (XMLRecord)row, session);
    }

    @Override
    protected void writeValueIntoRow(AbstractRecord row, DatabaseField aField, Object fieldValue) {
        row.put((DatabaseField)this.getField(), fieldValue);
    }

    @Override
    public void writeSingleValue(Object value2, Object parent, XMLRecord row, AbstractSession session) {
        Object fieldValue = this.getFieldValue(value2, session, row);
        if (fieldValue == null && this.getNullPolicy() != null) {
            this.getNullPolicy().directMarshal((Field)this.getField(), row, parent);
        } else {
            this.writeValueIntoRow(row, (DatabaseField)this.getField(), fieldValue);
        }
    }

    @Override
    public void setAttributeValueInObject(Object object, Object value2) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        try {
            if (value2 == XMLRecord.noEntry) {
                return;
            }
            if (value2 != null && value2 instanceof String) {
                if (this.isCollapsingStringValues) {
                    value2 = XMLConversionManager.getDefaultXMLManager().collapseStringValue((String)value2);
                } else if (this.isNormalizingStringValues) {
                    value2 = XMLConversionManager.getDefaultXMLManager().normalizeStringValue((String)value2);
                }
            }
            this.attributeAccessor.setAttributeValueInObject(object, value2);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
    }

    @Override
    public void setIsCDATA(boolean CDATA2) {
        this.isCDATA = CDATA2;
    }

    @Override
    public boolean isCDATA() {
        return this.isCDATA;
    }

    @Override
    public boolean isWriteOnly() {
        return this.isWriteOnly;
    }

    @Override
    public void setIsWriteOnly(boolean b) {
        this.isWriteOnly = b;
    }

    @Override
    public boolean isCloningRequired() {
        return false;
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        ((AttributeAccessor)this.getAttributeAccessor()).setIsWriteOnly(this.isWriteOnly());
        ((AttributeAccessor)this.getAttributeAccessor()).setIsReadOnly(this.isReadOnly());
        super.preInitialize(session);
    }

    public boolean isNormalizingStringValues() {
        return this.isNormalizingStringValues;
    }

    @Override
    public void setNormalizingStringValues(boolean normalize) {
        this.isNormalizingStringValues = normalize;
    }

    @Override
    public void setCollapsingStringValues(boolean collapse) {
        this.isCollapsingStringValues = collapse;
    }

    public boolean isCollapsingStringValues() {
        return this.isCollapsingStringValues;
    }

    public boolean isNullValueMarshalled() {
        return this.isNullValueMarshalled;
    }

    @Override
    public void setNullValueMarshalled(boolean value2) {
        this.isNullValueMarshalled = value2;
    }

    @Override
    public Object convertObjectValueToDataValue(Object value2, Session session, XMLMarshaller marshaller) {
        if (this.hasConverter()) {
            if (this.converter instanceof XMLConverter) {
                return ((XMLConverter)this.converter).convertObjectValueToDataValue(value2, session, marshaller);
            }
            return this.converter.convertObjectValueToDataValue(value2, session);
        }
        return value2;
    }

    @Override
    public Object convertDataValueToObjectValue(Object fieldValue, Session session, XMLUnmarshaller unmarshaller) {
        if (this.hasConverter()) {
            if (this.converter instanceof XMLConverter) {
                return ((XMLConverter)this.converter).convertDataValueToObjectValue(fieldValue, session, unmarshaller);
            }
            return this.converter.convertDataValueToObjectValue(fieldValue, session);
        }
        return fieldValue;
    }
}

