/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ResultSetRecord;

public class SimpleResultSetRecord
extends ResultSetRecord {
    protected transient boolean shouldKeepValues;
    protected transient boolean shouldUseOptimization;
    protected transient boolean isPopulatingObject;

    protected SimpleResultSetRecord() {
    }

    public SimpleResultSetRecord(Vector fields, DatabaseField[] fieldsArray, ResultSet resultSet, ResultSetMetaData metaData, DatabaseAccessor accessor, AbstractSession session, DatabasePlatform platform, boolean optimizeData) {
        super(fields, fieldsArray, resultSet, metaData, accessor, session, platform, optimizeData);
    }

    @Override
    public void loadAllValuesFromResultSet() {
        int size2 = this.valuesArray.length;
        int index2 = 0;
        while (index2 < size2) {
            DatabaseField field2;
            if (this.valuesArray[index2] == null && (field2 = this.fieldsArray[index2]) != null) {
                this.valuesArray[index2] = this.getValueFromResultSet(index2, field2);
            }
            ++index2;
        }
        this.resultSet = null;
        this.metaData = null;
        this.accessor = null;
        this.platform = null;
        this.session = null;
    }

    @Override
    public Object get(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 < 0 || index2 >= this.size) {
                index2 = 0;
            }
            if ((field2 = this.fieldsArray[index2]) != key && !field2.equals(key)) {
                index2 = -1;
                int fieldIndex = 0;
                while (fieldIndex < this.size) {
                    field2 = this.fieldsArray[fieldIndex];
                    if (field2 == key || field2.equals(key)) {
                        if (key.index == -1) {
                            key.setIndex(fieldIndex);
                        }
                        index2 = fieldIndex;
                        break;
                    }
                    ++fieldIndex;
                }
                if (index2 < 0) {
                    return null;
                }
            }
            if (this.resultSet != null) {
                Object value2 = this.valuesArray[index2];
                if (value2 != null) {
                    if (!this.isPopulatingObject) {
                        this.isPopulatingObject = true;
                    }
                    if (!this.shouldKeepValues) {
                        this.valuesArray[index2] = null;
                    }
                } else {
                    if (this.shouldUseOptimization) {
                        try {
                            Class fieldType = field2.getType();
                            if (fieldType == ClassConstants.STRING) {
                                if (this.platform.shouldUseGetSetNString()) {
                                    value2 = this.resultSet.getNString(index2 + 1);
                                }
                                value2 = this.resultSet.getString(index2 + 1);
                            }
                            if (fieldType == ClassConstants.LONG) {
                                value2 = this.resultSet.getLong(index2 + 1);
                            }
                            if (fieldType == ClassConstants.INTEGER) {
                                value2 = this.resultSet.getInt(index2 + 1);
                            }
                            value2 = this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
                        }
                        catch (SQLException exception) {
                            DatabaseException commException = this.accessor.processExceptionForCommError(this.session, exception, null);
                            if (commException != null) {
                                throw commException;
                            }
                            throw DatabaseException.sqlException(exception, this.accessor, this.session, false);
                        }
                    } else {
                        value2 = this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
                    }
                    if (!this.isPopulatingObject || this.shouldKeepValues) {
                        this.valuesArray[index2] = value2;
                    }
                }
                return value2;
            }
            return this.valuesArray[index2];
        }
        return super.get(key);
    }

    @Override
    public Object getIndicatingNoEntry(DatabaseField key) {
        if (this.fieldsArray != null) {
            DatabaseField field2;
            int index2 = key.index;
            if (index2 < 0 || index2 >= this.size) {
                index2 = 0;
            }
            if ((field2 = this.fieldsArray[index2]) != key && !field2.equals(key)) {
                index2 = -1;
                int fieldIndex = 0;
                while (fieldIndex < this.size) {
                    field2 = this.fieldsArray[fieldIndex];
                    if (field2 == key || field2.equals(key)) {
                        if (key.index == -1) {
                            key.setIndex(fieldIndex);
                        }
                        index2 = fieldIndex;
                        break;
                    }
                    ++fieldIndex;
                }
                if (index2 < 0) {
                    return null;
                }
            }
            if (this.resultSet != null) {
                Object value2 = this.valuesArray[index2];
                if (value2 != null) {
                    if (!this.isPopulatingObject) {
                        this.isPopulatingObject = true;
                    }
                    if (!this.shouldKeepValues) {
                        this.valuesArray[index2] = null;
                    }
                } else {
                    if (this.shouldUseOptimization) {
                        try {
                            Class fieldType = field2.getType();
                            if (fieldType == ClassConstants.STRING) {
                                if (this.platform.shouldUseGetSetNString()) {
                                    value2 = this.resultSet.getNString(index2 + 1);
                                }
                                value2 = this.resultSet.getString(index2 + 1);
                            }
                            if (fieldType == ClassConstants.LONG) {
                                value2 = this.resultSet.getLong(index2 + 1);
                            }
                            if (fieldType == ClassConstants.INTEGER) {
                                value2 = this.resultSet.getInt(index2 + 1);
                            }
                            value2 = this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
                        }
                        catch (SQLException exception) {
                            DatabaseException commException = this.accessor.processExceptionForCommError(this.session, exception, null);
                            if (commException != null) {
                                throw commException;
                            }
                            throw DatabaseException.sqlException(exception, this.accessor, this.session, false);
                        }
                    } else {
                        value2 = this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
                    }
                    if (!this.isPopulatingObject || this.shouldKeepValues) {
                        this.valuesArray[index2] = value2;
                    }
                }
                return value2;
            }
            return this.valuesArray[index2];
        }
        return super.get(key);
    }

    protected Object getValueFromResultSet(int index2, DatabaseField field2) {
        if (this.shouldUseOptimization) {
            try {
                Class fieldType = field2.getType();
                if (fieldType == ClassConstants.STRING) {
                    if (this.platform.shouldUseGetSetNString()) {
                        return this.resultSet.getNString(index2 + 1);
                    }
                    return this.resultSet.getString(index2 + 1);
                }
                if (fieldType == ClassConstants.LONG) {
                    return this.resultSet.getLong(index2 + 1);
                }
                if (fieldType == ClassConstants.INTEGER) {
                    return this.resultSet.getInt(index2 + 1);
                }
            }
            catch (SQLException exception) {
                DatabaseException commException = this.accessor.processExceptionForCommError(this.session, exception, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(exception, this.accessor, this.session, false);
            }
        }
        return this.accessor.getObject(this.resultSet, field2, this.metaData, index2 + 1, this.platform, this.optimizeData, this.session);
    }

    public void reset() {
        block3: {
            block2: {
                if (!this.isPopulatingObject) break block2;
                this.isPopulatingObject = false;
                if (!this.shouldKeepValues) break block3;
                int size2 = this.valuesArray.length;
                int index2 = 0;
                while (index2 < size2) {
                    this.valuesArray[index2] = null;
                    ++index2;
                }
                break block3;
            }
            int size3 = this.valuesArray.length;
            int index3 = 0;
            while (index3 < size3) {
                this.valuesArray[index3] = null;
                ++index3;
            }
        }
    }

    public boolean shouldKeepValues() {
        return this.shouldKeepValues;
    }

    public void setShouldKeepValues(boolean shouldKeepValues) {
        this.shouldKeepValues = shouldKeepValues;
    }

    public boolean shouldUseOptimization() {
        return this.shouldUseOptimization;
    }

    public void setShouldUseOptimization(boolean shouldUseOptimization) {
        this.shouldUseOptimization = shouldUseOptimization;
    }

    public boolean hasValues() {
        return this.valuesArray[0] != null;
    }

    public boolean isPopulatingObject() {
        return this.isPopulatingObject;
    }

    @Override
    protected String toStringAditional() {
        return String.valueOf(this.shouldKeepValues ? " shouldKeepValues" : "") + (this.shouldUseOptimization ? " shouldUseOptimization" : "") + (this.isPopulatingObject ? " isPopulatingObject" : "");
    }

    @Override
    public void setSopObject(Object sopObject) {
        this.sopObject = sopObject;
        this.isPopulatingObject = true;
    }
}

