/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.SchemaPerMultitenantPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.sequencing.DatabaseSessionConnectionHandler;
import org.eclipse.persistence.internal.sequencing.PreallocationHandler;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sequencing.SequencingConnectionHandler;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sequencing.SequencingServer;
import org.eclipse.persistence.internal.sequencing.ServerSessionConnectionHandler;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

class SequencingManager
implements SequencingHome,
SequencingServer,
SequencingControl {
    private final DatabaseSessionImpl ownerSession;
    private SequencingConnectionHandler connectionHandler;
    private Map<String, PreallocationHandler> preallocationHandler;
    private int whenShouldAcquireValueForAll;
    private Vector connectedSequences;
    boolean atLeastOneSequenceShouldUseTransaction;
    boolean atLeastOneSequenceShouldUsePreallocation;
    private static final int NOPREALLOCATION = 0;
    private static final int PREALLOCATION_NOTRANSACTION = 1;
    private static final int PREALLOCATION_TRANSACTION_NOACCESSOR = 2;
    private static final int PREALLOCATION_TRANSACTION_ACCESSOR = 3;
    private static final int NUMBER_OF_STATES = 4;
    private State[] states;
    private Map<String, ConcurrencyManager> locks;
    private SequencingCallbackFactory callbackFactory;
    private SequencingServer server;
    private Sequencing seq;
    private boolean shouldUseSeparateConnection;
    private Login login;
    private int minPoolSize = -1;
    private int maxPoolSize = -1;
    private int initialPoolSize = -1;
    private ConnectionPool connectionPool;

    public SequencingManager(DatabaseSessionImpl ownerSession) {
        this.ownerSession = ownerSession;
    }

    protected DatabaseSessionImpl getOwnerSession() {
        return this.ownerSession;
    }

    protected void createConnectionHandler() {
        boolean isServerSession = this.getOwnerSession().isServerSession();
        if (this.getLogin() == null) {
            Login login = isServerSession ? ((ServerSession)this.getOwnerSession()).getReadConnectionPool().getLogin() : this.getOwnerSession().getDatasourceLogin();
            this.setLogin(login);
        }
        if (this.getLogin() != null && this.getLogin().shouldUseExternalTransactionController()) {
            throw ValidationException.invalidSequencingLogin();
        }
        if (isServerSession) {
            ConnectionPool pool = null;
            if (this.connectionPool == null) {
                if (this.getLogin().shouldUseExternalConnectionPooling()) {
                    pool = new ExternalConnectionPool("sequencing", this.getLogin(), (ServerSession)this.getOwnerSession());
                } else {
                    if (this.getMinPoolSize() == -1) {
                        this.setMinPoolSize(2);
                    }
                    if (this.getMaxPoolSize() == -1) {
                        this.setMinPoolSize(2);
                    }
                    if (this.getInitialPoolSize() == -1) {
                        this.setInitialPoolSize(1);
                    }
                    pool = new ConnectionPool("sequencing", this.getLogin(), this.getInitialPoolSize(), this.getMinPoolSize(), this.getMaxPoolSize(), (ServerSession)this.getOwnerSession());
                }
            } else {
                pool = this.connectionPool;
            }
            this.setConnectionHandler(new ServerSessionConnectionHandler(pool));
        } else {
            this.setConnectionHandler(new DatabaseSessionConnectionHandler(this.getOwnerSession(), this.getLogin()));
        }
    }

    @Override
    public SequencingControl getSequencingControl() {
        return this;
    }

    protected void setSequencing(Sequencing sequencing) {
        this.seq = sequencing;
    }

    @Override
    public Sequencing getSequencing() {
        return this.seq;
    }

    protected void setSequencingServer(SequencingServer server) {
        this.server = server;
    }

    @Override
    public SequencingServer getSequencingServer() {
        return this.server;
    }

    protected void setSequencingCallbackFactory(SequencingCallbackFactory callbackFactory) {
        this.callbackFactory = callbackFactory;
    }

    @Override
    public boolean isSequencingCallbackRequired() {
        return this.callbackFactory != null;
    }

    @Override
    public boolean shouldUseSeparateConnection() {
        return this.shouldUseSeparateConnection;
    }

    @Override
    public void setShouldUseSeparateConnection(boolean shouldUseSeparateConnection) {
        this.shouldUseSeparateConnection = shouldUseSeparateConnection;
    }

    @Override
    public boolean isConnectedUsingSeparateConnection() {
        return this.isConnected() && this.getConnectionHandler() != null;
    }

    @Override
    public Login getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(Login login) {
        this.login = login;
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public void setMinPoolSize(int size2) {
        this.minPoolSize = size2;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaxPoolSize(int size2) {
        this.maxPoolSize = size2;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @Override
    public void setInitialPoolSize(int size2) {
        this.initialPoolSize = size2;
    }

    @Override
    public boolean isConnected() {
        return this.states != null;
    }

    protected SequencingConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected void setConnectionHandler(SequencingConnectionHandler handler) {
        this.connectionHandler = handler;
    }

    @Override
    public ConnectionPool getConnectionPool() {
        if (this.getConnectionHandler() != null && this.getConnectionHandler() instanceof ServerSessionConnectionHandler) {
            return ((ServerSessionConnectionHandler)this.getConnectionHandler()).getPool();
        }
        return this.connectionPool;
    }

    @Override
    public Object getNextValue(Class cls) {
        return this.getNextValue(this.getOwnerSession(), cls);
    }

    @Override
    public void initializePreallocated() {
        if (this.preallocationHandler != null) {
            for (PreallocationHandler handler : this.preallocationHandler.values()) {
                handler.initializePreallocated();
            }
        }
    }

    @Override
    public void initializePreallocated(String seqName) {
        if (this.preallocationHandler != null) {
            for (PreallocationHandler handler : this.preallocationHandler.values()) {
                handler.initializePreallocated(seqName);
            }
        }
    }

    protected void setLocks(Map locks) {
        this.locks = locks;
    }

    protected Map<String, ConcurrencyManager> getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrencyManager acquireLock(String sequenceName) {
        ConcurrencyManager manager = this.getLocks().get(sequenceName);
        if (manager == null) {
            Map<String, ConcurrencyManager> map2 = this.getLocks();
            synchronized (map2) {
                manager = this.getLocks().get(sequenceName);
                if (manager == null) {
                    manager = new ConcurrencyManager();
                    this.getLocks().put(sequenceName, manager);
                }
            }
        }
        manager.acquire();
        return manager;
    }

    protected Sequence getSequence(Class cls) {
        String seqName = this.getOwnerSession().getDescriptor(cls).getSequenceNumberName();
        return this.getSequence(seqName);
    }

    protected void logDebugPreallocation(String seqName, Object firstSequenceValue, Vector sequences) {
        if (this.getOwnerSession().shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, sequences.size() + 1, firstSequenceValue, sequences.lastElement()};
            this.getOwnerSession().log(1, "sequencing", "sequencing_preallocation", args);
        }
    }

    protected void logDebugLocalPreallocation(AbstractSession writeSession, String seqName, Vector sequences, Accessor accessor) {
        if (writeSession.shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, sequences.size(), sequences.firstElement(), sequences.lastElement()};
            writeSession.log(1, "sequencing", "sequencing_localPreallocation", args, accessor);
        }
    }

    @Override
    public void resetSequencing() {
        if (this.isConnected()) {
            this.onDisconnect();
            this.onConnect();
        }
    }

    @Override
    public void onConnect() {
        if (this.isConnected()) {
            return;
        }
        if (!this.getOwnerSession().getProject().usesSequencing()) {
            return;
        }
        this.onConnectInternal(null);
    }

    @Override
    public void onAddDescriptors(Collection descriptors) {
        if (!this.isConnected()) {
            this.onConnect();
            return;
        }
        if (descriptors == null || descriptors.isEmpty()) {
            return;
        }
        this.onConnectInternal(descriptors);
    }

    protected void onConnectInternal(Collection descriptors) {
        boolean hasSequencingCallbackFactory;
        int nAlreadyConnectedSequences = 0;
        if (this.connectedSequences != null) {
            nAlreadyConnectedSequences = this.connectedSequences.size();
        }
        int whenShouldAcquireValueForAllOriginal = this.whenShouldAcquireValueForAll;
        boolean atLeastOneSequenceShouldUseTransactionOriginal = this.atLeastOneSequenceShouldUseTransaction;
        boolean atLeastOneSequenceShouldUsePreallocationOriginal = this.atLeastOneSequenceShouldUsePreallocation;
        this.onConnectSequences(descriptors);
        if (nAlreadyConnectedSequences == this.connectedSequences.size()) {
            return;
        }
        boolean onExceptionDisconnectPreallocationHandler = false;
        boolean onExceptionDisconnectConnectionHandler = false;
        boolean hasConnectionHandler = this.getConnectionHandler() != null;
        boolean hasPreallocationHandler = this.getPreallocationHandler(null) != null;
        try {
            if (!hasConnectionHandler) {
                if (!this.shouldUseSeparateConnection()) {
                    this.setConnectionHandler(null);
                } else if (this.atLeastOneSequenceShouldUseTransaction) {
                    if (this.getConnectionHandler() == null) {
                        this.createConnectionHandler();
                    }
                    if (this.getConnectionHandler() != null) {
                        this.getConnectionHandler().onConnect();
                        onExceptionDisconnectConnectionHandler = true;
                    }
                }
            }
            if (!hasPreallocationHandler && this.atLeastOneSequenceShouldUsePreallocation) {
                String context = this.getContext(null);
                if (this.getPreallocationHandler(context) == null) {
                    this.createPreallocationHandler(context);
                }
                this.getPreallocationHandler(context).onConnect();
                onExceptionDisconnectPreallocationHandler = true;
            }
            this.initializeStates(nAlreadyConnectedSequences);
        }
        catch (RuntimeException ex) {
            block26: {
                try {
                    try {
                        this.onDisconnectSequences(nAlreadyConnectedSequences);
                    }
                    catch (Exception exception) {
                        this.whenShouldAcquireValueForAll = whenShouldAcquireValueForAllOriginal;
                        this.atLeastOneSequenceShouldUseTransaction = atLeastOneSequenceShouldUseTransactionOriginal;
                        this.atLeastOneSequenceShouldUsePreallocation = atLeastOneSequenceShouldUsePreallocationOriginal;
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    this.whenShouldAcquireValueForAll = whenShouldAcquireValueForAllOriginal;
                    this.atLeastOneSequenceShouldUseTransaction = atLeastOneSequenceShouldUseTransactionOriginal;
                    this.atLeastOneSequenceShouldUsePreallocation = atLeastOneSequenceShouldUsePreallocationOriginal;
                    throw throwable;
                }
                this.whenShouldAcquireValueForAll = whenShouldAcquireValueForAllOriginal;
                this.atLeastOneSequenceShouldUseTransaction = atLeastOneSequenceShouldUseTransactionOriginal;
                this.atLeastOneSequenceShouldUsePreallocation = atLeastOneSequenceShouldUsePreallocationOriginal;
            }
            if (!hasConnectionHandler && this.getConnectionHandler() != null) {
                if (onExceptionDisconnectConnectionHandler) {
                    this.getConnectionHandler().onDisconnect();
                }
                this.setConnectionHandler(null);
            }
            if (!hasPreallocationHandler && this.getPreallocationHandler(null) != null) {
                if (onExceptionDisconnectPreallocationHandler) {
                    this.getPreallocationHandler(null).onDisconnect();
                }
                this.clearPreallocationHandler(null);
            }
            throw ex;
        }
        if (this.atLeastOneSequenceShouldUsePreallocation && this.getLocks() == null) {
            this.setLocks(new ConcurrentHashMap(20));
        }
        if (!(hasSequencingCallbackFactory = this.isSequencingCallbackRequired())) {
            this.createSequencingCallbackFactory();
            if (this.getOwnerSession().hasExternalTransactionController()) {
                this.getOwnerSession().getExternalTransactionController().initializeSequencingListeners();
            }
        }
        if (descriptors == null) {
            if (this.getOwnerSession().isServerSession()) {
                this.setSequencingServer(this);
            }
            this.setSequencing(this);
        }
        this.logDebugSequencingConnected(nAlreadyConnectedSequences);
    }

    @Override
    public void onDisconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.setSequencing(null);
        this.setSequencingServer(null);
        this.setSequencingCallbackFactory(null);
        if (this.getOwnerSession().hasExternalTransactionController() && !this.getOwnerSession().hasBroker()) {
            this.getOwnerSession().getExternalTransactionController().clearSequencingListeners();
        }
        this.setLocks(null);
        this.clearStates();
        if (this.getConnectionHandler() != null) {
            this.getConnectionHandler().onDisconnect();
            this.setConnectionHandler(null);
        }
        if (this.getPreallocationHandler(null) != null) {
            this.getPreallocationHandler(null).onDisconnect();
            this.clearPreallocationHandler();
        }
        this.onDisconnectSequences(0);
        this.getOwnerSession().log(1, "sequencing", "sequencing_disconnected");
    }

    protected PreallocationHandler getPreallocationHandler(String context) {
        if (this.preallocationHandler != null) {
            if (context == null) {
                return this.preallocationHandler.get("default");
            }
            PreallocationHandler handler = this.preallocationHandler.get(context);
            if (handler == null && !"default".equals(context)) {
                handler = new PreallocationHandler();
                this.preallocationHandler.put(context, handler);
                handler.onConnect();
            }
            return handler;
        }
        return null;
    }

    protected void createPreallocationHandler(String context) {
        if (this.preallocationHandler == null) {
            this.preallocationHandler = new ConcurrentHashMap<String, PreallocationHandler>(5);
        }
        this.preallocationHandler.put(context, new PreallocationHandler());
    }

    protected void clearPreallocationHandler() {
        this.preallocationHandler = null;
    }

    protected void clearPreallocationHandler(AbstractSession session) {
        this.preallocationHandler.remove(this.getContext(session));
    }

    /*
     * Unable to fully structure code
     */
    protected void onConnectSequences(Collection descriptors) {
        isConnected = this.isConnected();
        nAlreadyConnectedSequences = 0;
        if (this.connectedSequences == null) {
            this.connectedSequences = new Vector<E>();
        } else {
            nAlreadyConnectedSequences = this.connectedSequences.size();
        }
        shouldUseTransaction = false;
        shouldUsePreallocation = false;
        shouldAcquireValueAfterInsert = false;
        if (descriptors == null) {
            descriptors = this.getOwnerSession().getDescriptors().values();
        }
        itDescriptors = descriptors.iterator();
        while (itDescriptors.hasNext()) {
            parentDescriptor = descriptor = (ClassDescriptor)itDescriptors.next();
            while (!parentDescriptor.usesSequenceNumbers() && parentDescriptor.isChildDescriptor()) {
                newDescriptor = this.getOwnerSession().getDescriptor(parentDescriptor.getInheritancePolicy().getParentClass());
                if (newDescriptor == null || newDescriptor == parentDescriptor) break;
                parentDescriptor = newDescriptor;
            }
            if (!parentDescriptor.usesSequenceNumbers()) continue;
            seqName = parentDescriptor.getSequenceNumberName();
            sequence = this.getSequence(seqName);
            if (sequence == null) {
                sequence = new DefaultSequence(seqName);
                this.getOwnerSession().getDatasourcePlatform().addSequence(sequence, isConnected);
            }
            descriptor.setSequence(sequence);
            if (this.connectedSequences.contains(sequence)) continue;
            try {
                if (sequence instanceof DefaultSequence && !this.connectedSequences.contains(this.getDefaultSequence())) {
                    this.getDefaultSequence().onConnect(this.getOwnerSession().getDatasourcePlatform());
                    this.connectedSequences.add(nAlreadyConnectedSequences, this.getDefaultSequence());
                    shouldUseTransaction |= this.getDefaultSequence().shouldUseTransaction();
                    shouldUsePreallocation |= this.getDefaultSequence().shouldUsePreallocation();
                    shouldAcquireValueAfterInsert |= this.getDefaultSequence().shouldAcquireValueAfterInsert();
                }
                sequence.onConnect(this.getOwnerSession().getDatasourcePlatform());
                this.connectedSequences.addElement(sequence);
                shouldUseTransaction |= sequence.shouldUseTransaction();
                shouldUsePreallocation |= sequence.shouldUsePreallocation();
                shouldAcquireValueAfterInsert |= sequence.shouldAcquireValueAfterInsert();
                continue;
            }
            catch (RuntimeException ex) {
                i = this.connectedSequences.size() - 1;
                ** while (i >= nAlreadyConnectedSequences)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                    sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                }
                catch (RuntimeException v0) {}
                --i;
                continue;
            }
lbl51:
            // 1 sources

            if (nAlreadyConnectedSequences == 0) {
                this.connectedSequences = null;
            }
            throw ex;
        }
        if (nAlreadyConnectedSequences == 0) {
            if (shouldAcquireValueAfterInsert && !shouldUsePreallocation) {
                this.whenShouldAcquireValueForAll = 1;
            } else if (!shouldAcquireValueAfterInsert && shouldUsePreallocation) {
                this.whenShouldAcquireValueForAll = -1;
            }
        } else if (this.whenShouldAcquireValueForAll == 1) {
            if (!shouldAcquireValueAfterInsert || shouldUsePreallocation) {
                this.whenShouldAcquireValueForAll = 0;
            }
        } else if (this.whenShouldAcquireValueForAll == -1 && (shouldAcquireValueAfterInsert || !shouldUsePreallocation)) {
            this.whenShouldAcquireValueForAll = 0;
        }
        this.atLeastOneSequenceShouldUseTransaction |= shouldUseTransaction;
        this.atLeastOneSequenceShouldUsePreallocation |= shouldUsePreallocation;
    }

    protected void onDisconnectSequences(int nAlreadyConnectedSequences) {
        RuntimeException exception = null;
        int i = this.connectedSequences.size() - 1;
        while (i >= nAlreadyConnectedSequences) {
            block5: {
                try {
                    Sequence sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                    sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                }
                catch (RuntimeException ex) {
                    if (exception != null) break block5;
                    exception = ex;
                }
            }
            --i;
        }
        if (nAlreadyConnectedSequences == 0) {
            this.connectedSequences = null;
            this.whenShouldAcquireValueForAll = 0;
            this.atLeastOneSequenceShouldUseTransaction = false;
            this.atLeastOneSequenceShouldUsePreallocation = false;
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void initializeStates(int nAlreadyConnectedSequences) {
        if (this.states == null) {
            this.states = new State[4];
        }
        int nSize = this.connectedSequences.size();
        int i = nAlreadyConnectedSequences;
        while (i < nSize) {
            Sequence sequence2 = (Sequence)this.connectedSequences.get(i);
            State state = this.getState(sequence2.shouldUsePreallocation(), sequence2.shouldUseTransaction());
            if (state == null) {
                this.createState(sequence2.shouldUsePreallocation(), sequence2.shouldUseTransaction());
            }
            ++i;
        }
    }

    protected void clearStates() {
        this.states = null;
    }

    protected int getStateId(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            return 0;
        }
        if (!shouldUseTransaction) {
            return 1;
        }
        if (this.getConnectionHandler() == null) {
            return 2;
        }
        return 3;
    }

    protected State getState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        return this.states[this.getStateId(shouldUsePreallocation, shouldUseTransaction)];
    }

    protected void createState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            this.states[0] = new NoPreallocation_State();
        } else if (!shouldUseTransaction) {
            this.states[1] = new Preallocation_NoTransaction_State();
        } else if (this.getConnectionHandler() == null) {
            this.states[2] = new Preallocation_Transaction_NoAccessor_State();
        } else {
            this.states[3] = new Preallocation_Transaction_Accessor_State();
        }
    }

    protected void createSequencingCallbackFactory() {
        if (this.states[2] != null) {
            this.setSequencingCallbackFactory(this.states[2].getSequencingCallbackFactory());
        } else {
            this.setSequencingCallbackFactory(null);
        }
    }

    @Override
    public Object getNextValue(AbstractSession writeSession, Class cls) {
        Sequence sequence2 = this.getSequence(cls);
        State state = this.getState(sequence2.shouldUsePreallocation(), sequence2.shouldUseTransaction());
        return state.getNextValue(sequence2, writeSession);
    }

    protected void logDebugSequencingConnected(int nAlreadyConnectedSequences) {
        Vector[] sequenceVectors = new Vector[4];
        int size2 = this.connectedSequences.size();
        int i = nAlreadyConnectedSequences;
        while (i < size2) {
            Sequence sequence2 = (Sequence)this.connectedSequences.get(i);
            int stateId = this.getStateId(sequence2.shouldUsePreallocation(), sequence2.shouldUseTransaction());
            Vector<Sequence> v = sequenceVectors[stateId];
            if (v == null) {
                sequenceVectors[stateId] = v = new Vector<Sequence>();
            }
            v.addElement(sequence2);
            ++i;
        }
        i = 0;
        while (i < 4) {
            Vector v = sequenceVectors[i];
            if (v != null) {
                this.getOwnerSession().log(1, "sequencing", "sequencing_connected", this.states[i]);
                int j = 0;
                while (j < v.size()) {
                    Sequence sequence3 = (Sequence)v.elementAt(j);
                    Object[] args = new Object[]{sequence3.getName(), Integer.toString(sequence3.getPreallocationSize()), Integer.toString(sequence3.getInitialValue())};
                    this.getOwnerSession().log(1, "sequencing", "sequence_without_state", args);
                    ++j;
                }
            }
            ++i;
        }
    }

    public int getPreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public int getInitialValue() {
        return this.getDefaultSequence().getInitialValue();
    }

    @Override
    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    protected Sequence getDefaultSequence() {
        return this.getOwnerSession().getDatasourcePlatform().getDefaultSequence();
    }

    protected Sequence getSequence(String seqName) {
        return this.getOwnerSession().getDatasourcePlatform().getSequence(seqName);
    }

    @Override
    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    private String getContext(AbstractSession writeSession) {
        String tenantContext;
        SchemaPerMultitenantPolicy tableMtPolicy;
        MultitenantPolicy policy;
        String context = "default";
        if (writeSession != null && (policy = writeSession.getProject().getMultitenantPolicy()) != null && policy.isSchemaPerMultitenantPolicy() && (tableMtPolicy = (SchemaPerMultitenantPolicy)policy).isSchemaPerTable() && (tenantContext = (String)writeSession.getProperty(tableMtPolicy.getContextProperty())) != null) {
            context = tenantContext;
        }
        return context;
    }

    class NoPreallocation_State
    extends State {
        NoPreallocation_State() {
        }

        @Override
        public Object getNextValue(Sequence sequence2, AbstractSession writeSession) {
            return sequence2.getGeneratedValue(null, writeSession);
        }
    }

    class Preallocation_NoTransaction_State
    extends State {
        Preallocation_NoTransaction_State() {
        }

        @Override
        public Object getNextValue(Sequence sequence2, AbstractSession writeSession) {
            String seqName = sequence2.getName();
            if (sequence2.getPreallocationSize() > 1) {
                PreallocationHandler handler = SequencingManager.this.getPreallocationHandler(SequencingManager.this.getContext(writeSession));
                Queue sequencesForName = handler.getPreallocated(seqName);
                Object sequenceValue = sequencesForName.poll();
                if (sequenceValue != null) {
                    return sequenceValue;
                }
                ConcurrencyManager lock2 = SequencingManager.this.acquireLock(seqName);
                try {
                    sequenceValue = sequencesForName.poll();
                    if (sequenceValue != null) {
                        Object e = sequenceValue;
                        return e;
                    }
                    Vector sequences = sequence2.getGeneratedVector(null, writeSession);
                    sequenceValue = sequences.remove(0);
                    handler.setPreallocated(seqName, sequences);
                    SequencingManager.this.logDebugPreallocation(seqName, sequenceValue, sequences);
                }
                finally {
                    lock2.release();
                }
                return sequenceValue;
            }
            return sequence2.getGeneratedVector(null, writeSession).firstElement();
        }
    }

    class Preallocation_Transaction_Accessor_State
    extends State {
        Preallocation_Transaction_Accessor_State() {
        }

        @Override
        public Object getNextValue(Sequence sequence2, AbstractSession writeSession) {
            String seqName = sequence2.getName();
            if (sequence2.getPreallocationSize() > 1) {
                PreallocationHandler handler = SequencingManager.this.getPreallocationHandler(SequencingManager.this.getContext(writeSession));
                Queue sequencesForName = handler.getPreallocated(seqName);
                Object sequenceValue = sequencesForName.poll();
                if (sequenceValue != null) {
                    return sequenceValue;
                }
                ConcurrencyManager lock2 = SequencingManager.this.acquireLock(seqName);
                try {
                    sequenceValue = sequencesForName.poll();
                    if (sequenceValue != null) {
                        Object e = sequenceValue;
                        return e;
                    }
                    Accessor accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
                    try {
                        accessor.beginTransaction(writeSession);
                        try {
                            Vector sequences = sequence2.getGeneratedVector(accessor, writeSession);
                            accessor.commitTransaction(writeSession);
                            sequenceValue = sequences.remove(0);
                            handler.setPreallocated(seqName, sequences);
                            SequencingManager.this.logDebugPreallocation(seqName, sequenceValue, sequences);
                        }
                        catch (RuntimeException ex) {
                            try {
                                accessor.rollbackTransaction(writeSession);
                            }
                            catch (Exception exception) {}
                            throw ex;
                        }
                    }
                    finally {
                        SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                    }
                }
                finally {
                    lock2.release();
                }
                return sequenceValue;
            }
            Accessor accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
            try {
                accessor.beginTransaction(writeSession);
                try {
                    Object sequenceValue = sequence2.getGeneratedVector(accessor, writeSession).firstElement();
                    accessor.commitTransaction(writeSession);
                    Object e = sequenceValue;
                    return e;
                }
                catch (RuntimeException ex) {
                    try {
                        accessor.rollbackTransaction(writeSession);
                    }
                    catch (Exception exception) {}
                    throw ex;
                }
            }
            finally {
                SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
            }
        }
    }

    class Preallocation_Transaction_NoAccessor_State
    extends State
    implements SequencingCallbackFactory {
        Preallocation_Transaction_NoAccessor_State() {
        }

        @Override
        SequencingCallbackFactory getSequencingCallbackFactory() {
            return this;
        }

        @Override
        public SequencingCallback createSequencingCallback() {
            return new SequencingCallbackImpl();
        }

        void afterCommitInternal(String context, Map localSequences, Accessor accessor) {
            for (Map.Entry entry2 : localSequences.entrySet()) {
                String seqName = (String)entry2.getKey();
                Vector localSequenceForName = (Vector)entry2.getValue();
                if (localSequenceForName.isEmpty()) continue;
                SequencingManager.this.getPreallocationHandler(context).setPreallocated(seqName, localSequenceForName);
                localSequenceForName.clear();
            }
            if (accessor != null) {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null, accessor);
            } else {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null);
            }
        }

        SequencingCallbackImpl getCallbackImpl(AbstractSession writeSession, Accessor accessor) {
            SequencingCallbackImpl seqCallbackImpl = writeSession.hasExternalTransactionController() ? (SequencingCallbackImpl)writeSession.getExternalTransactionController().getActiveSequencingCallback(SequencingManager.this.getOwnerSession(), this.getSequencingCallbackFactory()) : (SequencingCallbackImpl)accessor.getSequencingCallback(this.getSequencingCallbackFactory());
            seqCallbackImpl.context = SequencingManager.this.getContext(writeSession);
            return seqCallbackImpl;
        }

        @Override
        public Object getNextValue(Sequence sequence2, AbstractSession writeSession) {
            String seqName = sequence2.getName();
            if (sequence2.getPreallocationSize() > 1) {
                Vector localSequencesForName;
                Queue sequencesForName = SequencingManager.this.getPreallocationHandler(SequencingManager.this.getContext(writeSession)).getPreallocated(seqName);
                Object sequenceValue = sequencesForName.poll();
                if (sequenceValue != null) {
                    return sequenceValue;
                }
                boolean keepLocked = false;
                ConcurrencyManager lock2 = null;
                if (!SequencingManager.this.getOwnerSession().getDatasourceLogin().shouldUseExternalTransactionController() && !writeSession.isInTransaction()) {
                    lock2 = SequencingManager.this.acquireLock(seqName);
                    try {
                        sequenceValue = sequencesForName.poll();
                        if (sequenceValue != null) {
                            Object e = sequenceValue;
                            return e;
                        }
                        writeSession.beginTransaction();
                        keepLocked = true;
                    }
                    finally {
                        if (!keepLocked) {
                            lock2.release();
                        }
                    }
                }
                if (!keepLocked) {
                    writeSession.beginTransaction();
                }
                try {
                    Accessor accessor = writeSession.getAccessor();
                    SequencingCallbackImpl seqCallbackImpl = this.getCallbackImpl(writeSession, accessor);
                    Map localSequences = seqCallbackImpl.getPreallocatedSequenceValues();
                    localSequencesForName = (Vector)localSequences.get(seqName);
                    if (localSequencesForName == null || localSequencesForName.isEmpty()) {
                        localSequencesForName = sequence2.getGeneratedVector(null, writeSession);
                        localSequences.put(seqName, localSequencesForName);
                        SequencingManager.this.logDebugLocalPreallocation(writeSession, seqName, localSequencesForName, accessor);
                    }
                }
                catch (RuntimeException ex) {
                    if (keepLocked) {
                        lock2.release();
                    }
                    try {
                        writeSession.rollbackTransaction();
                    }
                    catch (Exception exception) {}
                    throw ex;
                }
                try {
                    try {
                        writeSession.commitTransaction();
                    }
                    catch (DatabaseException ex) {
                        try {
                            writeSession.rollbackTransaction();
                        }
                        catch (Exception exception) {}
                        throw ex;
                    }
                    if (!localSequencesForName.isEmpty()) {
                        Object e = sequenceValue = localSequencesForName.remove(0);
                        return e;
                    }
                    sequenceValue = sequencesForName.poll();
                    if (sequenceValue != null) {
                        Object e = sequenceValue;
                        return e;
                    }
                    Object object = this.getNextValue(sequence2, writeSession);
                    return object;
                }
                finally {
                    if (keepLocked) {
                        lock2.release();
                    }
                }
            }
            writeSession.beginTransaction();
            try {
                Object sequenceValue = sequence2.getGeneratedVector(null, writeSession).firstElement();
                writeSession.commitTransaction();
                return sequenceValue;
            }
            catch (RuntimeException ex) {
                try {
                    writeSession.rollbackTransaction();
                }
                catch (Exception exception) {}
                throw ex;
            }
        }

        final class SequencingCallbackImpl
        implements SequencingCallback {
            Map localSequences = new HashMap();
            String context;

            SequencingCallbackImpl() {
            }

            @Override
            public void afterCommit(Accessor accessor) {
                Preallocation_Transaction_NoAccessor_State.this.afterCommitInternal(this.context, this.localSequences, accessor);
            }

            public Map getPreallocatedSequenceValues() {
                return this.localSequences;
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract Object getNextValue(Sequence var1, AbstractSession var2);

        SequencingCallbackFactory getSequencingCallbackFactory() {
            return null;
        }

        public String toString() {
            String name = this.getClass().getName();
            return name.substring(name.lastIndexOf(36) + 1);
        }
    }
}

